/**
 * Copyright 2014-2019 XebiaLabs Inc. and its affiliates. Use is subject to terms of the enclosed Legal Notice.
 */
package com.xebialabs.xlplatform.security.dto;

import com.xebialabs.xlplatform.documentation.PublicApiRef;

import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;

/**
 * Contains information about password validation.
 */
@PublicApiRef
@XmlRootElement(name = "password-validation-result")
public class PasswordValidationResult {

    private boolean isValid;

    private String message;

    public PasswordValidationResult(boolean isValid, String message) {
        this.isValid = isValid;
        this.message = message;
    }

    /**
     * @return Is the password valid according to the given criteria.
     */
    @XmlElement(name = "isValid")
    public boolean isValid() {
        return isValid;
    }

    /**
     * @return Password criteria description.
     */
    @XmlElement(name = "message")
    public String getMessage() {
        return message;
    }
}
