/**
 * Copyright 2014-2019 XebiaLabs Inc. and its affiliates. Use is subject to terms of the enclosed Legal Notice.
 */
package com.xebialabs.deployit.engine.api.dto

import java.io.IOException
import java.util

import com.fasterxml.jackson.core.`type`.TypeReference
import com.fasterxml.jackson.databind.ObjectMapper

object ConfigurationItemProperties {
  @throws[IOException]
  def valueOf(properties: String): ConfigurationItemProperties = {
    val objectMapper: ObjectMapper = new ObjectMapper
    val ciProperties: util.Map[String, String] = objectMapper.readValue(properties, new TypeReference[util.Map[String, String]]() {})
    new ConfigurationItemProperties(ciProperties)
  }
}

class ConfigurationItemProperties(val properties: util.Map[String, String])
