/**
 * Copyright 2014-2019 XebiaLabs Inc. and its affiliates. Use is subject to terms of the enclosed Legal Notice.
 */
package com.xebialabs.deployit.engine.api;

import com.xebialabs.deployit.engine.api.dto.ConfigurationItemId;
import com.xebialabs.deployit.engine.api.dto.Ordering;
import com.xebialabs.deployit.engine.api.dto.Paging;
import com.xebialabs.deployit.engine.api.dto.SatelliteInfo;
import com.xebialabs.xlplatform.documentation.PublicApi;

import jakarta.ws.rs.*;
import jakarta.ws.rs.core.MediaType;
import java.util.List;

/**
 * Services related to XL Satellites and hosts attached to them.
 */
@Path("/satellite")
@Produces({MediaType.TEXT_XML, MediaType.APPLICATION_XML, MediaType.APPLICATION_JSON})
@PublicApi
public interface SatelliteService {

    /**
     * Returns information about the configuration of the satellite. For example: version.
     *
     * @return an information object.
     */
    @GET
    @Path("info/{id:.+}")
    SatelliteInfo getInfo(@PathParam("id") String ciId);


    /**
     * Returns information about the configuration of the satellite. For example: version.
     *
     * @return an list of information objects.
     */
    @GET
    @Path("info")
    List<SatelliteInfo> getInfos(@QueryParam("ids") List<String> ids);

    @GET
    @Path("hosts/{id:.+}")
    List<ConfigurationItemId> listHosts(
            @PathParam("id") String ciId,
            @QueryParam("name") String name,
            @BeanParam Paging paging,
            @QueryParam("order") Ordering order);

    @GET
    @Path("hosts/count/{id:.+}")
    Integer countHosts(
            @PathParam("id") String ciId,
            @QueryParam("name") String name);
}
