/**
 * Copyright 2014-2019 XebiaLabs Inc. and its affiliates. Use is subject to terms of the enclosed Legal Notice.
 */
package com.xebialabs.deployit.engine.api.dto;

import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.xlplatform.documentation.PublicApiRef;

/**
 * A reference to a {@link com.xebialabs.deployit.plugin.api.udm.ConfigurationItem}, containing the {@code id}, {@code type} and {@code $referenceId}.
 */
@PublicApiRef
public class ConfigurationItemIdAndReferenceId extends ConfigurationItemId {

    private String referenceId;

    public ConfigurationItemIdAndReferenceId() {
    }

    /**
     * @param id          The id of the {@link com.xebialabs.deployit.plugin.api.udm.ConfigurationItem}.
     * @param type        The type of the {@link com.xebialabs.deployit.plugin.api.udm.ConfigurationItem}.
     * @param referenceId The $referenceId of the {@link com.xebialabs.deployit.plugin.api.udm.ConfigurationItem}.
     */
    public ConfigurationItemIdAndReferenceId(String id, Type type, String referenceId) {
        super(id, type);
        this.referenceId = referenceId;
    }

    /**
     * @return The $referenceId of the {@link com.xebialabs.deployit.plugin.api.udm.ConfigurationItem}.
     */
    public String getReferenceId() {
        return referenceId;
    }

    /**
     * @param referenceId The $referenceId of the {@link com.xebialabs.deployit.plugin.api.udm.ConfigurationItem}.
     */
    public void setReferenceId(String referenceId) {
        this.referenceId = referenceId;
    }

    @Override
    public String toString() {
        return String.format("%s, %s [%s]", getId(), getType(), referenceId);
    }
}
