/**
 * Copyright 2014-2019 XebiaLabs Inc. and its affiliates. Use is subject to terms of the enclosed Legal Notice.
 */
package com.xebialabs.deployit.engine.api.dto;

import com.xebialabs.xlplatform.documentation.PublicApiRef;

import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;

/**
 * The object for aggregate summary of the tasks currently running and waiting in the queue.
 */
@PublicApiRef
@XmlRootElement(name = "task-queue-summary")
public class TaskQueueSummary extends AbstractDto {

    private int numOfRunningTasks;
    private int numOfQueuedTasks;
    private int maxQueueWaitingTimeSeconds;

    public TaskQueueSummary() {
    }

    public TaskQueueSummary(int numOfRunningTasks, int numOfQueuedTasks, int maxQueueWaitingTimeSeconds) {
        this.numOfRunningTasks = numOfRunningTasks;
        this.numOfQueuedTasks = numOfQueuedTasks;
        this.maxQueueWaitingTimeSeconds = maxQueueWaitingTimeSeconds;
    }

    @XmlElement(name = "number-of-running-tasks")
    public int getNumOfRunningTasks() {
        return numOfRunningTasks;
    }

    @XmlElement(name = "number-of-queued-tasks")
    public int getNumOfQueuedTasks() {
        return numOfQueuedTasks;
    }

    @XmlElement(name = "max-queue-waiting-time-seconds")
    public int getMaxQueueWaitingTimeSeconds() {
        return maxQueueWaitingTimeSeconds;
    }
}
