/**
 * Copyright 2014-2019 XebiaLabs Inc. and its affiliates. Use is subject to terms of the enclosed Legal Notice.
 */
package com.xebialabs.deployit.engine.api.dto;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

import com.xebialabs.xlplatform.documentation.PublicApiRef;

import static java.util.Collections.unmodifiableList;

/**
 * The parameter object of a selected deployment action.
 */
@PublicApiRef
public class SelectedDeployment {

    private List<String> selectedDeployableIds;

    private Deployment deployment;

    public SelectedDeployment(final List<String> selectedDeployableIds, final Deployment deployment) {
        setSelectedDeployableIds(selectedDeployableIds);
        setDeployment(deployment);
    }

    public SelectedDeployment() {
        this(Collections.<String>emptyList(), null);
    }

    /**
     * @return deployment action.
     */
    public Deployment getDeployment() {
        return deployment;
    }

    /**
     * @param deployment  deployment action.
     */
    public void setDeployment(final Deployment deployment) {
        this.deployment = deployment;
    }

    /**
     *
     * @return deployables that are active in the deployment
     */
    public List<String> getSelectedDeployableIds() {
        return unmodifiableList(selectedDeployableIds);
    }

    /**
     *
     * @param selectedDeployableIds ids of deployables that are active in the deployment
     */
    public void setSelectedDeployableIds(final List<String> selectedDeployableIds) {
        this.selectedDeployableIds = new ArrayList<>(selectedDeployableIds);
    }
}
