/**
 * Copyright 2014-2019 XebiaLabs Inc. and its affiliates. Use is subject to terms of the enclosed Legal Notice.
 */
package com.xebialabs.deployit.engine.api.dto;

import com.xebialabs.xlplatform.documentation.PublicApiRef;

import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement(name = "general-info")
@PublicApiRef
public class GeneralUsageInfo {

    private String deployVersion;

    private String instanceName;

    private String serverUrl;

    private String vmArguments;

    private String vmName;

    private String systemName;

    private String upTime;

    private String osName;

    private String osArchitecture;

    private Integer osAvailableProcessors = 0;

    private Long maxMemory = 0L;

    private Long usedMemory = 0L;

    private String databaseImplementation;

    private String reportingDatabaseImplementation;

    private Long noHitDBQueryDuration = 0L;

    private Long hitDBQueryDuration = 0L;

    private Boolean isNodeActive = false;

    @XmlAttribute
    public String getDeployVersion() {
        return deployVersion;
    }

    public void setDeployVersion(String deployVersion) {
        this.deployVersion = deployVersion;
    }

    @XmlAttribute
    public String getInstanceName() {
        return instanceName;
    }

    public void setInstanceName(String instanceName) {
        this.instanceName = instanceName;
    }

    @XmlAttribute
    public String getServerUrl() {
        return serverUrl;
    }

    public void setServerUrl(String serverUrl) {
        this.serverUrl = serverUrl;
    }

    @XmlAttribute
    public String getVmArguments() {
        return vmArguments;
    }

    public void setVmArguments(String vmArguments) {
        this.vmArguments = vmArguments;
    }

    @XmlAttribute
    public String getVmName() {
        return vmName;
    }

    public void setVmName(String vmName) {
        this.vmName = vmName;
    }

    @XmlAttribute
    public String getSystemName() {
        return systemName;
    }

    public void setSystemName(String systemName) {
        this.systemName = systemName;
    }

    @XmlAttribute
    public String getUpTime() {
        return upTime;
    }

    public void setUpTime(String upTime) {
        this.upTime = upTime;
    }

    @XmlAttribute
    public String getOsName() {
        return osName;
    }

    public void setOsName(String osName) {
        this.osName = osName;
    }

    @XmlAttribute
    public String getOsArchitecture() {
        return osArchitecture;
    }

    public void setOsArchitecture(String osArchitecture) {
        this.osArchitecture = osArchitecture;
    }

    @XmlAttribute
    public Integer getOsAvailableProcessors() {
        return osAvailableProcessors;
    }

    public void setOsAvailableProcessors(Integer osAvailableProcessors) {
        this.osAvailableProcessors = osAvailableProcessors;
    }

    @XmlAttribute
    public Long getMaxMemory() {
        return maxMemory;
    }

    public void setMaxMemory(Long maxMemory) {
        this.maxMemory = maxMemory;
    }

    @XmlAttribute
    public Long getUsedMemory() {
        return usedMemory;
    }

    public void setUsedMemory(Long usedMemory) {
        this.usedMemory = usedMemory;
    }

    @XmlAttribute
    public String getDatabaseImplementation() {
        return databaseImplementation;
    }

    public void setDatabaseImplementation(String databaseImplementation) {
        this.databaseImplementation = databaseImplementation;
    }

    @XmlAttribute
    public String getReportingDatabaseImplementation() {
        return reportingDatabaseImplementation;
    }

    public void setReportingDatabaseImplementation(String reportingDatabaseImplementation) {
        this.reportingDatabaseImplementation = reportingDatabaseImplementation;
    }

    @XmlAttribute
    public Long getNoHitDBQueryDuration() {
        return noHitDBQueryDuration;
    }

    public void setNoHitDBQueryDuration(Long noHitDBQueryDuration) {
        this.noHitDBQueryDuration = noHitDBQueryDuration;
    }

    @XmlAttribute
    public Long getHitDBQueryDuration() {
        return hitDBQueryDuration;
    }

    public void setHitDBQueryDuration(Long hitDBQueryDuration) {
        this.hitDBQueryDuration = hitDBQueryDuration;
    }

    @XmlAttribute
    public Boolean getIsNodeActive() {
        return isNodeActive;
    }

    public void setIsNodeActive(Boolean isNodeActive) {
        this.isNodeActive = isNodeActive;
    }
}
