/**
 * Copyright 2014-2019 XebiaLabs Inc. and its affiliates. Use is subject to terms of the enclosed Legal Notice.
 */
package com.xebialabs.deployit.engine.api.dto

import org.joda.time.DateTime


case class ApplicationDeploymentPackage(operation: String, applicationName: String, versionTag: VersionTag)

case class DeployedApplicationPackage(operation: String, applicationName: String, applicationPath: String, versionTag: VersionTag, destination: String, namespace: String)

case class ApplicationDeploymentPackageState(applicationName: String, applicationPath: String, state: DeploymentPackageState)

case class VersionTag(label: String, state: String)

case class DeploymentPackageState(destination: String,
                                  namespace: String,
                                  versionTag: VersionTag,
                                  deploymentStatus: String,
                                  deploymentType: String,
                                  user: String,
                                  lastChangeTime: DateTime)

sealed abstract class StateOperation(label: String)

object StateOperation {
  final val CreateState = "create"
  final val RemoveState = "remove"
}
