/**
 * Copyright 2014-2019 XebiaLabs Inc. and its affiliates. Use is subject to terms of the enclosed Legal Notice.
 */
package com.xebialabs.deployit.engine.api.dto.report;

import com.xebialabs.deployit.engine.api.dto.AbstractDto;
import com.xebialabs.xlplatform.documentation.PublicApiRef;

import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

/**
 * Contains information about overall number of deployments per deployment state.
 */
@PublicApiRef
@XmlRootElement(name = "deployment-status-overview")
public class DeploymentsStatusOverview extends AbstractDto {

    private int noOfSuccessfulDeployments;
    private int noOfFailedDeployments;
    private int noOfAbortedDeployments;
    private int noOfRollbacks;
    private int totalDeployments;

    public DeploymentsStatusOverview() {
    }

    public DeploymentsStatusOverview(int noOfSuccessfulDeployments, int noOfFailedDeployments, int noOfAbortedDeployments, int noOfRollbacks, int total) {
        this.noOfSuccessfulDeployments = noOfSuccessfulDeployments;
        this.noOfFailedDeployments = noOfFailedDeployments;
        this.noOfAbortedDeployments = noOfAbortedDeployments;
        this.noOfRollbacks = noOfRollbacks;
        this.totalDeployments = total;
    }

    /**
     * @return The number of successful deployments.
     */
    @XmlElement(name = "number-of-successful-deployments")
    public int getNoOfSuccessfulDeployments() {
        return noOfSuccessfulDeployments;
    }

    /**
     * @return The number of failed deployments.
     */
    @XmlElement(name = "number-of-failed-deployments")
    public int getNoOfFailedDeployments() {
        return noOfFailedDeployments;
    }

    /**
     * @return The number of aborted deployments.
     */
    @XmlElement(name = "number-of-aborted-deployments")
    public int getNoOfAbortedDeployments() {
        return noOfAbortedDeployments;
    }

    /**
     * @return The number of rollbacks.
     */
    @XmlElement(name = "number-of-rollbacks")
    public int getNoOfRollbacks() {
        return noOfRollbacks;
    }

    /**
     * @return The total number of deployments.
     */
    @XmlElement(name = "total-deployments")
    public int getTotalDeployments() {
        return totalDeployments;
    }
}
