/**
 * Copyright 2014-2019 XebiaLabs Inc. and its affiliates. Use is subject to terms of the enclosed Legal Notice.
 */
package com.xebialabs.deployit.engine.api.task;

import java.util.List;
import java.util.Map;

import com.xebialabs.deployit.plugin.api.flow.Step;
import org.springframework.security.core.Authentication;

/**
 * Service which allows you to create tasks in the standard task execution context of the server.
 * Using this service it is possible to create tasks from the platform.
 */
public interface TaskCreationService {

    /**
     * Create and register a task with given steps and metadata. The task ID is returned.
     * Note that task is not started automatically.
     */
    String createWithStepBlock(Authentication owner, String description, List<Step> steps, Map<String, String> metadata);

}
