/**
 * Copyright 2014-2019 XebiaLabs Inc. and its affiliates. Use is subject to terms of the enclosed Legal Notice.
 */
package com.xebialabs.deployit.engine.api.execution;

import com.xebialabs.deployit.engine.api.dto.AbstractDto;
import com.xebialabs.xlplatform.documentation.PublicApiRef;

/**
 * Contains the information about the generated block.
 */
@PublicApiRef
public class TaskPreviewBlock extends AbstractDto {

    private String id;
    private BlockState block;

    public TaskPreviewBlock() {
    }

    public TaskPreviewBlock(String id) {
        this.id = id;
    }

    public TaskPreviewBlock(String id, BlockState block) {
        this.id = id;
        this.block = block;
    }

    /**
     * @param id The id of the preview.
     */
    public void setId(String id) {
        this.id = id;
    }

    /**
     * @return The id of the preview.
     */
    public String getId() {
        return id;
    }

    /**
     * @param block The block details.
     */
    public void setBlock(BlockState block) {
        this.block = block;
    }

    /**
     * @return The block details.
     */
    public BlockState getBlock() {
        return block;
    }
}
