/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.engine.api;

import com.xebialabs.deployit.engine.api.dto.Paging;
import com.xebialabs.deployit.engine.api.dto.TaskPathStatus;
import com.xebialabs.deployit.engine.api.execution.BlockState;
import com.xebialabs.deployit.engine.api.execution.FetchMode;
import com.xebialabs.deployit.engine.api.execution.IncludeStepBlocks;
import com.xebialabs.deployit.engine.api.execution.StepBlockState;
import com.xebialabs.deployit.engine.api.execution.StepState;
import com.xebialabs.deployit.engine.api.execution.TaskWithBlock;
import com.xebialabs.xlplatform.documentation.PublicApi;
import java.util.List;
import java.util.stream.Stream;
import javax.ws.rs.BeanParam;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import org.joda.time.DateTime;
import org.joda.time.LocalDate;

@Path(value="/tasks/v2")
@Consumes(value={"application/xml", "application/json"})
@Produces(value={"application/xml", "application/json"})
@PublicApi
public interface TaskBlockService {
    @GET
    @Path(value="current")
    public List<TaskWithBlock> getMyCurrentTasks(@QueryParam(value="fetchMode") FetchMode var1);

    @GET
    @Path(value="current/all")
    public List<TaskWithBlock> getAllCurrentTasks(@QueryParam(value="fetchMode") FetchMode var1);

    @GET
    @Path(value="current/satellite")
    public List<TaskWithBlock> getMySatelliteTasks(@QueryParam(value="satelliteId") String var1, @QueryParam(value="fetchMode") FetchMode var2);

    @GET
    @Path(value="current/all/satellite")
    public List<TaskWithBlock> getCurrentSatelliteTasks(@QueryParam(value="satelliteId") String var1, @QueryParam(value="fetchMode") FetchMode var2);

    @GET
    @Path(value="{taskid}")
    public TaskWithBlock getTask(@PathParam(value="taskid") String var1);

    @GET
    @Path(value="{taskid}/block/{blockPath}")
    public BlockState getBlock(@PathParam(value="taskid") String var1, @PathParam(value="blockPath") String var2);

    @GET
    @Path(value="{taskid}/block/{blockPath}/step")
    public StepBlockState getSteps(@PathParam(value="taskid") String var1, @PathParam(value="blockPath") String var2);

    @GET
    @Path(value="{taskid}/step/{stepPath}")
    public StepState getStep(@PathParam(value="taskid") String var1, @PathParam(value="stepPath") String var2, @HeaderParam(value="If-Modified-Since") DateTime var3);

    @POST
    @Path(value="{taskid}/start")
    public void start(@PathParam(value="taskid") String var1);

    @POST
    @Path(value="{taskid}/schedule")
    public void schedule(@PathParam(value="taskid") String var1, @QueryParam(value="time") DateTime var2);

    @POST
    @Path(value="{taskid}/stop")
    public void stop(@PathParam(value="taskid") String var1);

    @POST
    @Path(value="{taskid}/abort")
    public void abort(@PathParam(value="taskid") String var1);

    @DELETE
    @Path(value="{taskid}")
    public void cancel(@PathParam(value="taskid") String var1);

    @DELETE
    @Path(value="{taskid}/force")
    public void forceCancel(@PathParam(value="taskid") String var1);

    @POST
    @Path(value="/force-cancel")
    public void forceCancelTasks(List<String> var1);

    @POST
    @Path(value="{taskid}/archive")
    public void archive(@PathParam(value="taskid") String var1);

    @POST
    @Path(value="{taskid}/skip")
    public TaskWithBlock skip(@PathParam(value="taskid") String var1, List<String> var2);

    @POST
    @Path(value="{taskid}/unskip")
    public TaskWithBlock unskip(@PathParam(value="taskid") String var1, List<String> var2);

    @POST
    @Path(value="{taskid}/add-pause/{stepPath}")
    public StepBlockState addPause(@PathParam(value="taskid") String var1, @PathParam(value="stepPath") String var2);

    @POST
    @Path(value="{taskid}/assign/{owner}")
    public TaskWithBlock assign(@PathParam(value="taskid") String var1, @PathParam(value="owner") String var2);

    @POST
    @Path(value="{taskid}/takeover/{owner}")
    public TaskWithBlock takeover(@PathParam(value="taskid") String var1, @PathParam(value="owner") String var2);

    @GET
    @Path(value="query")
    public Stream<TaskWithBlock> query(@QueryParam(value="begindate") LocalDate var1, @QueryParam(value="enddate") LocalDate var2, @BeanParam Paging var3);

    @GET
    @Path(value="export")
    @IncludeStepBlocks
    public Stream<TaskWithBlock> export(@QueryParam(value="begindate") LocalDate var1, @QueryParam(value="enddate") LocalDate var2, @BeanParam Paging var3);

    @GET
    @Path(value="{taskid}/status/{path}")
    public TaskPathStatus getStatus(@PathParam(value="taskid") String var1, @PathParam(value="path") String var2);
}

