/**
 * Copyright 2014-2019 XebiaLabs Inc. and its affiliates. Use is subject to terms of the enclosed Legal Notice.
 */
package com.xebialabs.deployit.engine.api.task;

import com.xebialabs.deployit.engine.api.TaskBlockService;
import com.xebialabs.deployit.engine.api.execution.FetchMode;
import com.xebialabs.deployit.engine.api.execution.TaskWithBlock;

import java.lang.invoke.MethodHandles;
import java.util.List;

/**
 * This class is used to wrap TaskBlockService in order to ensure backwards compatibility for generated clients.
 */
public interface TaskBlockServiceDefaults extends TaskBlockService {

    static MethodHandles.Lookup getLookup() {
        return MethodHandles.lookup();
    }

    default List<TaskWithBlock> getMyCurrentTasks() {
        return getMyCurrentTasks(FetchMode.FULL);
    }

    default List<TaskWithBlock> getAllCurrentTasks() {
        return getAllCurrentTasks(FetchMode.FULL);
    }
}
