/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.documentation;

import com.google.common.collect.Maps;
import com.xebialabs.deployit.ConfigurationItem;
import com.xebialabs.deployit.reflect.ConfigurationItemDescriptor;
import com.xebialabs.deployit.reflect.ConfigurationItemPropertyDescriptor;
import com.xebialabs.deployit.reflect.ConfigurationItemPropertyType;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Formatter;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;
import org.reflections.scanners.TypeAnnotationsScanner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PluginCIMarkdownGenerator {
    private static final Logger logger = LoggerFactory.getLogger(PluginCIMarkdownGenerator.class);

    public static void main(String[] args) throws SecurityException, NoSuchFieldException, IOException {
        String filter = "com.xebialabs.deployit.ci";
        String outputFilename = null;
        if (args.length > 0) {
            outputFilename = args[0];
        }
        if (args.length > 1) {
            filter = args[1];
        }
        logger.info("Generating documentation for CIs matching " + filter + " and appending to file " + outputFilename);
        Reflections reflections = new Reflections(filter, new Scanner[]{new TypeAnnotationsScanner()});
        Set annotatedWith = reflections.getTypesAnnotatedWith(ConfigurationItem.class);
        ArrayList<ConfigurationItemDescriptor> toPrint = new ArrayList<ConfigurationItemDescriptor>();
        for (Class aClass : annotatedWith) {
            logger.info("Adding class {}", (Object)aClass);
            toPrint.add(new ConfigurationItemDescriptor(aClass, (Map)Maps.newHashMap()));
        }
        Collections.sort(toPrint, new Comparator<ConfigurationItemDescriptor>(){

            @Override
            public int compare(ConfigurationItemDescriptor o1, ConfigurationItemDescriptor o2) {
                return o1.getSimpleName().compareTo(o2.getSimpleName());
            }
        });
        StringBuilder sb = new StringBuilder();
        for (ConfigurationItemDescriptor configurationItemDescriptor : toPrint) {
            PluginCIMarkdownGenerator.printHelp(sb, configurationItemDescriptor);
        }
        PluginCIMarkdownGenerator.appendToFile(outputFilename, sb);
    }

    private static void appendToFile(String outputFilename, StringBuilder sb) throws IOException {
        FileWriter fw = new FileWriter(new File(outputFilename), true);
        fw.append(sb);
        fw.close();
    }

    private static void printHelp(StringBuilder sb, ConfigurationItemDescriptor ciDescriptor) {
        sb.append("\n");
        Formatter fmt = new Formatter(sb);
        fmt.format("## %s ##\n\n", ciDescriptor.getSimpleName());
        fmt.format("%s\n\n", ciDescriptor.getDescription());
        fmt.format("_Type_: %s\n\n", ciDescriptor.getType());
        if (ciDescriptor.getPropertyDescriptors().length > 0) {
            fmt.format("_Properties:_\n\n", new Object[0]);
            for (ConfigurationItemPropertyDescriptor property : PluginCIMarkdownGenerator.sortProperties(ciDescriptor.getPropertyDescriptors())) {
                fmt.format("* %s%s(%s)%s: %s\n", property.isRequired() ? "**" : "_", property.getName(), PluginCIMarkdownGenerator.getType(property), property.isRequired() ? "**" : "_", property.getDescription());
                if (property.getType() != ConfigurationItemPropertyType.ENUM) continue;
                fmt.format("    * Values: %s\n", Arrays.toString(property.getEnumValues()));
            }
        }
        sb.append("\n");
        sb.append("\n");
    }

    private static Collection<ConfigurationItemPropertyDescriptor> sortProperties(ConfigurationItemPropertyDescriptor[] propertyDescriptors) {
        List<ConfigurationItemPropertyDescriptor> result = Arrays.asList(propertyDescriptors);
        Collections.sort(result, new Comparator<ConfigurationItemPropertyDescriptor>(){

            @Override
            public int compare(ConfigurationItemPropertyDescriptor o1, ConfigurationItemPropertyDescriptor o2) {
                int result;
                int n = o1.isRequired() == o2.isRequired() ? 0 : (result = o1.isRequired() ? -1 : 1);
                if (result == 0) {
                    result = o1.getName().compareTo(o2.getName());
                }
                return result;
            }
        });
        return result;
    }

    private static String getType(ConfigurationItemPropertyDescriptor property) {
        ConfigurationItemPropertyType type = property.getType();
        if (type == ConfigurationItemPropertyType.CI) {
            return property.getPropertyClassname();
        }
        if (type == ConfigurationItemPropertyType.SET_OF_CIS) {
            return String.format("Set<%s>", property.getCollectionMemberClassname());
        }
        if (type == ConfigurationItemPropertyType.SET_OF_STRINGS) {
            return "Set<String>";
        }
        if (type == ConfigurationItemPropertyType.LIST_OF_OBJECTS) {
            return String.format("List<%s>", property.getCollectionMemberClassname());
        }
        return property.getType().name();
    }
}

