/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.documentation;

import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import com.google.common.io.Closeables;
import com.xebialabs.deployit.documentation.CiReferenceHtmlGenerator;
import com.xebialabs.deployit.documentation.ContextProperties;
import com.xebialabs.deployit.documentation.IOUtils;
import com.xebialabs.deployit.documentation.WkhtmlPdfGenerator;
import com.xebialabs.overthere.RuntimeIOException;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.kohsuke.args4j.CmdLineException;
import org.kohsuke.args4j.CmdLineParser;
import org.kohsuke.args4j.Option;
import org.pegdown.PegDownProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DocumentGenerator {
    @Option(name="-pdfCover", usage="Url to the html page that is to be used as the cover page in the generated pdf.")
    private URL pdfCoverHtml;
    @Option(name="-pdfFooter", usage="Url to the html page that is to be used as the footer on each page in the generated pdf.")
    private URL pdfFooterHtml;
    @Option(name="-pdfHeader", usage="Url to the html page that is to be used as the footer on each page in the generated pdf.")
    private URL pdfHeaderHtml;
    @Option(name="-pdfTocXsl", usage="Url to the xsl that is to be used to generate the html page for the table of content in the generated pdf.")
    private URL pdfTocXsl;
    @Option(name="-htmlFooter", usage="Url to the html snippet that is appended to the generated html document.")
    private URL htmlFooterSnippet;
    @Option(name="-htmlHeader", usage="Url to the html snippet that is added to the head tag in the generated html document.")
    private URL htmlHeaderSnippet;
    @Option(name="-resource", usage="Url to the web resource file(s)/zip(s) or local file(s)/folder(s) containing resources like images, css, etc.")
    private List<URL> resources = Lists.newArrayList();
    @Option(name="-single", usage="Generate a single document from the multiple sources")
    private boolean generateSingleDocument;
    @Option(name="-generatePdf", usage="Indicates if pdf documentation must be generated. Default is false.")
    private boolean generatePdf;
    @Option(name="-source", usage="Markdown file(s) used as the source for document generation.", required=true)
    private List<File> markdownSources = Lists.newArrayList();
    @Option(name="-workingDir", usage="Working directory to which documents are generated to.", required=true)
    private File workingDir;
    @Option(name="-properties", usage="Properties used to customize the generation for individual documents.\nProperty name is a compound key, starting with the document file name without extension. eg. filePluginManual\n'appendCiReference' : Specify if the document requires ci reference documentation append. eg. filePluginManual.appendCiReference=true.\n'prefixes' : Comma separated string for which plugin namespaces get generated ci documentation.eg. filePluginManual.prefixes=file,udm.\n             Omitted prefixes results in ci reference documentation for all types.\n 'title' : Tile of the documents as it appears on the pdf cover eg. filePluginManual.title=File Manual\n 'version' : Version of the plugin.\n\n You can supply any other property you may need to replace during generation. You can use {{prop}} as the placeholder in your markdowon.")
    private File propertiesSource;
    @Option(name="-wkhtmltopdf", usage="Command to execute wkhtmltopdf. Default is 'wkhtmltopdf'")
    private String wkHtmlToPdfCommand = "wkhtmltopdf";
    private PegDownProcessor markdownProcessor = new PegDownProcessor();
    private ContextProperties properties;
    private static final Logger logger = LoggerFactory.getLogger(DocumentGenerator.class);

    public static void main(String[] stringArray) {
        DocumentGenerator documentGenerator = new DocumentGenerator();
        CmdLineParser cmdLineParser = new CmdLineParser((Object)documentGenerator);
        try {
            cmdLineParser.parseArgument(stringArray);
            documentGenerator.generate();
        }
        catch (CmdLineException cmdLineException) {
            System.err.println(cmdLineException.getMessage());
            System.err.println("java DocumentGenerator [options...] arguments...");
            cmdLineParser.printUsage((OutputStream)System.err);
            System.err.println();
            System.exit(1);
        }
    }

    private void generate() {
        this.downloadResourcesToWorkingDir();
        List<File> list = this.generateHtmlFromMarkdownSources();
        if (this.generatePdf) {
            this.generatePdfFromHtml(list);
        }
    }

    private void downloadResourcesToWorkingDir() {
        for (URL uRL : this.resources) {
            String string = IOUtils.extractFileName(uRL);
            String string2 = IOUtils.extractFileNameExtension(string);
            logger.info("Processing resource '{}'. Resource has a file name of '{}' with extension '{}'.", new Object[]{uRL, string, string2});
            if ("zip".equals(string2)) {
                this.copyUncompressed(uRL, string);
                continue;
            }
            if ("".equals(string2)) {
                this.copyLocalFolder(uRL, string);
                continue;
            }
            IOUtils.copy(uRL, new File(this.workingDir, string));
        }
    }

    private void copyUncompressed(URL uRL, String string) {
        File file = new File(this.workingDir, string);
        IOUtils.copy(uRL, file);
        IOUtils.explodeArchive(file, this.workingDir);
        file.delete();
    }

    private void copyLocalFolder(URL uRL, String string) {
        File file = null;
        try {
            file = new File(uRL.toURI());
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new RuntimeException(uRISyntaxException);
        }
        IOUtils.copyDirectory(file, new File(this.workingDir, string));
    }

    private List<File> generateHtmlFromMarkdownSources() {
        List<Object> list = Lists.newArrayList();
        if (this.generateSingleDocument) {
            list.add(this.generateSinglePageHtml());
        } else {
            list = this.generateMultiplePageHtml();
        }
        return list;
    }

    private List<File> generatePdfFromHtml(List<File> list) {
        logger.info("Creating pdf from html sources '{}'.", list);
        WkhtmlPdfGenerator wkhtmlPdfGenerator = new WkhtmlPdfGenerator();
        wkhtmlPdfGenerator.setCoverHtml(this.pdfCoverHtml);
        wkhtmlPdfGenerator.setFooterHtml(this.pdfFooterHtml);
        wkhtmlPdfGenerator.setHeaderHtml(this.pdfHeaderHtml);
        wkhtmlPdfGenerator.setProperties(this.getProperties());
        wkhtmlPdfGenerator.setTocXsl(this.pdfTocXsl);
        wkhtmlPdfGenerator.setWkHtmlToPdfCommand(this.wkHtmlToPdfCommand);
        wkhtmlPdfGenerator.setWorkingDir(this.workingDir);
        ArrayList arrayList = Lists.newArrayList();
        for (File file : list) {
            arrayList.add(wkhtmlPdfGenerator.generatePdfFromHtml(file));
        }
        wkhtmlPdfGenerator.clearTemporaryFiles();
        return arrayList;
    }

    private File generateSinglePageHtml() {
        File file = new File(this.workingDir, "singleDocument.html");
        String string = "singleDocument";
        logger.info("Creating single html document '{}' from markdown sources '{}'.", (Object)file.getAbsolutePath(), this.markdownSources);
        PrintWriter printWriter = null;
        try {
            printWriter = new PrintWriter(new FileWriter(file));
            this.openHtmlTagAndInitializeHeadTag(printWriter, string);
            this.openBodyTag(printWriter);
            for (File file2 : this.markdownSources) {
                this.generateHtmlBodyFromMarkdownSource(file2, printWriter, string);
            }
            this.finalizeBodyAndCloseHtmlTag(printWriter, "singleDocument");
        }
        catch (IOException iOException) {
            try {
                throw new RuntimeIOException((Throwable)iOException);
            }
            catch (Throwable throwable) {
                Closeables.closeQuietly(printWriter);
                throw throwable;
            }
        }
        Closeables.closeQuietly((Closeable)printWriter);
        return file;
    }

    private List<File> generateMultiplePageHtml() {
        logger.info("Creating multiple html documents from markdown sources '{}'.", this.markdownSources);
        ArrayList arrayList = Lists.newArrayList();
        for (File file : this.markdownSources) {
            String string = IOUtils.extractFileNameWithoutExtension(file);
            File file2 = IOUtils.createFileNameWithNewExtension(file, this.workingDir, "html");
            logger.info("Creating html document '{}' from markdown source '{}'.", (Object)file2.getAbsolutePath(), (Object)file.getAbsolutePath());
            PrintWriter printWriter = null;
            try {
                printWriter = new PrintWriter(new FileWriter(file2));
                this.openHtmlTagAndInitializeHeadTag(printWriter, string);
                this.openBodyTag(printWriter);
                this.generateHtmlBodyFromMarkdownSource(file, printWriter, string);
                this.finalizeBodyAndCloseHtmlTag(printWriter, string);
                arrayList.add(file2);
            }
            catch (IOException iOException) {
                try {
                    throw new RuntimeIOException((Throwable)iOException);
                }
                catch (Throwable throwable) {
                    Closeables.closeQuietly(printWriter);
                    throw throwable;
                }
            }
            Closeables.closeQuietly((Closeable)printWriter);
        }
        return arrayList;
    }

    private PrintWriter openHtmlTagAndInitializeHeadTag(PrintWriter printWriter, String string) {
        ContextProperties contextProperties = this.getRootContextMergedWithConfig(string);
        printWriter.print("<html><head>");
        if (this.htmlHeaderSnippet != null) {
            printWriter.print(IOUtils.replacePlaceholders(IOUtils.getText(this.htmlHeaderSnippet), contextProperties));
        }
        this.initializeHead(printWriter);
        printWriter.print("</head>");
        return printWriter;
    }

    protected PrintWriter initializeHead(PrintWriter printWriter) {
        return printWriter;
    }

    private void openBodyTag(PrintWriter printWriter) {
        printWriter.print("<body>");
    }

    private void finalizeBodyAndCloseHtmlTag(PrintWriter printWriter, String string) {
        this.finalizeBody(printWriter, string);
        if (this.htmlFooterSnippet != null) {
            printWriter.print(IOUtils.getText(this.htmlFooterSnippet));
        }
        printWriter.print("</body></html>");
    }

    protected void finalizeBody(PrintWriter printWriter, String string) {
        ContextProperties contextProperties = this.getRootContextMergedWithConfig(string);
        if ("true".equals(contextProperties.get("appendCiReference"))) {
            Object object;
            ArrayList arrayList = Collections.emptyList();
            if (contextProperties.get("prefixes") != null) {
                object = Splitter.on((char)',').trimResults().split((CharSequence)contextProperties.get("prefixes"));
                arrayList = Lists.newArrayList((Iterable)object);
            }
            object = new CiReferenceHtmlGenerator(arrayList, printWriter);
            ((CiReferenceHtmlGenerator)object).generate();
        }
    }

    private void generateHtmlBodyFromMarkdownSource(File file, PrintWriter printWriter, String string) {
        String string2 = IOUtils.getText(file);
        ContextProperties contextProperties = this.getRootContextMergedWithConfig(string);
        string2 = IOUtils.replacePlaceholders(string2, contextProperties);
        String string3 = this.markdownProcessor.markdownToHtml(string2);
        logger.trace("Generate html from markdown file '{}' :\n {}", (Object)file.getAbsolutePath(), (Object)string3);
        printWriter.write(string3);
    }

    private ContextProperties getRootContextMergedWithConfig(String string) {
        ContextProperties contextProperties = this.getProperties().getRootContext();
        contextProperties.putAll((Map)((Object)this.getProperties().getContext(string)));
        return contextProperties;
    }

    private ContextProperties getProperties() {
        if (this.properties == null) {
            this.properties = new ContextProperties();
            if (this.propertiesSource != null) {
                try {
                    Properties properties = new Properties();
                    properties.load(new FileInputStream(this.propertiesSource));
                    for (String string : properties.stringPropertyNames()) {
                        this.properties.put(string, properties.getProperty(string));
                    }
                }
                catch (IOException iOException) {
                    throw new RuntimeIOException((Throwable)iOException);
                }
            }
        }
        return this.properties;
    }
}

