/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.documentation;

import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.google.common.collect.Lists;
import com.google.common.io.Closeables;
import com.xebialabs.deployit.plugin.api.boot.PluginBooter;
import com.xebialabs.deployit.plugin.api.reflect.Descriptor;
import com.xebialabs.deployit.plugin.api.reflect.DescriptorRegistry;
import com.xebialabs.deployit.plugin.api.reflect.MethodDescriptor;
import com.xebialabs.deployit.plugin.api.reflect.PropertyDescriptor;
import com.xebialabs.deployit.plugin.api.reflect.PropertyKind;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.Deployable;
import com.xebialabs.deployit.plugin.api.udm.Deployed;
import java.io.Closeable;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CiReferenceHtmlGenerator {
    private List<String> prefixes;
    private PrintWriter writer;
    private static final Predicate<Descriptor> DEPLOYABLE_PREDICATE;
    private static final Predicate<Descriptor> VIRTUAL_DEPLOYABLE_PREDICATE;
    private static final Predicate<Descriptor> DEPLOYED_PREDICATE;
    private static final Predicate<Descriptor> VIRTUAL_DEPLOYED_PREDICATE;
    private static final Predicate<Descriptor> TOPOLOGY_PREDICATE;
    private static final Predicate<Descriptor> VIRTUAL_TOPOLOGY_PREDICATE;
    private static final Predicate<PropertyDescriptor> HIDDEN_PROPERTY_PREDICATE;
    private static final Predicate<PropertyDescriptor> PUBLIC_PROPERTY_PREDICATE;
    private static final Logger logger;

    public CiReferenceHtmlGenerator(List<String> prefixes, PrintWriter writer) {
        this.prefixes = prefixes;
        this.writer = writer;
    }

    public void generate() {
        logger.info("Generating documentation for " + (!this.prefixes.isEmpty() ? "CIs with prefix '" + this.prefixes + "'" : "all CIs"));
        List<Descriptor> cis = this.findDescriptorsToGenerateReferenceDocFor(this.prefixes);
        logger.info("Found " + cis.size() + " CI descriptors to generate documentation for.");
        this.writer.println("<div style='width:100%; position:relative'>");
        this.generateCiTableOfContentForAllCategories(cis);
        this.generateCiDetails(cis);
        this.writer.println("</div>");
    }

    private void generateCiTableOfContentForAllCategories(Collection<Descriptor> cis) {
        this.writer.printf("<h1 class='ci-toc-category'>CI Reference</h1>", new Object[0]);
        this.writer.printf("<h2>Configuration Item Overview</h2>", new Object[0]);
        this.generateCiTableOfContentForCategory(cis, "Deployable Configuration Items", DEPLOYABLE_PREDICATE);
        this.generateCiTableOfContentForCategory(cis, "Deployed Configuration Items", DEPLOYED_PREDICATE);
        this.generateCiTableOfContentForCategory(cis, "Topology Configuration Items", TOPOLOGY_PREDICATE);
        this.generateCiTableOfContentForCategory(cis, "Virtual Deployable Configuration Items", VIRTUAL_DEPLOYABLE_PREDICATE);
        this.generateCiTableOfContentForCategory(cis, "Virtual Deployed Configuration Items", VIRTUAL_DEPLOYED_PREDICATE);
        this.generateCiTableOfContentForCategory(cis, "Virtual Topology Configuration Items", VIRTUAL_TOPOLOGY_PREDICATE);
    }

    private void generateCiDetails(Collection<Descriptor> cis) {
        this.writer.printf("<h2 class='ci-details-title'>Configuration Item Details</h2>", new Object[0]);
        for (Descriptor ci : cis) {
            this.writer.printf("<a name='%s'></a><h3 class='ci-detail-title'>%s</h3>", ci.getType(), ci.getType());
            if (!ci.getSuperClasses().isEmpty()) {
                this.writer.print("<div><table class='ci-relations-table'>");
                if (!ci.getSuperClasses().isEmpty()) {
                    this.generateTypeRow(ci.getSuperClasses(), "Hierarchy", "<span> >> </span>");
                }
                if (!ci.getInterfaces().isEmpty()) {
                    this.generateTypeRow(ci.getInterfaces(), "Interfaces", "<span>, </span>");
                }
                this.writer.print("</table></div>");
            }
            this.writer.printf("<p class='ci-description'>%s</p>\n", ci.getDescription());
            Collection<PropertyDescriptor> propertyDescriptors = this.sortProperties(ci.getPropertyDescriptors());
            this.generateCiPropertiesTable(propertyDescriptors, "Public Properties", PUBLIC_PROPERTY_PREDICATE);
            this.generateCiPropertiesTable(propertyDescriptors, "Hidden Properties", HIDDEN_PROPERTY_PREDICATE);
            Collection<MethodDescriptor> controlTaskDescriptors = this.sortMethodDescriptors(ci.getControlTasks());
            this.generateCiControlTaskTable(controlTaskDescriptors, "Control Tasks");
            this.writer.println("<hr class='ci-details-separator'/>");
        }
    }

    private void generateTypeRow(Collection<Type> types, String tHeader, String separator) {
        this.writer.printf("<tr><th>%s</th><td>", tHeader);
        int i = 0;
        for (Type iType : types) {
            this.writeTypeAnchor(iType);
            if (++i >= types.size()) continue;
            this.writer.print(separator);
        }
        this.writer.print("</td></tr>");
    }

    private void writeTypeAnchor(Type type) {
        if (this.isTypePartOfReferencedDoc(type)) {
            this.writer.printf("<a href='#%s'>%s</a>", type, type);
        } else {
            this.writer.printf("<span>%s</span>", type);
        }
    }

    private void generateCiPropertiesTable(Collection<PropertyDescriptor> pds, String category, Predicate<PropertyDescriptor> predicate) {
        Collection filtered = Collections2.filter(pds, predicate);
        if (filtered.isEmpty()) {
            return;
        }
        this.writer.printf("<table class='ci-properties nobreak'  cellspacing='0' cellpadding='3'><tr class='odd ci-prop-header'><th>%s</th></tr>", category);
        int i = 0;
        for (PropertyDescriptor pd : filtered) {
            String oddEven = i % 2 == 0 ? "even" : "odd";
            String required = "";
            if (pd.isRequired()) {
                required = "<span class='required'>&nbsp;</span>";
            }
            String icons = "";
            if (pd.isAsContainment()) {
                icons = icons + "<img title='Containment relationship' class='containerImg' src='image/container.png'/>";
            }
            if (pd.isInspectionProperty()) {
                icons = icons + "<img title='Inspection property.' class='inspectImg' src='image/inspect.png'/>";
            }
            String kind = pd.getKind().toString();
            if (pd.getKind() == PropertyKind.ENUM) {
                kind = kind + " " + Arrays.toString(pd.getEnumValues().toArray());
            }
            if (pd.getKind() == PropertyKind.CI || pd.getKind() == PropertyKind.SET_OF_CI) {
                kind = kind + "&lt;" + pd.getReferencedType() + "&gt;";
            }
            String defaultValue = "";
            if (pd.getDefaultValue() != null) {
                defaultValue = "&nbsp;=&nbsp;<span class='ci-property-default'>" + pd.getDefaultValue() + "</span>";
            }
            this.writer.printf("<tr class='%s'><td>%s<a name='%s_%s'></a><span class='ci-property-name'>%s</span>%s&nbsp;:&nbsp;<span class='ci-property-kind'>%s</span>%s<p class='ci-property-desc'>%s</p></td>\n", oddEven, icons, pd.getDeclaringDescriptor().getType(), pd.getName(), pd.getName(), required, kind, defaultValue, pd.getDescription());
            ++i;
        }
        this.writer.println("</table>");
    }

    private void generateCiControlTaskTable(Collection<MethodDescriptor> mds, String category) {
        if (mds.isEmpty()) {
            return;
        }
        this.writer.printf("<table class='ci-properties nobreak'  cellspacing='0' cellpadding='3'><tr class='odd ci-prop-header'><th>%s</th></tr>", category);
        int i = 0;
        for (MethodDescriptor md : mds) {
            String oddEven = i % 2 == 0 ? "even" : "odd";
            String icons = "";
            this.writer.printf("<tr class='%s'><td>%s<a name='%s_%s'></a><span class='ci-property-name'>%s</span><p class='ci-property-desc'>%s</p></td>\n", oddEven, icons, md.getDeclaringDescriptor().getType(), md.getName(), md.getName(), md.getDescription());
            ++i;
        }
        this.writer.println("</table>");
    }

    private void generateCiTableOfContentForCategory(Collection<Descriptor> cis, String category, Predicate<Descriptor> predicate) {
        Collection filtered = Collections2.filter(cis, predicate);
        if (!filtered.isEmpty()) {
            this.writer.printf("<h3 class='ci-toc-category'>%s</h3>", category);
            this.generateCiTableOfContent(filtered, this.writer);
        }
    }

    private void generateCiTableOfContent(Collection<Descriptor> cis, PrintWriter writer) {
        writer.println("<table class='ci-toc nobreak'  cellspacing='0' cellpadding='3'><tr class='odd ci-toc-header'><th>CI</th><th>Description</th></tr>");
        int i = 0;
        for (Descriptor ci : cis) {
            String oddEven = i % 2 == 0 ? "even" : "odd";
            writer.printf("<tr class='%s'><td><a href='#%s'>%s</a></td><td>%s</td>\n", oddEven, ci.getType(), ci.getType(), this.extractFirstSentence(ci.getDescription()));
            ++i;
        }
        writer.println("</table>");
    }

    private String extractFirstSentence(String s) {
        if (s == null) {
            return "";
        }
        if (s.indexOf(".") > -1) {
            return s.substring(0, s.indexOf("."));
        }
        return s;
    }

    private List<Descriptor> findDescriptorsToGenerateReferenceDocFor(List<String> prefixes) {
        Collection filtered = Collections2.filter((Collection)DescriptorRegistry.getDescriptors(), (Predicate)new Predicate<Descriptor>(){

            public boolean apply(Descriptor input) {
                return CiReferenceHtmlGenerator.this.isTypePartOfReferencedDoc(input.getType());
            }
        });
        ArrayList needsRefDoc = Lists.newArrayList((Iterable)filtered);
        Collections.sort(needsRefDoc, new Comparator<Descriptor>(){

            @Override
            public int compare(Descriptor o1, Descriptor o2) {
                return o1.getType().toString().compareTo(o2.getType().toString());
            }
        });
        return needsRefDoc;
    }

    private boolean isTypePartOfReferencedDoc(Type type) {
        return this.prefixes.isEmpty() || this.prefixes.contains(type.getPrefix());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void appendToFile(String outputFilename, byte[] data) throws IOException {
        FileOutputStream fos = new FileOutputStream(outputFilename, true);
        try {
            fos.write(data);
        }
        finally {
            Closeables.closeQuietly((Closeable)fos);
        }
    }

    private Collection<PropertyDescriptor> sortProperties(Collection<PropertyDescriptor> propertyDescriptors) {
        ArrayList result = Lists.newArrayList(propertyDescriptors);
        Collections.sort(result, new Comparator<PropertyDescriptor>(){

            @Override
            public int compare(PropertyDescriptor o1, PropertyDescriptor o2) {
                int result;
                int n = o1.isRequired() == o2.isRequired() ? 0 : (result = o1.isRequired() ? -1 : 1);
                if (result == 0) {
                    result = o1.getName().compareTo(o2.getName());
                }
                return result;
            }
        });
        return result;
    }

    private Collection<MethodDescriptor> sortMethodDescriptors(Collection<MethodDescriptor> methodDescriptors) {
        ArrayList result = Lists.newArrayList(methodDescriptors);
        Collections.sort(result, new Comparator<MethodDescriptor>(){

            @Override
            public int compare(MethodDescriptor o1, MethodDescriptor o2) {
                return o1.getName().compareTo(o2.getName());
            }
        });
        return result;
    }

    static {
        PluginBooter.bootWithoutGlobalContext();
        DEPLOYABLE_PREDICATE = new Predicate<Descriptor>(){

            public boolean apply(Descriptor input) {
                return !input.isVirtual() && input.isAssignableTo(Deployable.class);
            }
        };
        VIRTUAL_DEPLOYABLE_PREDICATE = new Predicate<Descriptor>(){

            public boolean apply(Descriptor input) {
                return input.isVirtual() && input.isAssignableTo(Deployable.class);
            }
        };
        DEPLOYED_PREDICATE = new Predicate<Descriptor>(){

            public boolean apply(Descriptor input) {
                return !input.isVirtual() && input.isAssignableTo(Deployed.class);
            }
        };
        VIRTUAL_DEPLOYED_PREDICATE = new Predicate<Descriptor>(){

            public boolean apply(Descriptor input) {
                return input.isVirtual() && input.isAssignableTo(Deployed.class);
            }
        };
        TOPOLOGY_PREDICATE = new Predicate<Descriptor>(){

            public boolean apply(Descriptor input) {
                return !input.isVirtual() && !input.isAssignableTo(Deployable.class) && !input.isAssignableTo(Deployed.class);
            }
        };
        VIRTUAL_TOPOLOGY_PREDICATE = new Predicate<Descriptor>(){

            public boolean apply(Descriptor input) {
                return input.isVirtual() && !input.isAssignableTo(Deployable.class) && !input.isAssignableTo(Deployed.class);
            }
        };
        HIDDEN_PROPERTY_PREDICATE = new Predicate<PropertyDescriptor>(){

            public boolean apply(PropertyDescriptor input) {
                return input.isHidden();
            }
        };
        PUBLIC_PROPERTY_PREDICATE = new Predicate<PropertyDescriptor>(){

            public boolean apply(PropertyDescriptor input) {
                return !input.isHidden();
            }
        };
        logger = LoggerFactory.getLogger(CiReferenceHtmlGenerator.class);
    }
}

