package com.xebialabs.deployit.client;

import java.io.Serializable;

public class DeploymentOptions implements Serializable {

	private boolean skipMode = false;
	private boolean testMode = false;

	private boolean deletePreviouslyDeployedArtifact = false;

	//TODO: remove this option, since 3.6 the deployit server does not fail if the steps aren't generated anymore.
	private boolean failIfNoStepsAreGenerated = false;
	private boolean explicitMappings = false;
	private boolean generateDeployedOnUpgrade = false;
	private boolean cancelTaskOnError = true;
	private boolean rollbackOnError = false;

	private String orchestrator;

	public DeploymentOptions() {}

	public DeploymentOptions(boolean skipMode, boolean testMode, boolean importOnly, boolean deletePreviouslyDeployedArtifact, boolean failIfNoStepsAreGenerated, boolean explicitMappings, boolean generateDeployedOnUpgrade, boolean cancelTaskOnError, String orchestrator) {
		this(skipMode, testMode, importOnly, deletePreviouslyDeployedArtifact, failIfNoStepsAreGenerated, explicitMappings, generateDeployedOnUpgrade, cancelTaskOnError, false, orchestrator);
	}

	public DeploymentOptions(boolean skipMode, boolean testMode, boolean importOnly, boolean deletePreviouslyDeployedArtifact, boolean failIfNoStepsAreGenerated, boolean explicitMappings, boolean generateDeployedOnUpgrade, boolean cancelTaskOnError, boolean rollbackOnError, String orchestrator) {
		this.skipMode = skipMode;
		this.testMode = testMode;
		this.deletePreviouslyDeployedArtifact = deletePreviouslyDeployedArtifact;
		this.failIfNoStepsAreGenerated = failIfNoStepsAreGenerated;
		this.explicitMappings = explicitMappings;
		this.generateDeployedOnUpgrade = generateDeployedOnUpgrade;
		this.cancelTaskOnError = cancelTaskOnError;
		this.rollbackOnError = rollbackOnError;
		this.orchestrator = orchestrator;
	}

	public boolean isSkipMode() {
		return skipMode;
	}

	public void setSkipMode(boolean skipMode) {
		this.skipMode = skipMode;
	}

	public boolean isTestMode() {
		return testMode;
	}

	public void setTestMode(boolean testMode) {
		this.testMode = testMode;
	}

	public boolean isDeletePreviouslyDeployedArtifact() {
		return deletePreviouslyDeployedArtifact;
	}

	public void setDeletePreviouslyDeployedArtifact(boolean deletePreviouslyDeployedArtifact) {
		this.deletePreviouslyDeployedArtifact = deletePreviouslyDeployedArtifact;
	}

	public boolean isFailIfNoStepsAreGenerated() {
		return failIfNoStepsAreGenerated;
	}

	public void setFailIfNoStepsAreGenerated(boolean failIfNoStepsAreGenerated) {
		this.failIfNoStepsAreGenerated = failIfNoStepsAreGenerated;
	}

	public boolean isExplicitMappings() {
		return explicitMappings;
	}

	public void setExplicitMappings(boolean explicitMappings) {
		this.explicitMappings = explicitMappings;
	}

	public boolean isGenerateDeployedOnUpgrade() {
		return generateDeployedOnUpgrade;
	}

	public void setGenerateDeployedOnUpgrade(boolean generateDeployedOnUpgrade) {
		this.generateDeployedOnUpgrade = generateDeployedOnUpgrade;
	}

	public boolean isCancelTaskOnError() {
		return cancelTaskOnError;
	}

	public void setCancelTaskOnError(boolean cancelTaskOnError) {
		this.cancelTaskOnError = cancelTaskOnError;
	}

	public String getOrchestrator() {
		return orchestrator;
	}

	public void setOrchestrator(String orchestrator) {
		this.orchestrator = orchestrator;
	}

	public boolean isRollbackOnError() {
		return rollbackOnError;
	}

	public void setRollbackOnError(boolean rollbackOnError) {
		this.rollbackOnError = rollbackOnError;
	}

	@Override
	public String toString() {
		return "DeploymentOptions{" +
				"cancelTaskOnError=" + cancelTaskOnError +
				", deletePreviouslyDeployedArtifact=" + deletePreviouslyDeployedArtifact +
				", explicitMappings=" + explicitMappings +
				", failIfNoStepsAreGenerated=" + failIfNoStepsAreGenerated +
				", generateDeployedOnUpgrade=" + generateDeployedOnUpgrade +
				", skipMode=" + skipMode +
				", testMode=" + testMode +
				", orchestrator=" + orchestrator +
				'}';
	}
}
