/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.client;

import com.xebialabs.deployit.client.ConnectionOptions;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.HostConfiguration;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.auth.AuthScope;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Authentication {
    private String username;
    public String password;
    private HttpClient httpClient;
    private static final Logger logger = LoggerFactory.getLogger(Authentication.class);

    public Authentication(ConnectionOptions options) {
        this.username = options.getUsername();
        this.password = options.getPassword();
        this.init(options);
    }

    private void init(ConnectionOptions options) {
        this.httpClient = new HttpClient();
        this.addCredentials();
        this.httpClient.getParams().setAuthenticationPreemptive(true);
        this.httpClient.getParams().setConnectionManagerTimeout(10000L);
        HostConfiguration hostConfiguration = new HostConfiguration();
        hostConfiguration.setHost(options.getHost(), options.getPort(), String.format("http%s", options.isSecured() ? "s" : ""));
        this.httpClient.setHostConfiguration(hostConfiguration);
    }

    private void addCredentials() {
        UsernamePasswordCredentials credentials = new UsernamePasswordCredentials(this.username, this.password);
        this.httpClient.getState().setCredentials(AuthScope.ANY, (Credentials)credentials);
    }

    public void logout() {
        this.username = null;
        this.password = null;
        this.httpClient.getState().clearCookies();
        this.httpClient.getState().clearCredentials();
    }

    public String getUsername() {
        return this.username;
    }

    public void loginAs(String username, String password) {
        if (this.httpClient.getState().getCredentials(AuthScope.ANY) != null) {
            logger.error("You're still logged in as another user, please logout first.");
            return;
        }
        this.username = username;
        this.password = password;
        this.addCredentials();
        this.httpClient.getState().clearCookies();
    }

    public HttpClient getHttpClient() {
        return this.httpClient;
    }

    public String getPassword() {
        return this.password;
    }
}

