/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.client;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.xebialabs.deployit.plugin.api.reflect.Descriptor;
import com.xebialabs.deployit.plugin.api.reflect.PropertyDescriptor;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;

public class Descriptors {
    private final List<Descriptor> descriptors;
    private final ImmutableMap<String, Descriptor> descriptorMap;
    private final Map<String, List<String>> propertiesIndexedByMap;

    public Descriptors(List<Descriptor> descriptors) {
        this.descriptors = Lists.newArrayList(descriptors);
        Collections.sort(this.descriptors, new Comparator<Descriptor>(){

            @Override
            public int compare(Descriptor o1, Descriptor o2) {
                return o1.getType().toString().compareTo(o2.getType().toString());
            }
        });
        this.descriptorMap = Maps.uniqueIndex(descriptors, (Function)new Function<Descriptor, String>(){

            public String apply(Descriptor input) {
                return input.getType().toString();
            }
        });
        this.propertiesIndexedByMap = Maps.transformValues(this.descriptorMap, (Function)new Function<Descriptor, List<String>>(){

            public List<String> apply(Descriptor input) {
                ArrayList properties = Lists.newArrayList((Iterable)Iterables.transform((Iterable)input.getPropertyDescriptors(), (Function)new Function<PropertyDescriptor, String>(){

                    public String apply(PropertyDescriptor input) {
                        return input.getName();
                    }
                }));
                Collections.sort(properties);
                return properties;
            }
        });
    }

    public List<Descriptor> getDescriptors() {
        return this.descriptors;
    }

    public Map<String, List<String>> getPropertiesIndexedByMap() {
        return this.propertiesIndexedByMap;
    }

    public List<Descriptor> getDeployables() {
        return ImmutableList.copyOf((Iterable)Iterables.filter(this.descriptors, (Predicate)new Predicate<Descriptor>(){

            public boolean apply(Descriptor input) {
                return input.getInterfaces().contains(Type.valueOf((String)"udm.Deployable"));
            }
        }));
    }

    public List<Descriptor> getDeployableArtifacts() {
        return ImmutableList.copyOf((Iterable)Iterables.filter(this.getDeployables(), (Predicate)new Predicate<Descriptor>(){

            public boolean apply(Descriptor input) {
                return input.getInterfaces().contains(Type.valueOf((String)"udm.Artifact"));
            }
        }));
    }

    public List<Descriptor> getDeployableResources() {
        return ImmutableList.copyOf((Iterable)Iterables.filter(this.getDeployables(), (Predicate)new Predicate<Descriptor>(){

            public boolean apply(Descriptor input) {
                return !input.getInterfaces().contains(Type.valueOf((String)"udm.Artifact"));
            }
        }));
    }

    public boolean isPropertyNameofType(String type, final String propertyname) {
        Descriptor configurationItemDescriptor = (Descriptor)this.descriptorMap.get((Object)type);
        if (configurationItemDescriptor == null) {
            return false;
        }
        return Iterables.any((Iterable)configurationItemDescriptor.getPropertyDescriptors(), (Predicate)new Predicate<PropertyDescriptor>(){

            public boolean apply(PropertyDescriptor input) {
                return input.getName().equals(propertyname);
            }
        });
    }

    public List<String> getPropertyName(String type) {
        Preconditions.checkNotNull((Object)Strings.emptyToNull((String)type), (Object)"type should not be null or empty");
        Preconditions.checkArgument((boolean)this.descriptorMap.containsKey((Object)type), (String)"type %s not found", (Object[])new Object[]{type});
        Descriptor Descriptor2 = (Descriptor)this.descriptorMap.get((Object)type);
        Collection propertyDescriptors = Descriptor2.getPropertyDescriptors();
        return ImmutableList.copyOf((Iterable)Iterables.transform((Iterable)propertyDescriptors, (Function)new Function<PropertyDescriptor, String>(){

            public String apply(PropertyDescriptor input) {
                return input.getName();
            }
        }));
    }
}

