/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.client;

import com.xebialabs.deployit.booter.remote.Proxies;
import com.xebialabs.deployit.client.DeploymentListener;
import com.xebialabs.deployit.engine.api.execution.TaskExecutionState;
import com.xebialabs.deployit.engine.api.execution.TaskState;
import java.util.Arrays;
import java.util.HashSet;

public class DeployitClient {
    private DeploymentListener listener;
    private Proxies proxies;

    public DeployitClient(DeploymentListener listener, Proxies proxies) {
        this.listener = listener;
        this.proxies = proxies;
    }

    public TaskState retrieveTaskInfo(String taskId) {
        return this.proxies.getTaskService().getTask(taskId);
    }

    public void stopTask(String taskId) {
        this.proxies.getTaskService().stop(taskId);
    }

    public void startTask(String taskId) {
        this.proxies.getTaskService().start(taskId);
    }

    public void startTaskAndWait(String taskId) {
        this.startTask(taskId);
        boolean done = false;
        while (!done) {
            TaskState ti = this.retrieveTaskInfo(taskId);
            TaskExecutionState state = ti.getState();
            this.listener.debug("Task state: " + state.toString());
            done = new HashSet<TaskExecutionState>(){
                {
                    this.add(TaskExecutionState.DONE);
                    this.add(TaskExecutionState.EXECUTED);
                    this.add(TaskExecutionState.STOPPED);
                    this.add(TaskExecutionState.CANCELLED);
                }
            }.contains(state);
            try {
                Thread.sleep(1000L);
                this.listener.debug("Waiting for task to be done...");
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
    }

    public void abortTask(String taskId) {
        this.proxies.getTaskService().abort(taskId);
    }

    public void cancelTask(String taskId) {
        this.proxies.getTaskService().cancel(taskId);
    }

    public void skipSteps(String taskId, Integer[] stepIds) {
        this.proxies.getTaskService().skip(taskId, Arrays.asList(stepIds));
    }
}

