/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.client;

import java.net.MalformedURLException;
import java.net.URL;

public class ConnectionOptions {
    static final int DEFAULT_DEPLOYIT_SERVER_PORT = 4516;
    static final int DEFAULT_DEPLOYIT_SERVER_SECURE_PORT = 4517;
    static final String DEFAULT_DEPLOYIT_SERVER_HOST = "127.0.0.1";
    static final String DEFAULT_USERNAME = "admin";
    static final String DEFAULT_PASSWORD = "admin";
    private String host = "127.0.0.1";
    private int port = -1;
    private String username = "admin";
    private String password = "admin";
    private String context = "deployit";
    private boolean secured = false;

    public ConnectionOptions() {
    }

    public ConnectionOptions(String host, int port, String username, String password, String context, boolean secured) {
        this.host = host;
        this.port = port;
        this.username = username;
        this.password = password;
        this.context = context;
        this.secured = secured;
    }

    public ConnectionOptions(String deployitServerUrl, String username, String password) {
        try {
            URL url = new URL(deployitServerUrl);
            this.setHost(url.getHost());
            this.setPort(url.getPort());
            this.setSecured("https".equalsIgnoreCase(url.getProtocol()));
            if (url.getPath().length() > 0) {
                this.setContext(url.getPath().substring(1));
            }
        }
        catch (MalformedURLException e) {
            throw new RuntimeException("MalformedURLException", e);
        }
        this.username = username;
        this.password = password;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public String getHost() {
        return this.host;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public int getPort() {
        return this.port == -1 ? (this.secured ? 4517 : 4516) : this.port;
    }

    public String getUsername() {
        return this.username == null ? "admin" : this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password == null ? "admin" : this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public boolean isSecured() {
        return this.secured;
    }

    public void setSecured(boolean secured) {
        this.secured = secured;
    }

    public String getUrl() {
        return String.format("http%s://%s:%d/%s", this.secured ? "s" : "", this.host, this.getPort(), this.getContext());
    }

    public String getContext() {
        return this.context;
    }

    public void setContext(String context) {
        this.context = context;
    }
}

