package com.xebialabs.deployit.client;

import com.xebialabs.deployit.core.api.DeploymentProxy;
import com.xebialabs.deployit.core.api.dto.Deployment;
import com.xebialabs.deployit.core.api.dto.FullTaskInfo;

import static com.xebialabs.deployit.client.ResponseExtractor.getEntity;

public class DeploymentClient {

	private final DeploymentProxy deploymentProxy;

	public DeploymentClient(DeployitProxies proxies) {
		this.deploymentProxy = proxies.getDeployment();
	}

	public Deployment prepareInitial(String version, String environment) {
		return getEntity(deploymentProxy.prepareInitial(version, environment));
	}

	public Deployment prepareUpgrade(String version, String deployedApplication) {
		return getEntity(deploymentProxy.prepareUpgrade(version, deployedApplication));
	}

	public Deployment generateAllDeployeds(Deployment deployment) {
		return getEntity(deploymentProxy.generateAllDeployeds(deployment));
	}

	public Deployment generateSingleDeployed(String deployable, String container, String type, Deployment deployment) {
		return getEntity(deploymentProxy.generateSingleDeployed(deployable, container, type, deployment));
	}

	public Deployment validate(Deployment deployment) {
		return getEntity(deploymentProxy.validate(deployment));
	}

	public FullTaskInfo deploy(Deployment deployment) {
		return getEntity(deploymentProxy.deploy(deployment));
	}

	public FullTaskInfo undeploy(String deployedApplication) {
		return getEntity(deploymentProxy.undeploy(deployedApplication));
	}
}
