package com.xebialabs.deployit.client;

import com.xebialabs.deployit.core.api.*;
import com.xebialabs.deployit.core.api.resteasy.ResteasyHelper;
import org.jboss.resteasy.client.ProxyFactory;
import org.jboss.resteasy.client.core.executors.ApacheHttpClientExecutor;

import java.util.HashMap;
import java.util.Map;

public class DeployitProxies {

	private final Map<Class<?>, Object> registeredProxies = new HashMap<Class<?>, Object>();
	private final Authentication authentication;
	private final String host;

	public DeployitProxies(final ConnectionOptions options, final Authentication authentication) {
		this.authentication = authentication;
		host = options.getUrl();
		ResteasyHelper.buildDefaultResteasyProviderFactory().build();
		registerProxies();
	}

	private void registerProxies() {
		registerProxy(DeploymentProxy.class);
		registerProxy(ImportablePackageProxy.class);
		registerProxy(RepositoryProxy.class);
		registerProxy(QueryProxy.class);
		registerProxy(UserProxy.class);
		registerProxy(DiscoveryProxy.class);
		registerProxy(ReferenceDataProxy.class);
		registerProxy(TaskProxy.class);
		registerProxy(ExportProxy.class);
		registerProxy(ReportProxy.class);
		registerProxy(SecurityProxy.class);
		registerProxy(ServerProxy.class);
	}

	private void registerProxy(final Class<?> proxyClass) {
		final ApacheHttpClientExecutor clientExecutor = new ApacheHttpClientExecutor(authentication.getHttpClient());
		registeredProxies.put(proxyClass, ProxyFactory.create(proxyClass, host, clientExecutor));
	}

	@SuppressWarnings("unchecked")
	private <T> T getRestEasyProxyInstance(Class<T> proxyClass) {
		return (T) registeredProxies.get(proxyClass);
	}

	public ImportablePackageProxy getImportablePackage() {
		return getRestEasyProxyInstance(ImportablePackageProxy.class);
	}

	public RepositoryProxy getRepository() {
		return getRestEasyProxyInstance(RepositoryProxy.class);
	}

	public TaskProxy getTaskRegistry() {
		return getRestEasyProxyInstance(TaskProxy.class);
	}

	public DeploymentProxy getDeployment() {
		return getRestEasyProxyInstance(DeploymentProxy.class);
	}

	public ReferenceDataProxy getDescriptor() {
		return getRestEasyProxyInstance(ReferenceDataProxy.class);
	}

	public QueryProxy getQuery() {
		return getRestEasyProxyInstance(QueryProxy.class);
	}

	public ServerProxy getServer() {
		return getRestEasyProxyInstance(ServerProxy.class);
	}

	public Authentication getAuthentication() {
		return authentication;
	}

	public String getHost() {
		return host;
	}
}
