package com.xebialabs.deployit.client.utils;

import org.apache.tools.ant.Project;
import org.apache.tools.ant.taskdefs.Copy;
import org.apache.tools.ant.taskdefs.Jar;
import org.apache.tools.ant.types.FileSet;

import java.io.File;

/**
 * Helper class to manipulate files, based on Ant Tasks.
 */
public class Files {

	public static void copyFileTo(File file, File targetDirectory) {
		Copy copy = new Copy();
		copy.setProject(new Project());
		copy.setFile(file);
		copy.setTodir(targetDirectory);
		copy.setOverwrite(true);
		copy.execute();
	}

	public static void copyDirectoryTo(File directory, File target) {
		Copy copy = new Copy();
		final Project project = new Project();
		copy.setProject(project);

		FileSet fileSet = new FileSet();
		fileSet.setProject(project);
		fileSet.setDir(directory);
		copy.addFileset(fileSet);
		final File destDir = new File(target, directory.getName());
		copy.setTodir(destDir);
		copy.setOverwrite(true);
		copy.execute();
	}

	public static void jar(File dar, File baseDir, File manifest) {
		final Project project = new Project();
		final Jar jar = new Jar();
		jar.setProject(project);
		jar.setManifest(manifest);
		jar.setDestFile(dar);
		jar.setBasedir(baseDir);
		jar.execute();
	}


}
