/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.client;

import com.xebialabs.deployit.client.Authentication;
import com.xebialabs.deployit.client.ConnectionOptions;
import com.xebialabs.deployit.core.api.DeploymentProxy;
import com.xebialabs.deployit.core.api.DescriptorProxy;
import com.xebialabs.deployit.core.api.DiscoveryProxy;
import com.xebialabs.deployit.core.api.ExportProxy;
import com.xebialabs.deployit.core.api.HistoryProxy;
import com.xebialabs.deployit.core.api.ImportablePackageProxy;
import com.xebialabs.deployit.core.api.QueryProxy;
import com.xebialabs.deployit.core.api.ReportProxy;
import com.xebialabs.deployit.core.api.RepositoryProxy;
import com.xebialabs.deployit.core.api.SecurityProxy;
import com.xebialabs.deployit.core.api.ServerProxy;
import com.xebialabs.deployit.core.api.TaskProxy;
import com.xebialabs.deployit.core.api.UserProxy;
import com.xebialabs.deployit.core.api.resteasy.ResteasyHelper;
import java.util.HashMap;
import java.util.Map;
import org.jboss.resteasy.client.ClientExecutor;
import org.jboss.resteasy.client.ProxyFactory;
import org.jboss.resteasy.client.core.executors.ApacheHttpClientExecutor;

public class DeployitProxies {
    private final Map<Class<?>, Object> registeredProxies = new HashMap();
    private final Authentication authentication;
    private final String host;

    public DeployitProxies(ConnectionOptions options, Authentication authentication) {
        this.authentication = authentication;
        this.host = options.getUrl();
        ResteasyHelper.buildDefaultResteasyProviderFactory().build();
        this.registerProxies();
    }

    private void registerProxies() {
        this.registerProxy(DeploymentProxy.class);
        this.registerProxy(ImportablePackageProxy.class);
        this.registerProxy(RepositoryProxy.class);
        this.registerProxy(QueryProxy.class);
        this.registerProxy(UserProxy.class);
        this.registerProxy(DiscoveryProxy.class);
        this.registerProxy(HistoryProxy.class);
        this.registerProxy(DescriptorProxy.class);
        this.registerProxy(TaskProxy.class);
        this.registerProxy(ExportProxy.class);
        this.registerProxy(ReportProxy.class);
        this.registerProxy(SecurityProxy.class);
        this.registerProxy(ServerProxy.class);
    }

    private void registerProxy(Class<?> proxyClass) {
        ApacheHttpClientExecutor clientExecutor = new ApacheHttpClientExecutor(this.authentication.getHttpClient());
        this.registeredProxies.put(proxyClass, ProxyFactory.create(proxyClass, (String)this.host, (ClientExecutor)clientExecutor));
    }

    private <T> T getRestEasyProxyInstance(Class<T> proxyClass) {
        return (T)this.registeredProxies.get(proxyClass);
    }

    public ImportablePackageProxy getImportablePackage() {
        return this.getRestEasyProxyInstance(ImportablePackageProxy.class);
    }

    public RepositoryProxy getRepository() {
        return this.getRestEasyProxyInstance(RepositoryProxy.class);
    }

    public TaskProxy getTaskRegistry() {
        return this.getRestEasyProxyInstance(TaskProxy.class);
    }

    public DeploymentProxy getDeployment() {
        return this.getRestEasyProxyInstance(DeploymentProxy.class);
    }

    public DescriptorProxy getDescriptor() {
        return this.getRestEasyProxyInstance(DescriptorProxy.class);
    }

    public QueryProxy getQuery() {
        return this.getRestEasyProxyInstance(QueryProxy.class);
    }

    public ServerProxy getServer() {
        return this.getRestEasyProxyInstance(ServerProxy.class);
    }

    public Authentication getAuthentication() {
        return this.authentication;
    }

    public String getHost() {
        return this.host;
    }
}

