/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.client;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.xebialabs.deployit.core.api.dto.ConfigurationItemDescriptorDto;
import com.xebialabs.deployit.core.api.dto.ConfigurationItemPropertyDescriptorDto;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.annotation.Nullable;

public class Descriptors {
    private final List<ConfigurationItemDescriptorDto> descriptors;
    private final ImmutableMap<String, ConfigurationItemDescriptorDto> descriptorMap;

    public Descriptors(List<ConfigurationItemDescriptorDto> descriptors) {
        this.descriptors = Lists.newArrayList(descriptors);
        Collections.sort(this.descriptors, new Comparator<ConfigurationItemDescriptorDto>(){

            @Override
            public int compare(ConfigurationItemDescriptorDto o1, ConfigurationItemDescriptorDto o2) {
                return o1.getSimpleName().compareTo(o2.getSimpleName());
            }
        });
        this.descriptorMap = Maps.uniqueIndex(descriptors, (Function)new Function<ConfigurationItemDescriptorDto, String>(){

            public String apply(ConfigurationItemDescriptorDto input) {
                return input.getSimpleName();
            }
        });
    }

    public List<ConfigurationItemDescriptorDto> getDescriptors() {
        return this.descriptors;
    }

    public List<ConfigurationItemDescriptorDto> getDeployables() {
        return ImmutableList.copyOf((Iterable)Iterables.filter(this.descriptors, (Predicate)new Predicate<ConfigurationItemDescriptorDto>(){

            public boolean apply(ConfigurationItemDescriptorDto input) {
                return input.getInterfaces().contains("udm.Deployable");
            }
        }));
    }

    public List<ConfigurationItemDescriptorDto> getDeployableArtifacts() {
        return ImmutableList.copyOf((Iterable)Iterables.filter(this.getDeployables(), (Predicate)new Predicate<ConfigurationItemDescriptorDto>(){

            public boolean apply(ConfigurationItemDescriptorDto input) {
                return input.getInterfaces().contains("udm.Artifact");
            }
        }));
    }

    public List<ConfigurationItemDescriptorDto> getDeployableResouces() {
        return ImmutableList.copyOf((Iterable)Iterables.filter(this.getDeployables(), (Predicate)new Predicate<ConfigurationItemDescriptorDto>(){

            public boolean apply(ConfigurationItemDescriptorDto input) {
                return !input.getInterfaces().contains("udm.Artifact");
            }
        }));
    }

    public boolean isPropertyNameofType(String type, final String propertyname) {
        ConfigurationItemDescriptorDto configurationItemDescriptor = (ConfigurationItemDescriptorDto)this.descriptorMap.get((Object)type);
        if (configurationItemDescriptor == null) {
            return false;
        }
        return Iterables.any((Iterable)configurationItemDescriptor.getPropertyDescriptors(), (Predicate)new Predicate<ConfigurationItemPropertyDescriptorDto>(){

            public boolean apply(@Nullable ConfigurationItemPropertyDescriptorDto input) {
                return input.getName().equals(propertyname);
            }
        });
    }
}

