/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.client;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.File;
import java.util.List;
import java.util.Map;

public class Deployable {
    protected String name;
    protected String type;
    protected File location;
    protected final Map<String, String> values = Maps.newHashMap();
    protected final List<String> tags = Lists.newArrayList();

    public Deployable() {
    }

    public Deployable(String name, String type) {
        this(name, type, null);
    }

    public Deployable(String name, String type, File location) {
        this.name = name;
        this.type = type;
        this.location = location;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public Map<String, String> getValues() {
        return this.values;
    }

    public File getLocation() {
        return this.location;
    }

    public void setLocation(File location) {
        this.location = location;
    }

    public String getEntryName() {
        return this.getLocation() == null ? this.name : this.getLocation().getName();
    }

    public List<String> getTags() {
        return this.tags;
    }

    public void addTag(String tag) {
        this.tags.add(tag);
    }

    public String toString() {
        return "Deployable{location=" + this.location + ", name='" + this.name + '\'' + ", tags=" + this.tags + ", type='" + this.type + '\'' + ", values=" + this.values + '}';
    }
}

