package com.xebialabs.deployit.cli.rest;

import com.google.common.io.CharStreams;
import com.xebialabs.deployit.booter.remote.DeployitCommunicator;
import org.apache.http.HttpResponse;
import org.apache.http.HttpStatus;
import org.apache.http.client.methods.HttpUriRequest;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;

/**
 * This class contains the logic for executing requests that need to go around RestEasy layer.
 */
public class RequestExecutor {

    private final DeployitCommunicator communicator;

    public RequestExecutor(DeployitCommunicator communicator) {
        this.communicator = communicator;
    }

    public String execute(HttpUriRequest req) {
        try {
            HttpResponse response = communicator.execute(req);

            int statusCode = response.getStatusLine().getStatusCode();
            if (statusCode == HttpStatus.SC_OK) {
                return getContent(response);
            } else if (statusCode == HttpStatus.SC_NO_CONTENT) {
                return response.toString();

            } else {
                StringBuilder errorMessage = new StringBuilder(response.getStatusLine().getReasonPhrase());
                try {
                    String responseContent = getContent(response);
                    if (!responseContent.isEmpty()) {
                        errorMessage.append(": ").append(responseContent);
                    }
                } catch (RuntimeException ignored) {}

                throw new RuntimeException(errorMessage.toString());
            }
        } catch (IOException e) {
            throw new RuntimeException(e);
        }
    }


    private String getContent(HttpResponse response) {
        try (InputStream content = response.getEntity().getContent();
             Reader is = new InputStreamReader(content)) {
            return CharStreams.toString(is);
        } catch (IOException | UnsupportedOperationException e) {
            throw new RuntimeException(e);
        }
    }
}
