package com.xebialabs.deployit.cli.api;

import ai.digital.deploy.sql.model.WorkerInfo;
import com.xebialabs.deployit.cli.CliObject;
import com.xebialabs.deployit.cli.help.ClassHelp;
import com.xebialabs.deployit.cli.help.MethodHelp;
import com.xebialabs.deployit.cli.help.ParameterHelp;

import java.util.List;

import static java.util.Collections.emptyList;

/**
 * Exposes the {@link com.xebialabs.deployit.core.api.WorkersService}.
 */
@CliObject(name = "workers")
@ClassHelp(description = "Access to the task execution workers of XL Deploy")
public class WorkersClient extends DocumentedObject {

    private ProxiesInstance proxies;

    public WorkersClient() {
    }

    public WorkersClient(ProxiesInstance proxies) {
        this.proxies = proxies;
    }

    //
    // Method delegates to WorkersService
    //
    @MethodHelp(description = "Lists the active task execution workers.",
            returns = "A list of workers with id, address and state")
    public List<WorkerInfo> list() {
        return proxies.getWorkers().listWorkers(null, null);
    }

    @MethodHelp(description = "Shutdown worker.",
            parameters = {
                    @ParameterHelp(name = "workerId", description = "The id of the worker.")
            })
    public void shutdown(Integer workerId) {
        proxies.getWorkers().shutdownWorker(workerId);
    }

    @MethodHelp(description = "Remove worker.",
            parameters = {
                    @ParameterHelp(name = "workerId", description = "The id of the worker.")
            })
    public void remove(Integer workerId) {
        proxies.getWorkers().removeWorker(workerId);
    }

    @MethodHelp(description = "Shutdown workers by their address.",
            parameters = {
                    @ParameterHelp(name = "workerAddresses", description = "The addresses of the worker.")
            })
    public void shutdown(List<String> workerAddresses) {
        proxies.getWorkers().shutdownWorkers(workerAddresses);
    }

    @MethodHelp(description = "Shutdown all workers")
    public void shutdownAll() {
        shutdown(emptyList());
    }


    @MethodHelp(description = "Restore ghost tasks and return their IDs from the workers.",
            returns = "A list of task IDs of restored ghost tasks")
    public List<String> restoreGhostTasks() {
        return proxies.getWorkers().reregisterGhostTasks();
    }

}
