package com.xebialabs.deployit.rest.test.api

import datasets._

import javax.ws.rs.core.Response
import javax.ws.rs.{ PathParam, POST, Path }

import org.springframework.stereotype.Component

@Component
@Path("/generate")
class DataGenerator {

  val sets: Map[String, DataSet] = Set(SampleSet, RiaTestSet, DemoSet).map { s: DataSet =>
    (s.name(), s)
  }.toMap

  @POST
  @Path("/{set}")
  def generate(@PathParam("set") dataSet: String): Response = {
    sets.get(dataSet) match {
      case None => Response.serverError().build()
      case Some(x) => {
        x.generateSet()
        Response.noContent().build()
      }
    }
  }
}

trait DataSet extends Generator {
  def name(): String
  def generateSet()
}
