/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.rest.test.api;

import com.google.common.collect.Multimap;
import com.xebialabs.deployit.deployment.planner.DeltaSpecificationBuilder;
import com.xebialabs.deployit.plugin.TestServiceHolder;
import com.xebialabs.deployit.plugin.api.deployment.execution.Plan;
import com.xebialabs.deployit.plugin.api.deployment.specification.DeltaSpecification;
import com.xebialabs.deployit.plugin.api.udm.Container;
import com.xebialabs.deployit.plugin.api.udm.Deployable;
import com.xebialabs.deployit.plugin.api.udm.Deployed;
import com.xebialabs.deployit.plugin.api.udm.DeployedApplication;
import com.xebialabs.deployit.plugin.api.udm.DeploymentPackage;
import com.xebialabs.deployit.plugin.api.udm.Environment;
import com.xebialabs.deployit.plugin.api.udm.Version;
import com.xebialabs.deployit.repository.ChangeSet;
import com.xebialabs.deployit.repository.RepositoryServiceHolder;
import com.xebialabs.deployit.repository.WorkDir;
import com.xebialabs.deployit.rest.test.api.Generator;
import com.xebialabs.deployit.rest.test.api.Generator$;
import com.xebialabs.deployit.security.PermissionEditor;
import com.xebialabs.deployit.security.Role;
import com.xebialabs.deployit.security.RoleService;
import com.xebialabs.deployit.security.permission.Permission;
import com.xebialabs.deployit.server.api.importer.ImportSource;
import com.xebialabs.deployit.service.deployment.DeployedGenerator;
import com.xebialabs.deployit.service.deployment.DeploymentOperationCalculator;
import com.xebialabs.deployit.service.deployment.TypeCalculator;
import com.xebialabs.deployit.service.importer.source.FileSource;
import com.xebialabs.deployit.service.replacement.ConsolidatedDictionary;
import com.xebialabs.deployit.task.DeploymentTask;
import com.xebialabs.deployit.task.Task;
import com.xebialabs.deployit.task.TaskForReporting;
import com.xebialabs.deployit.task.deployment.InitialDeploymentTask;
import com.xebialabs.deployit.test.deployment.DeltaSpecifications;
import com.xebialabs.deployit.test.deployment.DeployitTester;
import java.io.File;
import java.util.Collection;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import scala.Function1;
import scala.Serializable;
import scala.collection.JavaConversions$;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.mutable.HashSet;
import scala.collection.mutable.Set$;
import scala.runtime.BoxedUnit;

public abstract class Generator$class {
    public static void user(Generator $this, String name) {
        TestServiceHolder.getUserService().create(name, name);
    }

    public static void role(Generator $this, String name, List principals) {
        RoleService service = TestServiceHolder.getRoleService();
        java.util.List assignments = service.readRoleAssignments();
        Role role = new Role(name);
        role.getPrincipalsAssigned().addAll(JavaConversions$.MODULE$.seqAsJavaList((Seq)principals));
        assignments.add(role);
        service.writeRoleAssignments(assignments);
    }

    public static void create(Generator $this, Function1 c) {
        ChangeSet changeSet = new ChangeSet();
        Generator.Creator creator = new Generator.Creator($this, changeSet);
        c.apply((Object)creator);
        RepositoryServiceHolder.getRepositoryService().execute(changeSet);
        creator.cleanUp();
    }

    private static Object read(Generator $this, String id, WorkDir workDir) {
        return RepositoryServiceHolder.getRepositoryService().read(id, workDir);
    }

    public static void grant(Generator $this, String role, String perm, String onCi) {
        PermissionEditor editor = TestServiceHolder.getPermissionEditor();
        Multimap permissions = editor.readPermissions(onCi);
        permissions.put((Object)TestServiceHolder.getRoleService().getRoleForRoleName(role), (Object)Permission.find((String)perm));
        editor.editPermissions(onCi, permissions);
    }

    public static String grant$default$3(Generator $this, String role) {
        return "";
    }

    public static void task(Generator $this, Function1 c) {
        TaskForReporting taskForReporting = new TaskForReporting();
        c.apply((Object)taskForReporting);
        TestServiceHolder.getTaskArchive().archiveTask((DeploymentTask)taskForReporting);
    }

    public static String deploy(Generator $this, String dpId, String envId) {
        WorkDir workDir$1 = TestServiceHolder.getWorkDirFactory().newWorkDir();
        DeploymentPackage dp = (DeploymentPackage)Generator$class.read($this, dpId, workDir$1);
        Environment env2 = (Environment)Generator$class.read($this, envId, workDir$1);
        scala.collection.mutable.Set set = Generator$class.generateDeployeds($this, dp, env2);
        DeltaSpecification specification$1 = Generator$class.createSpecification($this, dp, env2, set);
        Plan plan$1 = $this.tester().resolvePlan(specification$1);
        CountDownLatch latch$1 = new CountDownLatch(1);
        InitialDeploymentTask initialDeploymentTask = new InitialDeploymentTask($this, workDir$1, specification$1, plan$1, latch$1){
            private final CountDownLatch latch$1;

            public void doAfterTaskStateChangedToDone() {
                try {
                    super.doAfterTaskStateChangedToDone();
                    return;
                }
                finally {
                    this.latch$1.countDown();
                }
            }

            public void doAfterTaskStateChangedToAborted() {
                try {
                    super.doAfterTaskStateChangedToAborted();
                    return;
                }
                finally {
                    this.latch$1.countDown();
                }
            }
            {
                this.latch$1 = countDownLatch;
                super(deltaSpecification, plan.getSteps(), RepositoryServiceHolder.getRepositoryService(), workDir);
            }
        };
        String taskId = TestServiceHolder.getExecutionEngine().register((Task)initialDeploymentTask);
        TestServiceHolder.getExecutionEngine().execute(taskId);
        latch$1.await();
        return taskId;
    }

    private static scala.collection.mutable.Set generateDeployeds(Generator $this, DeploymentPackage dp, Environment env$1) {
        DeployedGenerator deployedGenerator$1 = new DeployedGenerator(RepositoryServiceHolder.getRepositoryService(), new TypeCalculator());
        ConsolidatedDictionary dict$1 = ConsolidatedDictionary.create((Collection)env$1.getDictionaries());
        HashSet set$1 = new HashSet();
        JavaConversions$.MODULE$.asScalaSet(dp.getDeployables()).foreach((Function1)new Serializable($this, env$1, deployedGenerator$1, dict$1, (scala.collection.mutable.Set)set$1){
            public static final long serialVersionUID;
            private final Environment env$1;
            public final DeployedGenerator deployedGenerator$1;
            public final ConsolidatedDictionary dict$1;
            public final scala.collection.mutable.Set set$1;

            static {
                long l = serialVersionUID = 0L;
            }

            public final void apply(Deployable d$1) {
                JavaConversions$.MODULE$.asScalaSet(this.env$1.getMembers()).foreach((Function1)new Serializable(this, d$1){
                    public static final long serialVersionUID;
                    private final Generator$.anonfun.generateDeployeds.1 $outer;
                    private final Deployable d$1;

                    static {
                        long l = serialVersionUID = 0L;
                    }

                    public final Object apply(Container c) {
                        Deployed deployed = this.$outer.deployedGenerator$1.generateMostSpecificDeployed(this.d$1, c, this.$outer.dict$1);
                        return deployed == null ? BoxedUnit.UNIT : this.$outer.set$1.$plus$eq((Object)deployed);
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.d$1 = deployable;
                    }
                });
            }
            {
                this.env$1 = environment2;
                this.deployedGenerator$1 = deployedGenerator;
                this.dict$1 = consolidatedDictionary;
                this.set$1 = set;
            }
        });
        return set$1;
    }

    private static DeltaSpecification createSpecification(Generator $this, DeploymentPackage dp, Environment env2, scala.collection.mutable.Set set) {
        DeployedApplication deployedApp = DeltaSpecifications.createDeployedApplication((Version)dp, (Environment)env2);
        DeltaSpecificationBuilder builder = DeltaSpecificationBuilder.newSpecification().initial(deployedApp);
        DeploymentOperationCalculator.calculate((DeltaSpecificationBuilder)builder, (Set)JavaConversions$.MODULE$.mutableSetAsJavaSet(Set$.MODULE$.empty()), (Set)JavaConversions$.MODULE$.mutableSetAsJavaSet(set));
        return builder.build();
    }

    public static void importPackage(Generator $this, String id) {
        File dir = TestServiceHolder.getImporterService().getImportablePackageDirectory();
        String string = TestServiceHolder.getImporterService().importPackage((ImportSource)new FileSource(new File(dir, id).getPath(), false));
    }

    public static void $init$(Generator $this) {
        $this.com$xebialabs$deployit$rest$test$api$Generator$_setter_$tester_$eq(DeployitTester.build());
    }
}

