package com.xebialabs.deployit.rest.test.api.datasets

import com.xebialabs.deployit.rest.test.api.DataSet
import com.xebialabs.deployit.plugin.api.udm.Environment
import com.xebialabs.overthere.local.LocalFile
import java.io.File
import com.google.common.io.Files
import com.google.common.base.Charsets
import com.xebialabs.deployit.util.GuavaFiles

object SampleSet extends DataSet {
	def name() = "sample"

	def generateSet() {
		val tempDir: File = Files.createTempDir()
		try {
			create { c =>
				for (i <- 1 to 10) yield c.environment("env" + i) {
					c.server("server" + i) { s => Unit } ::
					Nil
				}

				c.environment("otherEnv") {
					c.server("server_1") { s => Unit } ::
					c.server("server_2") { s => Unit } ::
					Nil
				}

				val app1 = c.application("app1")
				c.deploymentPackage("1.0", app1) { dp =>
					c.ear("ear1", dp) { e =>
						e.setFile(LocalFile.valueOf({
							val file: File = new File(tempDir, "ear1.ear")
							file.createNewFile()
							Files.write("**********", file, Charsets.UTF_8)
							file
						})) } ::
					Nil
				}
			}
		} finally {
			try {
				GuavaFiles.deleteRecursively(tempDir)
			} catch {
				case e: Exception => print(e)
			}
		}

		user("mary")
		val grantMary = grant("mary") _
		grantMary("read", "Applications/app1")
		grantMary("login", "")

		deploy("Applications/app1/1.0", "Environments/env1")

		task { t =>
			t.failed.forApp("foo").forVersion("1.0").forEnv("env1")
		}

		task { t =>
			t.success.forApp("foo").forVersion("1.0").forEnv("env1")
		}
	}
}