package com.xebialabs.deployit.integration.test.support;

import java.io.File;
import java.util.concurrent.atomic.AtomicReference;

/**
 */
public class TemporaryDirectoryHolder {

    private static final AtomicReference<File> FOLDERHOLDER = new AtomicReference<File>();

    public static void init(File tempRoot) {
        FOLDERHOLDER.set(tempRoot);
    }

    public static void destroy() {
        FOLDERHOLDER.set(null);
    }

    public static File getTemporaryDirectory() {
        return FOLDERHOLDER.get();
    }
}
