/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.integration.test;

import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.junit.internal.runners.model.EachTestNotifier;
import org.junit.runner.Runner;
import org.junit.runner.notification.RunNotifier;
import org.junit.runners.BlockJUnit4ClassRunner;
import org.junit.runners.Parameterized;
import org.junit.runners.Suite;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.InitializationError;
import org.junit.runners.model.Statement;
import org.junit.runners.model.TestClass;

public class NiceParameterizedNames
extends Suite {
    private final ArrayList<Runner> runners = new ArrayList();

    public NiceParameterizedNames(Class<?> clazz) throws Throwable {
        super(clazz, Collections.emptyList());
        List<Object[]> list = this.getParametersList(this.getTestClass());
        for (int i = 0; i < list.size(); ++i) {
            this.runners.add((Runner)new TestClassRunnerForParameters(this.getTestClass().getJavaClass(), list, i));
        }
    }

    protected List<Runner> getChildren() {
        return this.runners;
    }

    private List<Object[]> getParametersList(TestClass testClass) throws Throwable {
        return (List)this.getParametersMethod(testClass).invokeExplosively(null, new Object[0]);
    }

    private FrameworkMethod getParametersMethod(TestClass testClass) {
        List list = testClass.getAnnotatedMethods(Parameterized.Parameters.class);
        for (FrameworkMethod frameworkMethod : list) {
            int n = frameworkMethod.getMethod().getModifiers();
            if (!Modifier.isStatic(n) || !Modifier.isPublic(n)) continue;
            return frameworkMethod;
        }
        throw new RuntimeException("No public static parameters method on class " + testClass.getName());
    }

    private class TestClassRunnerForParameters
    extends BlockJUnit4ClassRunner {
        private final int fParameterSetNumber;
        private final List<Object[]> fParameterList;

        TestClassRunnerForParameters(Class<?> clazz, List<Object[]> list, int n) throws InitializationError {
            super(clazz);
            this.fParameterList = list;
            this.fParameterSetNumber = n;
        }

        protected void runChild(FrameworkMethod frameworkMethod, RunNotifier runNotifier) {
            EachTestNotifier eachTestNotifier = new EachTestNotifier(runNotifier, this.describeChild(frameworkMethod));
            if (!((Boolean)this.computeParams()[1]).booleanValue()) {
                eachTestNotifier.fireTestIgnored();
            } else {
                super.runChild(frameworkMethod, runNotifier);
            }
        }

        public Object createTest() throws Exception {
            return this.getTestClass().getOnlyConstructor().newInstance(this.computeParams()[0]);
        }

        private Object[] computeParams() {
            try {
                return this.fParameterList.get(this.fParameterSetNumber);
            }
            catch (ClassCastException classCastException) {
                throw new RuntimeException(String.format("%s.%s() must return a Collection of arrays.", this.getTestClass().getName(), NiceParameterizedNames.this.getParametersMethod(this.getTestClass()).getName()));
            }
        }

        protected String getName() {
            return String.format("[%s]", this.fParameterList.get(this.fParameterSetNumber)[0]);
        }

        protected String testName(FrameworkMethod frameworkMethod) {
            return String.format("%s%s", frameworkMethod.getName(), this.getName());
        }

        protected void validateConstructor(List<Throwable> list) {
            this.validateOnlyOneConstructor(list);
        }

        protected Statement classBlock(RunNotifier runNotifier) {
            return this.childrenInvoker(runNotifier);
        }
    }
}

