/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.integration.test;

import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.junit.internal.runners.model.EachTestNotifier;
import org.junit.runner.Runner;
import org.junit.runner.notification.RunNotifier;
import org.junit.runners.BlockJUnit4ClassRunner;
import org.junit.runners.Parameterized;
import org.junit.runners.Suite;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.InitializationError;
import org.junit.runners.model.Statement;
import org.junit.runners.model.TestClass;

public class NiceParameterizedNames
extends Suite {
    private final ArrayList<Runner> runners = new ArrayList();

    public NiceParameterizedNames(Class<?> klass) throws Throwable {
        super(klass, Collections.emptyList());
        List<Object[]> parametersList = this.getParametersList(this.getTestClass());
        for (int i = 0; i < parametersList.size(); ++i) {
            this.runners.add((Runner)new TestClassRunnerForParameters(this.getTestClass().getJavaClass(), parametersList, i));
        }
    }

    protected List<Runner> getChildren() {
        return this.runners;
    }

    private List<Object[]> getParametersList(TestClass klass) throws Throwable {
        return (List)this.getParametersMethod(klass).invokeExplosively(null, new Object[0]);
    }

    private FrameworkMethod getParametersMethod(TestClass testClass) {
        List methods = testClass.getAnnotatedMethods(Parameterized.Parameters.class);
        for (FrameworkMethod each : methods) {
            int modifiers = each.getMethod().getModifiers();
            if (!Modifier.isStatic(modifiers) || !Modifier.isPublic(modifiers)) continue;
            return each;
        }
        throw new RuntimeException("No public static parameters method on class " + testClass.getName());
    }

    private class TestClassRunnerForParameters
    extends BlockJUnit4ClassRunner {
        private final int fParameterSetNumber;
        private final List<Object[]> fParameterList;

        TestClassRunnerForParameters(Class<?> type, List<Object[]> parameterList, int i) throws InitializationError {
            super(type);
            this.fParameterList = parameterList;
            this.fParameterSetNumber = i;
        }

        protected void runChild(FrameworkMethod method, RunNotifier notifier) {
            EachTestNotifier eachNotifier = new EachTestNotifier(notifier, this.describeChild(method));
            if (!((Boolean)this.computeParams()[1]).booleanValue()) {
                eachNotifier.fireTestIgnored();
            } else {
                super.runChild(method, notifier);
            }
        }

        public Object createTest() throws Exception {
            return this.getTestClass().getOnlyConstructor().newInstance(this.computeParams()[0]);
        }

        private Object[] computeParams() {
            try {
                return this.fParameterList.get(this.fParameterSetNumber);
            }
            catch (ClassCastException e) {
                throw new RuntimeException(String.format("%s.%s() must return a Collection of arrays.", this.getTestClass().getName(), NiceParameterizedNames.this.getParametersMethod(this.getTestClass()).getName()));
            }
        }

        protected String getName() {
            return String.format("[%s]", this.fParameterList.get(this.fParameterSetNumber)[0]);
        }

        protected String testName(FrameworkMethod method) {
            return String.format("%s%s", method.getName(), this.getName());
        }

        protected void validateConstructor(List<Throwable> errors) {
            this.validateOnlyOneConstructor(errors);
        }

        protected Statement classBlock(RunNotifier notifier) {
            return this.childrenInvoker(notifier);
        }
    }
}

