/*
 * Decompiled with CFR 0.152.
 */
package com.xebia.ad.setup;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum SetupDatabaseType {
    ORACLE,
    MYSQL,
    HSQLDB,
    DB2;


    public static String getDefaultDatabaseDriverClass(SetupDatabaseType databaseType) {
        switch (databaseType) {
            case ORACLE: {
                return "oracle.jdbc.driver.OracleDriver";
            }
            case MYSQL: {
                return "com.mysql.jdbc.Driver";
            }
            case HSQLDB: {
                return "org.hsqldb.jdbcDriver";
            }
            case DB2: {
                return "com.ibm.db2.jcc.DB2Driver";
            }
        }
        throw new RuntimeException("Database " + (Object)((Object)databaseType) + " type is not supported");
    }

    public static String getDatabaseSpringConfiguration(SetupDatabaseType databaseType) {
        switch (databaseType) {
            case ORACLE: {
                return "ad-core-context-oracle-nocreate.xml";
            }
            case MYSQL: {
                return "ad-core-context-mysql-nocreate.xml";
            }
            case HSQLDB: {
                return "ad-core-context-hsqldb-file-nocreate.xml";
            }
            case DB2: {
                return "ad-core-context-db2-file-nocreate.xml";
            }
        }
        throw new RuntimeException("Database " + (Object)((Object)databaseType) + " type is not supported");
    }

    public static String getCreationalDatabaseSpringConfiguration(SetupDatabaseType databaseType) {
        switch (databaseType) {
            case ORACLE: {
                return "ad-core-context-oracle-create.xml";
            }
            case MYSQL: {
                return "ad-core-context-mysql-create.xml";
            }
            case HSQLDB: {
                return "ad-core-context-hsqldb-file-create.xml";
            }
            case DB2: {
                return "ad-core-context-db2-file-create.xml";
            }
        }
        throw new RuntimeException("Database " + (Object)((Object)databaseType) + " type is not supported");
    }

    public static String getDatabaseJPAConfiguration(SetupDatabaseType databaseType) {
        switch (databaseType) {
            case ORACLE: {
                return "oracle";
            }
            case MYSQL: {
                return "mysql";
            }
            case HSQLDB: {
                return "hsqldb";
            }
            case DB2: {
                return "db2";
            }
        }
        throw new RuntimeException("Database " + (Object)((Object)databaseType) + " type is not supported");
    }

    public static String getHibernateDialect(SetupDatabaseType databaseType) {
        switch (databaseType) {
            case ORACLE: {
                return "org.hibernate.dialect.OracleDialect";
            }
            case MYSQL: {
                return "org.hibernate.dialect.MySQL5InnoDBDialect";
            }
            case HSQLDB: {
                return "org.hibernate.dialect.HSQLDialect";
            }
            case DB2: {
                return "org.hibernate.dialect.DB2Dialect";
            }
        }
        throw new RuntimeException("Database " + (Object)((Object)databaseType) + " type is not supported");
    }

    public static String getExampleConnectionURL(SetupDatabaseType databaseType) {
        switch (databaseType) {
            case ORACLE: {
                return "jdbc:oracle:thin:@<HOSTNAME>:<PORT, default is 1521>:<SID>";
            }
            case MYSQL: {
                return "jdbc:mysql://<HOSTNAME>/<DATABASE>";
            }
            case HSQLDB: {
                return "jdbc:hsqldb:file:<PATH TO HSQLDB DB FILE>/<HSQLDB FILENAME>;shutdown=true";
            }
            case DB2: {
                return "jdbc:db2://<HOSTNAME>:<PORT, default is 50001>/<DATABASE>";
            }
        }
        throw new RuntimeException("Database " + (Object)((Object)databaseType) + " type is not supported");
    }

    public static String getDefaultConnectionURL(SetupDatabaseType databaseType) {
        switch (databaseType) {
            case ORACLE: {
                return "jdbc:oracle:thin:@localhost:1521:DEPLOYIT";
            }
            case MYSQL: {
                return "jdbc:mysql://localhost/ad";
            }
            case HSQLDB: {
                return "jdbc:hsqldb:file:deployit.hdb;shutdown=true";
            }
            case DB2: {
                return "jdbc:db2://db2-97:50002/SAMPLE:retrieveMessagesFromServerOnGetMessage=true;";
            }
        }
        throw new RuntimeException("Database " + (Object)((Object)databaseType) + " type is not supported");
    }

    public static String getDefaultUsername(SetupDatabaseType databaseType) {
        switch (databaseType) {
            case ORACLE: {
                return "";
            }
            case MYSQL: {
                return "";
            }
            case HSQLDB: {
                return "sa";
            }
            case DB2: {
                return "ad";
            }
        }
        throw new RuntimeException("Database " + (Object)((Object)databaseType) + " type is not supported");
    }
}

