/*
 * Decompiled with CFR 0.152.
 */
package com.xebia.ad.service.impl;

import com.xebia.ad.repository.ConfigurationItemTypeDescriptorRepository;
import com.xebia.ad.repository.metadata.ChangePlan;
import com.xebia.ad.repository.metadata.ConfigurationItemHandle;
import com.xebia.ad.repository.metadata.ConfigurationItemRevision;
import com.xebia.ad.repository.resolvers.RepositoryView;
import com.xebia.ad.service.ConfigurationItemMetaData;
import com.xebia.ad.service.dto.DTOFactory;
import com.xebia.ad.service.impl.ConfigurationItemUpdateCommand;
import com.xebialabs.deployit.ResolutionException;
import com.xebialabs.deployit.ci.Deployment;
import com.xebialabs.deployit.ci.Environment;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConfigurationItemUpdateCommandPreprocessor {
    @Autowired
    public ConfigurationItemTypeDescriptorRepository repository;
    @Autowired
    public DTOFactory dtoFactory;

    public List<ConfigurationItemUpdateCommand> preprocessUpdateCommand(ChangePlan changePlan, ConfigurationItemUpdateCommand updateCommand, List<String> warnings) {
        String type = updateCommand.getNewRevision().getType();
        if (type.equals(Deployment.class.getName())) {
            return this.updateMappings(changePlan, updateCommand, warnings);
        }
        if (type.equals(Environment.class.getName())) {
            return this.checkEnvironmentIsAddedToItself(changePlan, updateCommand);
        }
        return Collections.singletonList(updateCommand);
    }

    private List<ConfigurationItemUpdateCommand> checkEnvironmentIsAddedToItself(ChangePlan changePlan, ConfigurationItemUpdateCommand updateCommand) {
        ArrayList<ConfigurationItemUpdateCommand> commands = new ArrayList<ConfigurationItemUpdateCommand>();
        commands.add(updateCommand);
        ConfigurationItemRevision newEnvironmentRevision = updateCommand.getNewRevision();
        Set<ConfigurationItemHandle> members = newEnvironmentRevision.getRelatedCiHandles("members");
        for (ConfigurationItemHandle member : members) {
            if (!member.getLabel().equals(updateCommand.getLabel())) continue;
            throw new ResolutionException("Cannot add an environment " + updateCommand.getLabel() + "to itself");
        }
        return commands;
    }

    private List<ConfigurationItemUpdateCommand> updateMappings(ChangePlan changePlan, ConfigurationItemUpdateCommand updateDeploymentCommand, List<String> warnings) {
        Serializable eachPackageMember;
        ArrayList<ConfigurationItemUpdateCommand> commands = new ArrayList<ConfigurationItemUpdateCommand>();
        commands.add(updateDeploymentCommand);
        RepositoryView view = RepositoryView.getDesignView(changePlan);
        ConfigurationItemRevision newDeploymentRevision = updateDeploymentCommand.getNewRevision();
        ConfigurationItemHandle newPackageHandle = newDeploymentRevision.getRelatedCiHandle("source");
        ConfigurationItemRevision newPackageRevision = view.getViewRevision(newPackageHandle);
        HashSet<ConfigurationItemHandle> newPackageMemberHandles = new HashSet<ConfigurationItemHandle>();
        newPackageMemberHandles.addAll(newPackageRevision.getRelatedCiHandles("deployableArtifacts"));
        newPackageMemberHandles.addAll(newPackageRevision.getRelatedCiHandles("middlewareResources"));
        Set<ConfigurationItemHandle> mappingHandles = newDeploymentRevision.getRelatedCiHandles("mappings");
        block0: for (ConfigurationItemHandle mappingHandle : mappingHandles) {
            ConfigurationItemRevision mappingRevision = view.getViewRevision(mappingHandle);
            ConfigurationItemHandle mappingSourceHandle = mappingRevision.getRelatedCiHandle("source");
            if (newPackageMemberHandles.contains(mappingSourceHandle)) continue;
            Serializable mappingSource = view.getViewDetails(mappingSourceHandle);
            for (ConfigurationItemHandle eachPackageMemberHandle : newPackageMemberHandles) {
                eachPackageMember = view.getViewDetails(eachPackageMemberHandle);
                if (!this.repository.isSimilar(eachPackageMember, mappingSource)) continue;
                commands.add(this.createMappingUpdateCommand(view, mappingRevision, eachPackageMemberHandle));
                continue block0;
            }
        }
        block2: for (ConfigurationItemHandle deployableArtifactHandle : newPackageMemberHandles) {
            for (ConfigurationItemHandle mappingHandle : mappingHandles) {
                ConfigurationItemRevision mappingRevision = view.getViewRevision(mappingHandle);
                ConfigurationItemHandle mappingSourceHandle = mappingRevision.getRelatedCiHandle("source");
                if (mappingSourceHandle.equals(deployableArtifactHandle)) continue block2;
                Serializable mappingSource = view.getViewDetails(mappingSourceHandle);
                eachPackageMember = view.getViewDetails(deployableArtifactHandle);
                if (!this.repository.isSimilar(eachPackageMember, mappingSource)) continue;
                continue block2;
            }
            warnings.add("Warning: deployable artifact " + deployableArtifactHandle.getLabel() + " of type " + deployableArtifactHandle.getType() + "  is not mapped to any target");
        }
        return commands;
    }

    private ConfigurationItemUpdateCommand createMappingUpdateCommand(RepositoryView view, ConfigurationItemRevision mappingRevision, ConfigurationItemHandle newMappingSourceHandle) {
        ConfigurationItemHandle mappingHandle = mappingRevision.getHandle();
        String mappingLabel = mappingHandle.getLabel();
        String mappingDescription = mappingHandle.getDescription();
        ConfigurationItemMetaData mappingMetadata = this.dtoFactory.createActualConfigurationItemMetaData(mappingRevision, null, null);
        mappingMetadata.getCiRelationsHandleIds().put("source", Collections.singletonList(newMappingSourceHandle.getId()));
        ConfigurationItemRevision newMappingRevision = this.dtoFactory.createConfigurationItemRevision(mappingMetadata, mappingRevision.getDetailsObject(view));
        return new ConfigurationItemUpdateCommand(mappingHandle, mappingLabel, mappingDescription, newMappingRevision);
    }
}

