/*
 * Decompiled with CFR 0.152.
 */
package com.xebia.ad.repository.metadata;

import com.xebia.ad.repository.metadata.Change;
import com.xebia.ad.repository.metadata.ChangePlan;
import com.xebia.ad.repository.metadata.StepContainer;
import com.xebia.ad.repository.metadata.StepState;
import com.xebia.ad.service.AutomatedDeploymentListener;
import com.xebialabs.deployit.StepExecutionContext;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Step
implements Serializable,
com.xebialabs.deployit.Step {
    private transient StepContainer stepContainer;
    private static Logger logger = Logger.getLogger(Step.class);

    protected Step() {
        this(null);
    }

    protected Step(String description) {
        this.stepContainer = new StepContainer(this, description);
    }

    public boolean isExecuting() {
        return this.getState() == StepState.EXECUTING;
    }

    public boolean isPaused() {
        return this.getState() == StepState.PAUSED;
    }

    public boolean isFinished() {
        return this.getState() == StepState.DONE || this.getState() == StepState.SKIPPED;
    }

    public void skip() {
        if (this.isFinished()) {
            return;
        }
        this.setState(StepState.SKIPPED);
    }

    public void unSkip() {
        if (this.getState() != StepState.SKIPPED) {
            return;
        }
        this.setState(StepState.PENDING);
    }

    public void execute(AutomatedDeploymentListener listener, Map<String, Object> secAttributes) {
        if (this.isFinished()) {
            return;
        }
        if (this.isPaused()) {
            this.setState(StepState.DONE);
            return;
        }
        this.startExecute(listener);
        this.finishExecute(listener, secAttributes);
    }

    public void startExecute(AutomatedDeploymentListener listener) {
        this.clearLog();
        this.setState(StepState.EXECUTING);
        listener.stepUpdated(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finishExecute(AutomatedDeploymentListener listener, Map<String, Object> secAttributes) {
        assert (this.getState() == StepState.EXECUTING);
        try {
            try {
                if (this.doExecute(listener, secAttributes)) {
                    this.setState(StepState.DONE);
                }
            }
            catch (Exception exc) {
                this.addLogLine("Unexpected exception: " + exc.getMessage());
                logger.error((Object)("Unexpected exception while executing step " + this.getId() + " of type " + this.getClass().getSimpleName()), (Throwable)exc);
            }
        }
        finally {
            if (this.getState() == StepState.EXECUTING) {
                this.setState(StepState.FAILED);
            }
            listener.stepUpdated(this);
        }
    }

    public boolean execute(StepExecutionContext ctx) {
        return this.doExecute(new AutomatedDeploymentListener(){

            public void changeCommitted(Change c) {
            }

            public void changePlanUpdated(ChangePlan changePlan) {
            }

            public void stepUpdated(Step step) {
            }

            public void log(String logLine) {
            }
        }, new HashMap<String, Object>());
    }

    public abstract boolean doExecute(AutomatedDeploymentListener var1, Map<String, Object> var2);

    StepContainer getStepContainer() {
        return this.stepContainer;
    }

    void setStepContainer(StepContainer stepContainer) {
        this.stepContainer = stepContainer;
    }

    public int getId() {
        return this.stepContainer.getId();
    }

    public int getPosition() {
        return this.stepContainer.getPosition();
    }

    public void setPosition(int position) {
        this.stepContainer.setPosition(position);
    }

    public StepState getState() {
        return this.stepContainer.getState();
    }

    public void setState(StepState state) {
        this.stepContainer.setState(state);
    }

    public ChangePlan getChangePlan() {
        return this.stepContainer.getChangePlan();
    }

    public String getDescription() {
        return this.stepContainer.getDescription();
    }

    public void setDescription(String description) {
        this.stepContainer.setDescription(description);
    }

    public String getLog() {
        return this.stepContainer.getLog();
    }

    public void clearLog() {
        this.stepContainer.clearLog();
    }

    public void addLogLine(String line) {
        this.stepContainer.addLogLine(line);
    }

    public void addLogLine(String line, AutomatedDeploymentListener listener) {
        this.addLogLine(line);
        listener.stepUpdated(this);
    }

    public String toString() {
        return this.getDescription();
    }
}

