/*
 * Decompiled with CFR 0.152.
 */
package com.xebia.ad.reporting.organizers;

import com.xebia.ad.reporting.organizers.ReportDataOrganizer;
import com.xebia.ad.reporting.transformers.ReportPropertyTransformer;
import java.beans.PropertyDescriptor;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.collections.set.ListOrderedSet;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ObjectBasedReportDataOrganizer
implements ReportDataOrganizer {
    private List<? extends Object> objectData;
    private String seriesProperty;
    private String groupProperty;
    private ReportPropertyTransformer propertyTransformer;
    private List<List<Map<Serializable, Serializable>>> groupedSeriesData = new ArrayList<List<Map<Serializable, Serializable>>>();
    private static Logger logger = Logger.getLogger(ObjectBasedReportDataOrganizer.class);

    public ObjectBasedReportDataOrganizer(List<? extends Object> objectData, String seriesProperty, String groupProperty, ReportPropertyTransformer propertyTransformer) {
        this.objectData = objectData;
        this.seriesProperty = seriesProperty;
        this.groupProperty = groupProperty;
        this.propertyTransformer = propertyTransformer;
    }

    @Override
    public List<List<Map<Serializable, Serializable>>> getCountedGroupedData() {
        this.process();
        return this.groupedSeriesData;
    }

    private void process() {
        List<Serializable> uniqueGroups = this.getUniqueProperties(this.groupProperty, "group");
        List<Serializable> uniqueSeries = this.getUniqueProperties(this.seriesProperty, "series");
        for (Serializable eachGroup : uniqueGroups) {
            ArrayList groupData = new ArrayList();
            for (Serializable eachSeries : uniqueSeries) {
                List<Object> seriesData = this.getFileteredData(eachGroup, eachSeries);
                HashMap<String, Serializable> datapoint = new HashMap<String, Serializable>();
                datapoint.put("group", eachGroup);
                Serializable propertyValue = this.propertyTransformer != null ? this.propertyTransformer.originalPropertyValue(eachSeries) : eachSeries;
                datapoint.put("series", propertyValue);
                datapoint.put("totalNo", Integer.valueOf(seriesData.size()));
                groupData.add(datapoint);
            }
            this.groupedSeriesData.add(groupData);
        }
    }

    private List<Object> getFileteredData(Serializable eachGroup, Serializable eachSeries) {
        ArrayList<Object> filteredData = new ArrayList<Object>();
        for (Object object : this.objectData) {
            Object seriesValue;
            Object groupValue = this.getValueOfProperty(object, this.groupProperty, "group");
            if (!groupValue.equals(eachGroup) || !(seriesValue = this.getValueOfProperty(object, this.seriesProperty, "series")).equals(eachSeries)) continue;
            filteredData.add(object);
        }
        return filteredData;
    }

    private List<Serializable> getUniqueProperties(String property, String propertyType) {
        ListOrderedSet uniquePropertiesSet = new ListOrderedSet();
        for (Object object : this.objectData) {
            Object transformedValue = this.getValueOfProperty(object, property, propertyType);
            uniquePropertiesSet.add(transformedValue);
        }
        return uniquePropertiesSet.asList();
    }

    private Object getValueOfProperty(Object obj, String property, String propertyType) {
        Object transformedValue = null;
        try {
            Method getter = PropertyUtils.getReadMethod((PropertyDescriptor)PropertyUtils.getPropertyDescriptor((Object)obj, (String)property));
            Object value = getter.invoke(obj, new Object[0]);
            transformedValue = propertyType == "group" ? value : (this.propertyTransformer != null ? this.propertyTransformer.transformPropertyValue(value) : value);
        }
        catch (Exception e) {
            logger.warn((Object)("No getter found for property:" + property + " on object of type:" + obj.getClass()));
        }
        return transformedValue;
    }

    public boolean isGroupPropertySpecified() {
        return !StringUtils.isEmpty((String)this.groupProperty);
    }

    public void setPropertyTransformer(ReportPropertyTransformer propertyTransformer) {
        this.propertyTransformer = propertyTransformer;
    }
}

