/*
 * Decompiled with CFR 0.152.
 */
package com.xebia.ad.cli;

import com.xebia.ad.DeployItConfiguration;
import com.xebia.ad.ReleaseInfo;
import com.xebia.ad.cli.CliException;
import com.xebia.ad.cli.PwdConsole;
import com.xebia.ad.conversion.ConversionException;
import com.xebia.ad.conversion.PropertyListConverter;
import com.xebia.ad.repository.ConfigurationItemTypeDescriptorRepository;
import com.xebia.ad.repository.metadata.ChangePlanState;
import com.xebia.ad.service.AutomatedDeploymentService;
import com.xebia.ad.service.ConfigurationItemMetaData;
import com.xebia.ad.service.design.ui.ChangePlanView;
import com.xebia.ad.service.design.ui.ChangeView;
import com.xebia.ad.service.design.ui.StepView;
import com.xebia.ad.service.dto.ConfigurationItemDetailsMapDeserializer;
import com.xebialabs.deployit.ci.DeploymentPackage;
import com.xebialabs.deployit.ci.security.PermissionScheme;
import com.xebialabs.deployit.reflect.ConfigurationItemDescriptor;
import com.xebialabs.deployit.reflect.ConfigurationItemPropertyDescriptor;
import com.xebialabs.deployit.reflect.ConfigurationItemPropertyType;
import com.xebialabs.deployit.util.TemplateResolver;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.support.ClassPathXmlApplicationContext;
import org.springframework.remoting.RemoteConnectFailureException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Interpreter {
    private static final String[] commands = new String[]{"help", "source", "create", "delete", "modify", "undo", "describe", "show", "show_type", "show_name", "check", "execute", "deployit", "skip", "clear", "deployit_nosteps", "export", "exit", "shutdown", "changeplan", "cleanrepository", "start", "stop", "forciblystop", "set", "unset", "import"};
    @Autowired(required=true)
    public AutomatedDeploymentService automatedDeploymentService;
    private ConfigurationItemTypeDescriptorRepository descriptorRepository;
    private String result;
    private Map<String, String> attributes;
    private TemplateResolver resolver;

    public static void main(String[] args) {
        String applicationContextName;
        DeployItConfiguration config = DeployItConfiguration.loadForUse();
        if (config.isSecured()) {
            if (args.length <= 2) {
                System.err.println("Deployit is running in secure mode. Please specify -user <username> and -password as the first three command line arguments");
                System.exit(1);
            }
            applicationContextName = "/cli/secured/ad-cli-context.xml";
            if (!args[0].equalsIgnoreCase("-user")) {
                System.err.println("Deployit is running in secure mode. Please specify -user as the first argument");
                System.exit(1);
            }
            System.setProperty("cli.username", args[1]);
            if (!args[2].equalsIgnoreCase("-password")) {
                System.err.println("Deployit is running in secure mode. Please specify -password as the third argument");
                System.exit(1);
            }
            String password = null;
            if (args.length == 3) {
                try {
                    password = PwdConsole.readPassword();
                    password = password.trim();
                }
                catch (Exception e) {
                    password = "";
                }
            } else if (args.length > 3) {
                password = args[3];
            }
            System.setProperty("cli.password", password);
        } else {
            applicationContextName = "/cli/unsecured/ad-cli-context.xml";
        }
        if (config.isSsl()) {
            System.setProperty("cli.protocol", "https");
            System.setProperty("javax.net.ssl.trustStore", config.getKeyStorePath());
            System.setProperty("javax.net.ssl.trustStorePassword", config.getKeyStorePassword());
        } else {
            System.setProperty("cli.protocol", "http");
        }
        ClassPathXmlApplicationContext ctx = new ClassPathXmlApplicationContext(new String[]{applicationContextName});
        Interpreter interpreter = (Interpreter)ctx.getBean("interpreter");
        if (interpreter != null) {
            interpreter.afterPropertiesSet();
            interpreter.interpret();
        } else {
            System.out.println("Can't find bean 'interpreter' in Spring context... giving up...");
        }
    }

    public void afterPropertiesSet() {
        this.descriptorRepository = new ConfigurationItemTypeDescriptorRepository(this.automatedDeploymentService.getConfigurationItemDescriptors());
    }

    public void interpret() {
        BufferedReader stdin = new BufferedReader(new InputStreamReader(System.in));
        ReleaseInfo rel = ReleaseInfo.getReleaseInfo();
        String prompt = rel.isEnterpriseEdition() ? "deployit> " : "deployit PERSONAL EDITION> ";
        while (true) {
            System.out.print(prompt);
            System.out.flush();
            String line = this.read(stdin);
            if (line == null) break;
            this.interpret(line);
        }
    }

    public void interpret(File f) {
        try {
            this.interpret(new FileInputStream(f));
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
    }

    public void interpret(InputStream is) {
        BufferedReader stdin = new BufferedReader(new InputStreamReader(is));
        String line = null;
        while ((line = this.read(stdin)) != null) {
            try {
                if (this.shouldChangePlanBeResolvedBeforeEvaluation(line.trim())) {
                    this.automatedDeploymentService.resolveCurrentChangePlan();
                }
                this.result = this.eval(line.trim());
                this.printResult(this.result);
            }
            catch (CliException ce) {
                this.printResult(ce.getMessage());
            }
        }
        try {
            stdin.close();
        }
        catch (IOException e) {
            // empty catch block
        }
    }

    public void interpret(String line) {
        try {
            this.result = this.eval(line);
            if (this.shouldChangePlanBeResolved(line.trim())) {
                this.automatedDeploymentService.resolveCurrentChangePlan();
            }
            this.printResult(this.result);
        }
        catch (CliException ce) {
            this.result = ce.getMessage();
            this.printResult(this.result);
        }
        catch (RemoteConnectFailureException e) {
            this.result = "Can't access backend service. Did you start the server?";
            this.printResult(this.result);
        }
        catch (RuntimeException exc) {
            this.result = "An internal error occurred: " + exc.toString();
            exc.printStackTrace();
        }
    }

    public void interpretAndThrowExceptions(String line) {
        this.result = this.eval(line);
        if (this.shouldChangePlanBeResolved(line.trim())) {
            this.automatedDeploymentService.resolveCurrentChangePlan();
        }
        this.printResult(this.result);
    }

    private boolean shouldChangePlanBeResolved(String line) {
        if (StringUtils.isNotBlank((String)line)) {
            String lineInLowerCase = line.toLowerCase();
            if (lineInLowerCase.startsWith("create")) {
                return true;
            }
            if (lineInLowerCase.startsWith("add")) {
                return true;
            }
            if (lineInLowerCase.startsWith("modify")) {
                return true;
            }
            if (lineInLowerCase.startsWith("delete")) {
                return true;
            }
            if (lineInLowerCase.startsWith("undo")) {
                return true;
            }
            if (lineInLowerCase.startsWith("source")) {
                return true;
            }
            if (lineInLowerCase.startsWith("remove")) {
                return true;
            }
            if (lineInLowerCase.startsWith("import")) {
                return true;
            }
        }
        return false;
    }

    private boolean shouldChangePlanBeResolvedBeforeEvaluation(String line) {
        String lineInLowerCase;
        return StringUtils.isNotBlank((String)line) && (lineInLowerCase = line.toLowerCase()).equals("deployit");
    }

    public void interpret(List<String> input) {
        for (String line : input) {
            this.interpret(line);
        }
    }

    private void printResult(String result) {
        if (result != null) {
            System.out.println(result);
        }
    }

    public String eval(String line) throws CliException {
        String[] tokens;
        if (line != null && line.startsWith("#")) {
            return null;
        }
        if (line != null && line.equals("")) {
            return null;
        }
        if (this.attributes == null) {
            this.attributes = new HashMap<String, String>();
        }
        if (this.resolver == null) {
            this.resolver = new TemplateResolver(this.attributes);
        }
        String resolvedLine = this.resolver.resolveLenient(line.trim());
        String savedLine = new String(resolvedLine);
        try {
            tokens = PropertyListConverter.tokenize(resolvedLine);
        }
        catch (ConversionException e1) {
            throw new CliException(e1.getMessage());
        }
        String command = tokens[0];
        if (command.equalsIgnoreCase("help")) {
            if (tokens.length == 1) {
                return "Basic commands are " + this.makeAllCommands() + ". Use 'help <command> to get details'";
            }
            return this.makeHelpFor(tokens[1]);
        }
        if (command.equalsIgnoreCase("source")) {
            File input = new File(tokens[1]);
            this.interpret(input);
        } else {
            if (command.equalsIgnoreCase("create")) {
                String addedCiLabel = this.addCI(tokens, savedLine);
                if (tokens.length == 3 && !tokens[1].equals("application")) {
                    return "Added a generic relation CI";
                }
                return "Added a " + tokens[1] + " CI - " + addedCiLabel;
            }
            if (command.equalsIgnoreCase("delete")) {
                this.delete(tokens, savedLine);
                return "Deleted a CI";
            }
            if (command.equalsIgnoreCase("modify")) {
                this.modify(tokens, savedLine);
                if (this.result == "") {
                    return "Modified a CI";
                }
                return this.result;
            }
            if (command.equalsIgnoreCase("import")) {
                String location = this.importDeploymentPackage(tokens, savedLine);
                if (this.result == "") {
                    return "Imported DeploymentPackage from " + location;
                }
                return this.result;
            }
            if (command.equalsIgnoreCase("undo")) {
                this.undo(tokens, savedLine);
                return "Reverted a CI";
            }
            if (command.equalsIgnoreCase("describe")) {
                this.describe(tokens, savedLine);
            } else {
                if (command.equalsIgnoreCase("show")) {
                    this.show(tokens, savedLine);
                    return this.result;
                }
                if (command.equalsIgnoreCase("show_type")) {
                    this.show_type(tokens, savedLine);
                    return this.result;
                }
                if (command.equalsIgnoreCase("show_name")) {
                    this.show_name(tokens, savedLine);
                    return this.result;
                }
                if (command.equalsIgnoreCase("shutdown")) {
                    this.shutdownServer();
                } else if (command.equalsIgnoreCase("cleanrepository")) {
                    this.cleanrepository(tokens);
                } else {
                    if (command.equalsIgnoreCase("export")) {
                        this.export(tokens, savedLine);
                        return this.result;
                    }
                    if (command.equalsIgnoreCase("execute") || command.equalsIgnoreCase("deployit")) {
                        String retval;
                        System.out.println("Executing and committing change plan...");
                        ChangePlanView cpv0 = this.automatedDeploymentService.findCurrentChangePlan();
                        if (cpv0 == null) {
                            retval = "No change plan to execute";
                        } else {
                            this.automatedDeploymentService.executeAndCommitCurrentChangePlan();
                            ChangePlanView cpv = this.automatedDeploymentService.findCurrentChangePlan();
                            retval = cpv == null ? "Change plan executed" : "ERROR during execution of change plan: " + cpv.getResolutionError() + "\nChange plan state: " + cpv.getState() + this.makeStepsLogs(cpv);
                        }
                        return retval;
                    }
                    if (command.equalsIgnoreCase("skip") || command.equalsIgnoreCase("deployit_nosteps")) {
                        System.out.println("Skipping and committing change plan....");
                        ChangePlanView cpv = this.automatedDeploymentService.skipAndCommitCurrentChangePlan();
                        String retval = cpv == null ? "No changeplan to skip" : (cpv.getState().equals(ChangePlanState.SKIPPED.toString()) ? "Changeplan skipped" : "ERROR during skipping of change plan: " + cpv.getResolutionError() + "\nChange plan state: " + cpv.getState() + this.makeStepsLogs(cpv));
                        return retval;
                    }
                    if (command.equalsIgnoreCase("clear")) {
                        System.out.println("Clearing change plan...");
                        ChangePlanView cpv = this.automatedDeploymentService.clearCurrentChangePlan();
                        String retval = cpv == null ? "No change plan to clear" : (cpv.getState().equals(ChangePlanState.CLEARED.toString()) ? "Change plan cleared" : "ERROR during clearing of change plan: " + cpv.getResolutionError() + "\nChange plan state: " + cpv.getState() + this.makeStepsLogs(cpv));
                        return retval;
                    }
                    if (command.equalsIgnoreCase("check")) {
                        System.out.println("Checking existence of CI's...");
                        boolean checkPassed = true;
                        try {
                            checkPassed = this.checkConfigurationItemCreation(tokens);
                        }
                        catch (ConversionException e) {
                            throw new CliException(e.getMessage());
                        }
                        return "check " + (checkPassed ? "passed" : "failed");
                    }
                    if (command.equalsIgnoreCase("exit")) {
                        System.exit(0);
                    } else {
                        if (command.equalsIgnoreCase("changeplan")) {
                            this.changeplan(tokens, savedLine);
                            return this.result;
                        }
                        if (command.equalsIgnoreCase("set")) {
                            this.set(tokens, savedLine);
                            return this.result;
                        }
                        if (command.equalsIgnoreCase("unset")) {
                            this.unset(tokens, savedLine);
                            return this.result;
                        }
                        throw new CliException("I do not understand \"" + line + "\" as the first word is not " + this.makeAllCommands());
                    }
                }
            }
        }
        return null;
    }

    private void cleanrepository(String[] tokens) throws CliException {
        SimpleDateFormat dateFormat = new SimpleDateFormat("dd/mm/yyyy");
        try {
            this.automatedDeploymentService.removeLoggingInformationOlderThan(dateFormat.parse(tokens[1]));
            System.out.println("Repository cleaned up successfully");
        }
        catch (ParseException exc) {
            throw new CliException(exc.getMessage());
        }
    }

    private String makeStepsLogs(ChangePlanView cpv) {
        List<StepView> steps = cpv.getSteps();
        StringBuilder sb = new StringBuilder();
        sb.append("\nStep logs:");
        for (StepView step : steps) {
            sb.append("Step " + step.getPosition() + "\n");
            sb.append(step.getLog() + "\n");
        }
        return sb.toString();
    }

    private void shutdownServer() {
        System.out.println("Shutting down the server...");
        this.automatedDeploymentService.shutdownServer();
    }

    private void modify(String[] tokens, String savedLine) throws CliException {
        String permissionSchemeLabel;
        String description;
        this.result = "";
        String whatToModify = tokens[1];
        ConfigurationItemMetaData item = this.automatedDeploymentService.findDesignConfigurationItemByLabel(whatToModify);
        if (item == null) {
            throw new CliException("Can't modify properties of a CI with label \"" + whatToModify + "\" as such a CI does not exist");
        }
        Map<String, String> attributes = null;
        try {
            attributes = PropertyListConverter.makeAttributes(2, this.filterMembershipChanges(tokens, true));
        }
        catch (ConversionException e) {
            throw new CliException(e.getMessage());
        }
        Map<String, Object> detailsMap = this.automatedDeploymentService.getConfigurationItem(item.getRevisionId());
        ConfigurationItemDescriptor itemDescriptor = this.descriptorRepository.getDescriptor(item.getConfigurationItemClassName());
        ConfigurationItemPropertyDescriptor[] propertyDescriptors = itemDescriptor.getPropertyDescriptors();
        for (String attribute : attributes.keySet()) {
            if ("label".equals(attribute) || "description".equals(attribute) || "permissionscheme".equals(attribute) || this.editable(attribute, propertyDescriptors)) continue;
            throw new CliException("Can't modify property \"" + attribute + "\" of CI with label \"" + whatToModify + "\" as it is not editable");
        }
        try {
            PropertyListConverter.populateMap(attributes, detailsMap, propertyDescriptors);
        }
        catch (ConversionException e) {
            throw new CliException(e.getMessage());
        }
        String[] membershipChangesTokens = this.filterMembershipChanges(tokens, false);
        if (membershipChangesTokens != null && membershipChangesTokens.length > 0) {
            try {
                this.processMembershipChanges(item, membershipChangesTokens, itemDescriptor);
            }
            catch (CliException ce) {
                throw new CliException("don't understand: " + savedLine + " as I " + ce.getMessage());
            }
        }
        try {
            this.processRelations(item, attributes, itemDescriptor);
        }
        catch (CliException ce) {
            throw new CliException("don't understand: " + savedLine + " as I " + ce.getMessage());
        }
        String label = attributes.get("label");
        if (StringUtils.isNotEmpty((String)label)) {
            item.setLabel(label);
        }
        if (StringUtils.isNotEmpty((String)(description = attributes.get("description")))) {
            item.setDescription(description);
        }
        if (StringUtils.isNotEmpty((String)(permissionSchemeLabel = attributes.get("permissionscheme")))) {
            ConfigurationItemMetaData permissionSchemeMetaData = this.automatedDeploymentService.findActualConfigurationItemByLabel(permissionSchemeLabel);
            if (permissionSchemeMetaData == null) {
                throw new CliException("Can't set permission scheme \"" + permissionSchemeLabel + "\" on CI with label \"" + item.getLabel() + "\" as such a scheme is not yet defined in Actual");
            }
            item.setPermissionSchemeHandleId(permissionSchemeMetaData.getHandleId());
        }
        this.automatedDeploymentService.updateConfigurationItem(item, detailsMap);
    }

    private boolean editable(String attribute, ConfigurationItemPropertyDescriptor[] propertyDescriptors) {
        if (propertyDescriptors == null || propertyDescriptors.length == 0) {
            return false;
        }
        if (attribute.equalsIgnoreCase("label") || attribute.equalsIgnoreCase("description")) {
            return true;
        }
        for (int i = 0; i < propertyDescriptors.length; ++i) {
            ConfigurationItemPropertyDescriptor propertyDescriptor = propertyDescriptors[i];
            if (!propertyDescriptor.getName().equalsIgnoreCase(attribute)) continue;
            return propertyDescriptor.isEditable();
        }
        return false;
    }

    private void processMembershipChanges(ConfigurationItemMetaData item, String[] membershipChangesTokens, ConfigurationItemDescriptor itemDescriptor) {
        for (int i = 0; i < membershipChangesTokens.length; i += 3) {
            String setProperty = membershipChangesTokens[i];
            String memberLabel = membershipChangesTokens[i + 2];
            if (this.isMembershipAddition(membershipChangesTokens[i + 1])) {
                this.processMembershipAddition(item, itemDescriptor, setProperty, memberLabel);
                continue;
            }
            this.processMembershipRemoval(item, itemDescriptor, setProperty, memberLabel);
        }
    }

    private void processMembershipRemoval(ConfigurationItemMetaData item, ConfigurationItemDescriptor itemDescriptor, String setProperty, String memberLabel) {
        ConfigurationItemMetaData member;
        if (!this.hasProperty(itemDescriptor, item.getLabel(), setProperty)) {
            throw new CliException("CI with label \"" + item.getLabel() + "\" does not have property " + setProperty + " so you can't remove a member from it");
        }
        List<Integer> relatedHandleIds = item.getCiRelationsHandleIds().get(itemDescriptor.getPropertyDescriptor(setProperty).getName());
        if (relatedHandleIds == null) {
            relatedHandleIds = new ArrayList<Integer>();
            item.getCiRelationsHandleIds().put(itemDescriptor.getPropertyDescriptor(setProperty).getName(), relatedHandleIds);
        }
        if ((member = this.automatedDeploymentService.findDesignConfigurationItemByLabel(memberLabel)) == null) {
            ConfigurationItemPropertyDescriptor pd = this.findPropertyDescriptor(itemDescriptor, item.getLabel(), setProperty);
            List<String> theMemberList = this.stringToList(memberLabel);
            ArrayList<Integer> idsToRemove = new ArrayList<Integer>();
            for (String memberInList : theMemberList) {
                member = this.automatedDeploymentService.findDesignConfigurationItemByLabel(memberInList);
                if (member == null) {
                    throw new CliException("Cannot modify property " + setProperty + " of CI with label \"" + item.getLabel() + "\" as member CI with label " + memberInList + " does not exist");
                }
                Class clazz = pd.getCollectionMemberClass();
                if (member.getConfigurationItemClassName().equals(clazz.getName())) {
                    throw new CliException("Cannot modify property " + setProperty + " of CI with label \"" + item.getLabel() + "\" as member CI with label " + memberInList + " is of the wrong Type. It is a " + member.getConfigurationItemClassName() + " but should be a " + clazz.getName());
                }
                Integer handleId = member.getHandleId();
                if (this.isMemberOf(relatedHandleIds, handleId)) {
                    idsToRemove.add(handleId);
                    continue;
                }
                this.result = this.result + "Warning: CI with label " + member.getLabel() + " was not a member of property " + setProperty + " in CI " + item.getLabel() + " so it can't be removed from it\n";
            }
            relatedHandleIds.removeAll(idsToRemove);
        } else {
            Integer handleId = member.getHandleId();
            if (this.isMemberOf(relatedHandleIds, handleId)) {
                relatedHandleIds.remove(handleId);
            } else {
                this.result = this.result + "Warning: CI with label " + member.getLabel() + " was not a member of property " + setProperty + " in CI " + item.getLabel() + " so it can't be removed from it\n";
            }
        }
    }

    private List<String> stringToList(String labelListAsString) {
        if ((labelListAsString = labelListAsString.trim()).startsWith("[")) {
            labelListAsString = labelListAsString.substring(1);
        }
        if (labelListAsString.endsWith("]")) {
            labelListAsString = labelListAsString.substring(0, labelListAsString.length() - 1);
        }
        ArrayList<String> theLabelList = new ArrayList<String>();
        StringTokenizer st = new StringTokenizer(labelListAsString, ",");
        while (st.hasMoreTokens()) {
            String item = st.nextToken();
            theLabelList.add(item.trim());
        }
        return theLabelList;
    }

    private void processMembershipAddition(ConfigurationItemMetaData item, ConfigurationItemDescriptor itemDescriptor, String setProperty, String memberLabel) {
        ConfigurationItemMetaData member;
        if (!this.hasProperty(itemDescriptor, item.getLabel(), setProperty)) {
            throw new CliException("CI with label \"" + item.getLabel() + "\" does not have property " + setProperty + " so you can't add a member to it");
        }
        List<Integer> relatedHandleIds = item.getCiRelationsHandleIds().get(itemDescriptor.getPropertyDescriptor(setProperty).getName());
        if (relatedHandleIds == null) {
            relatedHandleIds = new ArrayList<Integer>();
            item.getCiRelationsHandleIds().put(itemDescriptor.getPropertyDescriptor(setProperty).getName(), relatedHandleIds);
        }
        if ((member = this.automatedDeploymentService.findDesignConfigurationItemByLabel(memberLabel)) == null) {
            ConfigurationItemPropertyDescriptor pd = this.findPropertyDescriptor(itemDescriptor, item.getLabel(), setProperty);
            List<String> theMemberList = this.stringToList(memberLabel);
            ArrayList<Integer> idsToAdd = new ArrayList<Integer>();
            for (String memberInList : theMemberList) {
                member = this.automatedDeploymentService.findDesignConfigurationItemByLabel(memberInList);
                if (member == null) {
                    throw new CliException("Cannot modify property " + setProperty + " of CI with label \"" + item.getLabel() + "\" as member CI with label " + memberInList + " does not exist");
                }
                Class clazz = pd.getCollectionMemberClass();
                if (member.getConfigurationItemClassName().equals(clazz.getName())) {
                    throw new CliException("Cannot modify property " + setProperty + " of CI with label \"" + item.getLabel() + "\" as member CI with label " + memberInList + " is of the wrong Type. It is a " + member.getConfigurationItemClassName() + " but should be a " + clazz.getName());
                }
                Integer handleId = member.getHandleId();
                if (this.isMemberOf(relatedHandleIds, handleId)) {
                    this.result = this.result + "Warning: CI with label " + member.getLabel() + " was already a member of property " + setProperty + " in CI " + item.getLabel() + " so it is not added again\n";
                    continue;
                }
                idsToAdd.add(handleId);
            }
            relatedHandleIds.addAll(idsToAdd);
        } else {
            Integer handleId = member.getHandleId();
            if (this.isMemberOf(relatedHandleIds, handleId)) {
                this.result = this.result + "Warning: CI with label " + member.getLabel() + " was already a member of property " + setProperty + " in CI " + item.getLabel() + " so it is not added again\n";
            } else {
                relatedHandleIds.add(handleId);
            }
        }
    }

    private boolean isMemberOf(List<Integer> ids, Integer id) {
        if (ids == null || ids.isEmpty()) {
            return false;
        }
        for (Integer currentId : ids) {
            if (!currentId.equals(id)) continue;
            return true;
        }
        return false;
    }

    private ConfigurationItemPropertyDescriptor findPropertyDescriptor(ConfigurationItemDescriptor itemDescriptor, String label, String setProperty) {
        ConfigurationItemPropertyDescriptor[] propertyDescriptors = itemDescriptor.getPropertyDescriptors();
        for (int i = 0; i < propertyDescriptors.length; ++i) {
            if (!propertyDescriptors[i].getName().equalsIgnoreCase(setProperty)) continue;
            return propertyDescriptors[i];
        }
        return null;
    }

    private boolean hasProperty(ConfigurationItemDescriptor itemDescriptor, String label, String setProperty) {
        ConfigurationItemPropertyDescriptor[] propertyDescriptors = itemDescriptor.getPropertyDescriptors();
        for (int i = 0; i < propertyDescriptors.length; ++i) {
            if (!propertyDescriptors[i].getName().equalsIgnoreCase(setProperty)) continue;
            return true;
        }
        return false;
    }

    private boolean isMembershipAddition(String token) {
        return token != null && token.equals("+=");
    }

    private String[] filterMembershipChanges(String[] tokens, boolean cutMemberShipChangeTokens) {
        int count = this.countMembershipOperators(tokens);
        if (count == 0) {
            if (cutMemberShipChangeTokens) {
                return tokens;
            }
            return new String[0];
        }
        if (cutMemberShipChangeTokens) {
            int i;
            String[] tokensWithoutMembershipChanges = new String[tokens.length - 3 * count];
            int nextOperatorIndex = 0;
            int cnt = 0;
            int tokenIndex = 0;
            while ((nextOperatorIndex = this.nextIndex(tokens, nextOperatorIndex)) != -1) {
                for (i = cnt; i < nextOperatorIndex - 1; ++i) {
                    tokensWithoutMembershipChanges[cnt++] = tokens[tokenIndex++];
                }
                tokenIndex += 3;
                ++nextOperatorIndex;
            }
            nextOperatorIndex = tokens.length;
            for (i = tokenIndex; i < nextOperatorIndex; ++i) {
                tokensWithoutMembershipChanges[cnt++] = tokens[tokenIndex++];
            }
            return tokensWithoutMembershipChanges;
        }
        String[] tokensWithOnlyMembershipChanges = new String[3 * count];
        int newIndex = 0;
        int nextOperatorIndex = 0;
        while ((nextOperatorIndex = this.nextIndex(tokens, nextOperatorIndex)) != -1) {
            tokensWithOnlyMembershipChanges[newIndex++] = tokens[nextOperatorIndex - 1];
            tokensWithOnlyMembershipChanges[newIndex++] = tokens[nextOperatorIndex];
            tokensWithOnlyMembershipChanges[newIndex++] = tokens[nextOperatorIndex + 1];
            ++nextOperatorIndex;
        }
        return tokensWithOnlyMembershipChanges;
    }

    private int nextIndex(String[] tokens, int nextOperatorIndex) {
        for (int i = nextOperatorIndex; i < tokens.length; ++i) {
            if (!this.isMembershipChangeOperator(tokens[i])) continue;
            return i;
        }
        return -1;
    }

    private boolean isMembershipChangeOperator(String token) {
        return token != null && (token.equals("+=") || token.equals("-="));
    }

    private int countMembershipOperators(String[] tokens) {
        int cnt = 0;
        if (tokens == null) {
            return cnt;
        }
        for (int i = 0; i < tokens.length; ++i) {
            if (!this.isMembershipChangeOperator(tokens[i])) continue;
            ++cnt;
        }
        return cnt;
    }

    private void undo(String[] tokens, String savedLine) throws CliException {
        String whatToUndo = tokens[1];
        ConfigurationItemMetaData item = this.automatedDeploymentService.findDesignConfigurationItemByLabel(whatToUndo);
        if (item == null) {
            throw new CliException("Can't undo the change of CI with label " + whatToUndo + " as such a CI does not exist");
        }
        this.automatedDeploymentService.undoConfigurationItem(item);
    }

    private String makeAllCommands() {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < commands.length; ++i) {
            if (i != 0) {
                sb.append("', ");
            }
            sb.append("'");
            sb.append(commands[i]);
        }
        sb.append("'");
        return sb.toString();
    }

    private String makeHelpFor(String command) {
        StringBuilder sb = new StringBuilder();
        if ("help".equalsIgnoreCase(command)) {
            sb.append("Command help\n");
            sb.append("Use 'help' to get help for a command\n");
        } else if ("source".equalsIgnoreCase(command)) {
            sb.append("Command source\n");
            sb.append("Use 'source' to read in a number of commands from a file\n");
            sb.append("EXAMPLES\n");
            sb.append("To read a series of commands from a file use: source /home/deployer/workspace/mycommands.deployit\n");
            sb.append("Note that file names containing spaces need to be quoted\n");
        } else if ("create".equalsIgnoreCase(command)) {
            sb.append("Command create\n");
            sb.append("Use 'create' to add a CI, or to add a relation\n");
            sb.append("EXAMPLES\n");
            sb.append("To add a (hypethetical) JeeAppServer CI, use: create JeeAppServer label=\"Test server\" name=server1 soapconnectoraddress=localhost:8881 bootstrapaddress=*:2810\n");
            sb.append("Note how properties are set and note that property values containing spaces need to be quoted\n");
            sb.append("To list all properties you can set, use 'describe <CI type>', so to get all properties for a JeeAppServer, use: describe JeeAppServer\n");
            sb.append("To fill an attribute with a list value, use a list within '[' and ']' and use list items enclosed in '[' and ']' characters as well. Separate list items with a ','\n");
            sb.append("For example, to set the network ports of a JeeAppServer use:\n");
            sb.append("create JeeAppServer ... ports=\"[[name=BOOTSTRAP_ADDRESS host=192.168.1.110 port=11], [name=WC_adminhost, host=192.168.1.120 port=22], [name=SOAP_CONNECTOR_ADDRESS host=192.168.1.130 port=33]]\"");
            sb.append("so note the additional '[' to open the list and the closing ']' to end it.");
            sb.append("Similarly, you set any list of system property on a deployment using:\n");
            sb.append("create Deployment ... systemproperties=\"[[name=property_1_name value=property_1_value], [name=property_2_name value=property_2_value], [name=property_3_name value=property_3_value]]\"");
            sb.append("Finally, you set any list of access control entries on a security domain using:\n");
            sb.append("create PermissionScheme ... accesscontrolentries =\"[[groupname=groupname1 canRedeploy=true canModify=true canView=true], [groupname=groupname2 canRedeploy=true canModify=true], [groupname=groupname3 canView=true]]\"");
            sb.append("Relations");
            sb.append("Properties that are relations to other CIs are set in the same way as other properties, using the label(s) of the related CI(s) as the value.\n");
            sb.append("For instance, to set the 'host' property of a (hypothetical) JeeAppServer CI, use:\n");
            sb.append("create JeeAppServer ... host=\"appServer host 1\"\n");
            sb.append("where \"appServer host 1\" is the label of an existing Host CI.\n");
            sb.append("Many-valued relations are specified using the same list syntax as for other properties. To specify the members of an Environment, for instance, use::\n");
            sb.append("create Environment members=\"[server 1,server 2,host 1, host 2]\"\n");
            sb.append("where \"server 1\" etc. are the labels existing CIs.\n");
            sb.append("Note the position of the '\"' and '[' and ']' characters.\n");
        } else if ("modify".equalsIgnoreCase(command)) {
            sb.append("Command modify\n");
            sb.append("Use 'modify' to modify/edit properties of a CI.\n");
            sb.append("EXAMPLES\n");
            sb.append("To modify a (hypothetical) JeeAppServer CI, use: modify \"Test Server\" label=\"A Renamed Test server\" name=server2 soapconnectoraddress=localhost:8884 bootstrapaddress=*:3810\n");
            sb.append("Note how properties are set and note that property values containing spaces need to be quoted\n");
            sb.append("You can add and remove one or multiple members from a many-valued property using the following commands:\n");
            sb.append("modify dev-environment members += \"new server\"\n");
            sb.append("modify dev-environment members += \"[new server,new host]\"\n");
            sb.append("modify dev-environment members -= existingServer\n");
            sb.append("modify dev-environment members -= [existingServer,existingHost]\n");
            sb.append("Note how properties are set and note that property values containing spaces need to be quoted\n");
            sb.append("To list all properties you can set, use 'describe <CI type>', so to get all properties for a JeeAppServer, use: describe JeeAppServer\n");
        } else if ("undo".equalsIgnoreCase(command)) {
            sb.append("Command undo\n");
            sb.append("Use 'undo' to undo the changes made to a CI.\n");
            sb.append("EXAMPLES\n");
            sb.append("To undo modifications to a (hypothetical) JeeAppServer CI, use: undo \"Test Server\"\n");
        } else if ("delete".equalsIgnoreCase(command)) {
            sb.append("Command delete\n");
            sb.append("Use 'delete' to delete a CI, or to delete a relation. Use labels to indicate which CI to delete\n");
            sb.append("EXAMPLES\n");
            sb.append("To delete a (hypothetical) JeeAppServer CI, use: delete \"Test server\"\n");
            sb.append("Note that label values containing spaces need to be quoted\n");
        } else if ("describe".equalsIgnoreCase(command)) {
            sb.append("Command describe\n");
            sb.append("Use 'describe' to get an overview of all CIs, or get an overview of all properties of a particular CI type\n");
            sb.append("EXAMPLES\n");
            sb.append("To list all CI types, use: describe\n");
            sb.append("To describe all CI types, use: describe *\n");
            sb.append("To list all properties of the (hypothetical) JeeAppServer CI type, use: describe JeeAppServer\n");
        } else if ("check".equalsIgnoreCase(command)) {
            sb.append("Command check\n");
            sb.append("Use 'check' to see if the system knows about the existence of a particular CI. Indicate the CI by using its label\n");
            sb.append("EXAMPLES\n");
            sb.append("To see if there is an environment known as \"Test environment\", use: check \"Test environment\"\n");
            sb.append("Note that label values containing spaces need to be quoted\n");
            sb.append("To see if there is (hypothetical) JeeAppServer CI known as \"Test server\", use: check \"Test server\"\n");
        } else if ("deployit".equalsIgnoreCase(command)) {
            sb.append("Command deployit\n");
            sb.append("Use 'deployit' to instruct the system to execute all steps necessary to turn the design into reality\n");
        } else if ("execute".equalsIgnoreCase(command)) {
            sb.append("Command execute\n");
            sb.append("Use 'execute' to instruct the system to execute all steps necessary to turn the design into reality\n");
        } else if ("deployit_nosteps".equalsIgnoreCase(command)) {
            sb.append("Command deployit_nosteps\n");
            sb.append("Use 'deployit_nosteps' to tell the system that CIs that are currently in Design are actually reality\n");
            sb.append("This is useful for importing CIs and the actual relations between them in the system's CMDB\n");
            sb.append("EXAMPLES\n");
            sb.append("Suppose we have a (hypothetical) JeeAppServer running in the real world. To make the system aware of this CI, we use two commands:\n");
            sb.append("   create JeeAppServer label=\"Test server\" name=server1\n");
            sb.append("   deployit_nosteps\n");
            sb.append("Note that label values containing spaces need to be quoted\n");
            sb.append("You can add any number of CIs and relations between them before executing a single 'deployit_nosteps'\n");
        } else if ("skip".equalsIgnoreCase(command)) {
            sb.append("Command skip\n");
            sb.append("Use 'skip' to tell the system that CIs that are currently in Design are actually reality\n");
            sb.append("This is useful for importing CIs and the actual relations between them in the system's CMDB\n");
            sb.append("EXAMPLES\n");
            sb.append("Suppose we have a (hypothetical) JeeAppServer running in the real world. To make the system aware of this CI, we use two commands:\n");
            sb.append("   create JeeAppServer label=\"Test server\" name=server1\n");
            sb.append("   skip\n");
            sb.append("Note that label values containing spaces need to be quoted\n");
            sb.append("You can add any number of CIs and relations between them before executing a single 'skip'\n");
        } else if ("show".equalsIgnoreCase(command)) {
            sb.append("Command show\n");
            sb.append("Use 'show' to inspect the actual values of all properties of a particular CI, or to simply list all labels of CIs known to the system\n");
            sb.append("EXAMPLES\n");
            sb.append("To list all CIs in the system's CMDB, just use: 'show'\n");
            sb.append("Note that label values containing spaces need to be quoted\n");
            sb.append("To list all properties of a (hypothetical) JeeAppServer CI with label \"Test server\", use: show \"Test server\"\n");
        } else if ("show_type".equalsIgnoreCase(command)) {
            sb.append("Command show_type\n");
            sb.append("Use 'show_type' to inspect the actual values of all properties of a particular CI or a particular type\n");
            sb.append("EXAMPLES\n");
            sb.append("To list all CIs of type 'Host' in the system's CMDB, use: 'show_type Host'\n");
            sb.append("To list all CIs of (hypothetical) type 'JeeAppServer' in the system's CMDB, use: 'show_type JeeAppServer'\n");
        } else if ("show_name".equalsIgnoreCase(command)) {
            sb.append("Command show_name\n");
            sb.append("Use 'show_name' to inspect the actual values of all properties of a particular CI of which the label matches the pattern argument\n");
            sb.append("'show_label' uses simplified SQL regular expressions for matching\n");
            sb.append("use a '%' to match any number of label characters. A '%' can only be at the start, at the end of your pattern, or both\n");
            sb.append("EXAMPLES\n");
            sb.append("To list all CIs with labels starting with 'AppServer' in the system's CMDB, use: 'show_name AppServer%'\n");
            sb.append("To list all CIs with labels ending with 'server' in the system's CMDB, use: 'show_name %server'\n");
            sb.append("To list all CIs with labels containing 'test' in the system's CMDB, use: 'show_name %test%'\n");
        } else if ("undo".equalsIgnoreCase(command)) {
            sb.append("Command undo\n");
            sb.append("Use 'undo' to undo an earlier change. One may, for example, use 'undo' after an erroneous modification\n");
            sb.append("EXAMPLES\n");
            sb.append("To undo a change on a (hypothetical) JeeAppServer CI, you e.g. first use: modify \"Test server\" name=wrongname\n");
            sb.append("Then undo that change using: undo \"Test server\"\n");
            sb.append("The CI labelled \"Test server\" will now have the name it had before changing it to 'wrongname'\n");
            sb.append("Note that label values containing spaces need to be quoted\n");
        } else if ("export".equalsIgnoreCase(command)) {
            sb.append("Command export\n");
            sb.append("Use 'export' to create CLI scripts based on the CMDB. \n");
            sb.append("EXAMPLES\n");
            sb.append("To export to the console, use 'export'\n");
            sb.append("To export to a file, use 'export /tmp/myexportedfile.txt'\n");
        } else if ("import".equalsIgnoreCase(command)) {
            sb.append("Command import\n");
            sb.append("Use 'import' to create Application Package and containing Deployable artifact CIs from a source directory.\n");
            sb.append("Note that backslashes in the location need to be escaped by prefixing them with ''\n");
            sb.append("EXAMPLES\n");
            sb.append("import location=\"C:\\package\\PetClinic\\1.0\"\n");
            sb.append("import location=\"/var/package/PetClinic/1.0\"\n");
        } else if ("exit".equalsIgnoreCase(command)) {
            sb.append("Command exit\n");
            sb.append("Use 'exit' to stop the command line interpreter\n");
        } else if ("shutdown".equalsIgnoreCase(command)) {
            sb.append("Command shutdown\n");
            sb.append("Use 'shutdown' to shutdown the server. \n");
        } else if ("changeplan".equalsIgnoreCase(command)) {
            sb.append("Command changeplan\n");
            sb.append("Use 'changeplan' to inspect the changeplan. Information is available for its 'state', its 'steps', and for its 'changes' \n");
            sb.append("EXAMPLES\n");
            sb.append("To list all changes corresponding to the current changeplan, use 'changeplan changes'\n");
            sb.append("To list all steps corresponding to the current changeplan, use 'changeplan steps'\n");
            sb.append("To list the state of the current changeplan including a resolution error, if any, use 'changeplan state'\n");
        } else if ("cleanrepository".equalsIgnoreCase(command)) {
            sb.append("Command cleanrepository\n");
            sb.append("Use 'cleanrepository' to clear up the database with old execution information\n");
            sb.append("EXAMPLES\n");
            sb.append("cleanrepository 26/01/2009\n");
            sb.append("Removes all the steps corresponding to changeplans which were executed before 26/01/2009");
        } else if ("start".equalsIgnoreCase(command) || "stop".equalsIgnoreCase(command) || "forciblystop".equalsIgnoreCase(command)) {
            sb.append("Command start/stop/forciblystop\n");
            sb.append("Use 'start/stop/forciblystop' to start/stop/forciblystop deployments i.e. corresponding targets of the deployments which can be application servers, clusters etc\n");
            sb.append("EXAMPLES\n");
            sb.append("start deployment label=\"PetClinic on Test server (#1)\"\n");
            sb.append("stop deployment label=\"PetClinic on Staging server (#2)\"\n");
            sb.append("forciblystop deployment label=\"PetClinic on Production Environment\"\n");
        } else if ("clear".equalsIgnoreCase(command)) {
            sb.append("Command clear\n");
            sb.append("Use 'clear' to clear the changeplan. Removes any changes to CI's from the changeplan.\n");
        } else if ("set".equalsIgnoreCase(command)) {
            sb.append("Command set\n");
            sb.append("Use 'set' to define a list of name/value pairs that are used when resolving templates in the CLI.\n");
            sb.append("This is useful when template CLI scripts are used.\n");
            sb.append("EXAMPLES\n");
            sb.append("To define variables 'target.env', 'version' and 'application' use:\n");
            sb.append("set target.env=test version=1.0 application=PetClinic\n");
            sb.append("To use these values, just enter CLI lines like: ");
            sb.append("modify ${target.env} members += \"${application}-${version}\"\n");
            sb.append("Please note:\n");
            sb.append("- values defined with 'set' are in CLI memory only and are not persisted, nor exported\n");
            sb.append("- values defined with 'set' are applied in entered CLI command lines only, that is, they have CLI client scope\n");
            sb.append("- any 'set' command overwrites a previous 'set' command's name/value pairs");
            sb.append("SEE ALSO 'unset' \n");
        } else if ("unset".equalsIgnoreCase(command)) {
            sb.append("Command unset\n");
            sb.append("Use 'unset' to clear the list of name/value pairs that are used when resolving templates in the CLI.\n");
            sb.append("SEE ALSO 'set' \n");
        } else {
            return "I do not understand 'help " + command + "' as the command is not " + this.makeAllCommands();
        }
        return sb.toString();
    }

    private void show_name(String[] tokens, String savedLine) {
        StringBuilder sb = new StringBuilder();
        if (tokens.length == 2) {
            sb.append("All known CIs with labels matching: " + tokens[1] + ":\n");
            Collection<ConfigurationItemMetaData> all = this.automatedDeploymentService.getActuals();
            for (ConfigurationItemMetaData meta : all) {
                String fullClassName = meta.getConfigurationItemClassName();
                String type = fullClassName.substring(fullClassName.lastIndexOf(".") + 1, fullClassName.length());
                if (!this.matches(meta.getLabel(), tokens[1])) continue;
                sb.append(meta.getLabel() + " (" + type + ")\n");
            }
            this.result = sb.toString();
            return;
        }
    }

    private boolean matches(String s, String pattern) {
        if (pattern.startsWith("%")) {
            if (pattern.endsWith("%")) {
                return s.indexOf(pattern.substring(1, pattern.length() - 1)) != -1;
            }
            return s.endsWith(pattern.substring(1, pattern.length()));
        }
        if (pattern.endsWith("%")) {
            return s.startsWith(pattern.substring(0, pattern.length() - 1));
        }
        return false;
    }

    private void show_type(String[] tokens, String savedLine) {
        StringBuilder sb = new StringBuilder();
        if (tokens.length == 2) {
            sb.append("All known CIs of type " + tokens[1] + ":\n");
            Collection<ConfigurationItemMetaData> all = this.automatedDeploymentService.getActuals();
            for (ConfigurationItemMetaData meta : all) {
                String fullClassName = meta.getConfigurationItemClassName();
                String type = fullClassName.substring(fullClassName.lastIndexOf(".") + 1, fullClassName.length());
                if (!type.equalsIgnoreCase(tokens[1])) continue;
                sb.append(meta.getLabel() + "\n");
            }
            this.result = sb.toString();
            return;
        }
    }

    private void export(String[] tokens, String savedLine) {
        StringBuilder sb = new StringBuilder();
        if (tokens.length == 1 || tokens.length == 2) {
            sb.append("All known CIs:");
            Collection<ConfigurationItemMetaData> all = this.automatedDeploymentService.getActuals();
            boolean exportedAtLeastOnePermissionScheme = false;
            for (ConfigurationItemMetaData meta : all) {
                if (!meta.getConfigurationItemClassName().equals(PermissionScheme.class.getName())) continue;
                if (!this.exportSingleCI(sb, meta)) {
                    return;
                }
                exportedAtLeastOnePermissionScheme = true;
            }
            if (exportedAtLeastOnePermissionScheme) {
                sb.append("\ndeployit");
            }
            for (ConfigurationItemMetaData meta : all) {
                if (meta.getConfigurationItemClassName().equals(PermissionScheme.class.getName()) || this.exportSingleCI(sb, meta)) continue;
                return;
            }
            if (tokens.length == 2) {
                File exportFile = new File(tokens[1]);
                try {
                    FileUtils.writeStringToFile((File)exportFile, (String)sb.toString());
                    this.result = "Exported to file " + tokens[1];
                }
                catch (IOException e) {
                    this.result = "Export to file failed because; " + e.getMessage();
                }
            } else {
                this.result = sb.toString();
            }
            return;
        }
    }

    private boolean exportSingleCI(StringBuilder sb, ConfigurationItemMetaData meta) {
        ConfigurationItemMetaData permissionSchemeItem;
        String label = meta.getLabel();
        ConfigurationItemMetaData item = this.automatedDeploymentService.findDesignConfigurationItemByLabel(label);
        if (item == null) {
            sb.append("Can't show properties of a CI with label " + label + " as such a CI does not exist. Exiting...");
            this.result = sb.toString();
            return false;
        }
        Map<String, Object> detailsMap = this.automatedDeploymentService.getConfigurationItem(item.getRevisionId());
        Object details = this.convertConfigurationItemDetailsMapToObject(item, detailsMap);
        String basicPropertiesAsString = PropertyListConverter.convertObjectToString(details);
        String fullClassName = meta.getConfigurationItemClassName();
        String type = fullClassName.substring(fullClassName.lastIndexOf(".") + 1, fullClassName.length());
        sb.append("\ncreate " + type + " ");
        String permissionSchemeLabel = null;
        if (item.getPermissionSchemeHandleId() != 0 && (permissionSchemeItem = this.automatedDeploymentService.findActualConfigurationItemByHandleId(item.getPermissionSchemeHandleId())) != null) {
            permissionSchemeLabel = permissionSchemeItem.getLabel();
        }
        Map<String, List<Integer>> ciRelationsHandleIds = item.getCiRelationsHandleIds();
        ConfigurationItemDescriptor configurationItemDescriptor = this.descriptorRepository.getDescriptor(item.getConfigurationItemClassName());
        this.showSingleCI(configurationItemDescriptor, sb, label, item.getDescription(), detailsMap, basicPropertiesAsString, permissionSchemeLabel, ciRelationsHandleIds);
        return true;
    }

    private Object convertConfigurationItemDetailsMapToObject(ConfigurationItemMetaData metaData, Map<String, Object> detailsMap) {
        ConfigurationItemDescriptor configurationItemDescriptor = this.descriptorRepository.getDescriptor(metaData.getConfigurationItemClassName());
        return ConfigurationItemDetailsMapDeserializer.toConfigurationItemDetails(configurationItemDescriptor, detailsMap);
    }

    private void changeplan(String[] tokens, String savedLine) {
        StringBuilder sb = new StringBuilder();
        if (tokens.length == 2) {
            if (tokens[1].equalsIgnoreCase("changes")) {
                ChangePlanView planView = this.automatedDeploymentService.findCurrentChangePlan();
                if (planView != null) {
                    List<ChangeView> changesViews = planView.getChanges();
                    for (ChangeView changeView : changesViews) {
                        sb.append(changeView.getDescription());
                        sb.append("\n");
                    }
                } else {
                    sb.append("There are no changes\n");
                }
                this.result = sb.toString();
                return;
            }
            if (tokens[1].equalsIgnoreCase("steps")) {
                ChangePlanView planView = this.automatedDeploymentService.findCurrentChangePlan();
                if (planView != null) {
                    List<StepView> stepViews = planView.getSteps();
                    for (StepView stepView : stepViews) {
                        sb.append(stepView.getDescription());
                        sb.append(" | ");
                        sb.append(stepView.getState());
                        sb.append(" | ");
                        sb.append(stepView.getLog());
                        sb.append("\n");
                    }
                } else {
                    sb.append("There are no steps\n");
                }
                this.result = sb.toString();
                return;
            }
            if (tokens[1].equalsIgnoreCase("state")) {
                ChangePlanView planView = this.automatedDeploymentService.findCurrentChangePlan();
                if (planView != null) {
                    sb.append(planView.getState());
                    sb.append(" | ");
                    sb.append(planView.getResolutionError());
                } else {
                    sb.append("No changeplan exists\n");
                }
                this.result = sb.toString();
                return;
            }
            sb.append("I do not understand " + savedLine + " as the 'changeplan' command's argument is not one of 'steps', 'changes', or 'state'");
            return;
        }
        sb.append("I do not understand " + savedLine + " as the 'changeplan' command is not given an additional argument (one of 'steps', 'changes' or 'state')");
    }

    private void set(String[] tokens, String savedLine) throws CliException {
        if (tokens.length == 1) {
            if (this.attributes.size() == 0) {
                System.out.println("No attributes set!");
            } else {
                for (Map.Entry<String, String> attributePair : this.attributes.entrySet()) {
                    String attributeName = attributePair.getKey();
                    String attributeValue = attributePair.getValue();
                    System.out.println(attributeName + "=" + attributeValue);
                }
            }
        } else {
            try {
                this.attributes = PropertyListConverter.makeAttributes(1, tokens);
                this.resolver = new TemplateResolver(this.attributes);
                this.result = "name/value pair(s) defined.";
            }
            catch (ConversionException e) {
                throw new CliException(e.getMessage());
            }
        }
    }

    private void unset(String[] tokens, String savedLine) throws CliException {
        this.attributes = new HashMap<String, String>();
        this.resolver = new TemplateResolver(this.attributes);
        this.result = "All 'set' values were cleared.";
    }

    private void show(String[] tokens, String savedLine) {
        StringBuilder sb = new StringBuilder();
        if (tokens.length == 1) {
            sb.append("All known CIs:\n");
            Collection<ConfigurationItemMetaData> all = this.getActualAndDesignConfigurationItems();
            for (ConfigurationItemMetaData meta : all) {
                String fullClassName = meta.getConfigurationItemClassName();
                String type = fullClassName.substring(fullClassName.lastIndexOf(".") + 1, fullClassName.length());
                sb.append(meta.getLabel() + " (" + type + ")\n");
            }
            this.result = sb.toString();
            return;
        }
        ConfigurationItemMetaData itemMetaData = this.automatedDeploymentService.findDesignConfigurationItemByLabel(tokens[1]);
        if (itemMetaData == null) {
            sb.append("Can't show properties of a CI with label " + tokens[1] + " as such a CI does not exist");
            this.result = sb.toString();
            return;
        }
        String label = itemMetaData.getLabel();
        String description = itemMetaData.getDescription();
        Map<String, Object> detailsMap = this.automatedDeploymentService.getConfigurationItem(itemMetaData.getRevisionId());
        Object details = this.convertConfigurationItemDetailsMapToObject(itemMetaData, detailsMap);
        String basicPropertiesAsString = PropertyListConverter.convertObjectToString(details);
        sb.append("The CI with label " + label + " contains the following properties: \n");
        int permissionSchemeHandleId = itemMetaData.getPermissionSchemeHandleId();
        String permissionSchemeLabel = null;
        if (permissionSchemeHandleId != 0) {
            ConfigurationItemMetaData permissionSchemeMetaData = this.automatedDeploymentService.findActualConfigurationItemByHandleId(permissionSchemeHandleId);
            permissionSchemeLabel = permissionSchemeMetaData.getLabel();
        }
        Map<String, List<Integer>> ciRelationsHandleIds = itemMetaData.getCiRelationsHandleIds();
        ConfigurationItemDescriptor descriptor = this.descriptorRepository.getDescriptor(itemMetaData.getConfigurationItemClassName());
        this.showSingleCI(descriptor, sb, label, description, detailsMap, basicPropertiesAsString, permissionSchemeLabel, ciRelationsHandleIds);
        this.result = sb.toString();
    }

    private Collection<ConfigurationItemMetaData> getActualAndDesignConfigurationItems() {
        ArrayList<ConfigurationItemMetaData> toReturn = new ArrayList();
        Collection<ConfigurationItemMetaData> actual = this.automatedDeploymentService.getActuals();
        ChangePlanView currentChangePlan = this.automatedDeploymentService.findCurrentChangePlan();
        if (currentChangePlan != null) {
            List<ChangeView> changes = currentChangePlan.getChanges();
            Iterator<Serializable> i$ = actual.iterator();
            while (i$.hasNext()) {
                ConfigurationItemMetaData configurationItemMetaData;
                ConfigurationItemMetaData cimdToAdd = configurationItemMetaData = i$.next();
                for (ChangeView changeView : changes) {
                    ConfigurationItemMetaData newMetaData = changeView.getNewMetaData();
                    ConfigurationItemMetaData oldMetaData = changeView.getOldMetaData();
                    if (oldMetaData == null || newMetaData == null || configurationItemMetaData.getHandleId() != newMetaData.getHandleId()) continue;
                    cimdToAdd = newMetaData;
                }
                toReturn.add(cimdToAdd);
            }
            for (ChangeView changeView : changes) {
                ConfigurationItemMetaData newMetaData = changeView.getNewMetaData();
                ConfigurationItemMetaData oldMetaData = changeView.getOldMetaData();
                if (oldMetaData != null || newMetaData == null) continue;
                toReturn.add(newMetaData);
            }
        } else {
            toReturn = actual;
        }
        return toReturn;
    }

    private void showSingleCI(ConfigurationItemDescriptor descriptor, StringBuilder sb, String label, String description, Map<String, Object> map, String basicProperties, String permissionSchemeLabel, Map<String, List<Integer>> ciRelationsHandleIds) {
        String desc = "";
        if (description != null) {
            desc = description;
        }
        sb.append("label=\"" + label + "\"" + " description=\"" + desc + "\"" + " ");
        if (permissionSchemeLabel != null) {
            sb.append("permissionscheme=\"" + permissionSchemeLabel + "\" ");
        }
        if (ciRelationsHandleIds != null) {
            Collection<ConfigurationItemMetaData> allCiMetaData = this.getActualAndDesignConfigurationItems();
            for (String propertyName : ciRelationsHandleIds.keySet()) {
                List<Integer> handlesOfRelatedProperty = ciRelationsHandleIds.get(propertyName);
                if (handlesOfRelatedProperty != null) {
                    if (this.relationPropertyIsSet(descriptor, map, propertyName)) {
                        sb.append(propertyName + "=\"[");
                        Iterator<Integer> it = handlesOfRelatedProperty.iterator();
                        while (it.hasNext()) {
                            Integer handleId = it.next();
                            ConfigurationItemMetaData relatedCiMetaData = this.lookupCiMetaDataByHandle(allCiMetaData, handleId);
                            if (relatedCiMetaData == null) continue;
                            sb.append(relatedCiMetaData.getLabel());
                            if (!it.hasNext()) continue;
                            sb.append(", ");
                        }
                        sb.append("]\" ");
                        continue;
                    }
                    if (handlesOfRelatedProperty.size() <= 0) continue;
                    sb.append(propertyName + "=\"");
                    ConfigurationItemMetaData relatedCiMetaData = this.lookupCiMetaDataByHandle(allCiMetaData, handlesOfRelatedProperty.get(0));
                    if (relatedCiMetaData != null) {
                        sb.append(relatedCiMetaData.getLabel());
                    }
                    sb.append("\" ");
                    continue;
                }
                sb.append("=[] ");
            }
        }
        sb.append(basicProperties);
    }

    private boolean relationPropertyIsSet(ConfigurationItemDescriptor descriptor, Map<String, Object> details, String propertyName) {
        ConfigurationItemPropertyDescriptor propertyDescriptor = descriptor.getPropertyDescriptor(propertyName);
        return propertyDescriptor.getType() == ConfigurationItemPropertyType.SET_OF_CIS;
    }

    private ConfigurationItemMetaData lookupCiMetaDataByHandle(Collection<ConfigurationItemMetaData> allCiMetaData, Integer handleId) {
        for (ConfigurationItemMetaData metaData : allCiMetaData) {
            if (metaData.getHandleId() != handleId.intValue()) continue;
            return metaData;
        }
        return null;
    }

    private void describe(String[] tokens, String savedLine) throws CliException {
        if (tokens.length == 1) {
            Collection<ConfigurationItemDescriptor> descriptors = this.automatedDeploymentService.getConfigurationItemDescriptors();
            throw new CliException("The 'describe' command needs a type. This type should be one of: " + this.makeAllSimpleNames(descriptors));
        }
        String type = tokens[1];
        ArrayList<ConfigurationItemDescriptor> descriptors = new ArrayList<ConfigurationItemDescriptor>();
        descriptors.addAll(this.automatedDeploymentService.getConfigurationItemDescriptors());
        Collections.sort(descriptors);
        boolean found = false;
        for (ConfigurationItemDescriptor descriptor : descriptors) {
            if (type.equals("*")) {
                this.printAttributesFor(descriptor);
                found = true;
                continue;
            }
            if (!descriptor.getSimpleName().equalsIgnoreCase(type)) continue;
            this.printAttributesFor(descriptor);
            found = true;
        }
        if (!found) {
            throw new CliException("I do not understand " + savedLine + " as the type provided " + type + " is unknown. I do understand: " + this.makeAllSimpleNames(descriptors));
        }
    }

    private void printAttributesFor(ConfigurationItemDescriptor descriptor) throws CliException {
        System.out.println("Description of " + descriptor.getSimpleName());
        System.out.println("|| Description | " + descriptor.getDescription() + " |");
        System.out.println();
        System.out.println("Properties:");
        System.out.println("|| *=mandatory || Name || Type || Description ||");
        ArrayList<String> propertyList = new ArrayList<String>();
        propertyList.add("| * | label | String | The label of this CI as used only by DeployIT. |");
        propertyList.add("| * | description | String | The description of this CI as used only by DeployIT. |");
        propertyList.add("|  | permissionscheme | String | The label of the applied PermissionScheme. |");
        for (ConfigurationItemPropertyDescriptor each : descriptor.getPropertyDescriptors()) {
            String isRequired = each.isRequired() ? "*" : "";
            String description = each.getDescription();
            ConfigurationItemPropertyType type = each.getType();
            propertyList.add("| " + isRequired + " | " + each.getName() + " | " + type + " | " + description + " |");
        }
        Collections.sort(propertyList);
        Collections.reverse(propertyList);
        for (String property : propertyList) {
            System.out.println(property);
        }
        System.out.println("");
    }

    private String makeAllSimpleNames(Collection<ConfigurationItemDescriptor> descriptors) {
        StringBuilder sb = new StringBuilder();
        for (ConfigurationItemDescriptor descriptor : descriptors) {
            sb.append(descriptor.getSimpleName());
            sb.append(", ");
        }
        String all = sb.toString();
        return all.substring(0, all.length() - 2);
    }

    private String addCI(String[] tokens, String savedLine) throws CliException {
        String type = tokens[1];
        Collection<ConfigurationItemDescriptor> descriptors = this.automatedDeploymentService.getConfigurationItemDescriptors();
        for (ConfigurationItemDescriptor descriptor : descriptors) {
            if (!type.equalsIgnoreCase(descriptor.getSimpleName())) continue;
            if (type.equalsIgnoreCase("DeploymentPackage")) {
                return this.addDeploymentPackage(tokens, savedLine, descriptor);
            }
            return this.addConfigurationItem(tokens, savedLine, descriptor, descriptors);
        }
        throw new CliException("don't understand: " + savedLine + " as type is unequal to " + this.makeAllSimpleNames(descriptors) + ". It is: " + type);
    }

    private String addConfigurationItem(String[] tokens, String savedLine, ConfigurationItemDescriptor descriptor, Collection<ConfigurationItemDescriptor> descriptors) throws CliException {
        Object detailsObject;
        String permissionSchemeLabel;
        Map<String, String> attributes;
        try {
            attributes = PropertyListConverter.makeAttributes(2, tokens);
        }
        catch (ConversionException e) {
            throw new CliException(e.getMessage());
        }
        this.checkMandatoryProperties(attributes, descriptor);
        ConfigurationItemMetaData itemMetaData = new ConfigurationItemMetaData();
        itemMetaData.setConfigurationItemClassName(descriptor.getType());
        String label = attributes.get("label");
        itemMetaData.setLabel(label);
        String description = attributes.get("description");
        if (StringUtils.isEmpty((String)description) && descriptor.getDefaultDescription() != null) {
            description = descriptor.getDefaultDescription();
        }
        if (!StringUtils.isEmpty((String)description)) {
            itemMetaData.setDescription(description);
        }
        if (StringUtils.isEmpty((String)(permissionSchemeLabel = attributes.get("permissionscheme"))) && descriptor.getDefaultPermissionSchemeLabel() != null) {
            permissionSchemeLabel = descriptor.getDefaultPermissionSchemeLabel();
        }
        if (!StringUtils.isEmpty((String)permissionSchemeLabel)) {
            ConfigurationItemMetaData permissionSchemeMetaData = this.automatedDeploymentService.findActualConfigurationItemByLabel(permissionSchemeLabel);
            if (permissionSchemeMetaData == null) {
                throw new CliException("Can't set permission scheme \"" + permissionSchemeLabel + "\" on CI with label \"" + itemMetaData.getLabel() + "\" as such a scheme is not yet defined in Actual");
            }
            itemMetaData.setPermissionSchemeHandleId(permissionSchemeMetaData.getHandleId());
        }
        try {
            detailsObject = PropertyListConverter.convertAttributesToObject(attributes, descriptor);
        }
        catch (ConversionException e) {
            throw new CliException(e.getMessage());
        }
        try {
            this.processRelations(itemMetaData, attributes, descriptor);
        }
        catch (CliException ce) {
            throw new CliException("don't understand: " + savedLine + " as I " + ce.getMessage());
        }
        if (descriptor.getTypeClass().equals(PermissionScheme.class)) {
            PermissionScheme permissionScheme = (PermissionScheme)detailsObject;
            Set types = permissionScheme.getAllowedCiTypes();
            permissionScheme.setAllowedCiTypes(this.filterKnownTypes(types, descriptors));
        }
        this.automatedDeploymentService.addConfigurationItem(itemMetaData, detailsObject);
        return label;
    }

    private void processRelations(ConfigurationItemMetaData itemMetaData, Map<String, String> attributes, ConfigurationItemDescriptor descriptor) {
        ConfigurationItemPropertyDescriptor[] propertyDescriptors = descriptor.getPropertyDescriptors();
        if (propertyDescriptors != null && propertyDescriptors.length > 0) {
            for (int i = 0; i < propertyDescriptors.length; ++i) {
                String labelListAsString;
                String propertyName;
                if (propertyDescriptors[i].getType() == ConfigurationItemPropertyType.CI) {
                    propertyName = propertyDescriptors[i].getName();
                    String label = attributes.get(propertyName.toLowerCase());
                    if (label == null) continue;
                    if (itemMetaData.getCiRelationsHandleIds() != null) {
                        itemMetaData.getCiRelationsHandleIds().remove(propertyName);
                    }
                    this.addTargetHandleToRelation(itemMetaData, propertyName, label);
                    continue;
                }
                if (propertyDescriptors[i].getType() != ConfigurationItemPropertyType.SET_OF_CIS || (labelListAsString = attributes.get((propertyName = propertyDescriptors[i].getName()).toLowerCase())) == null) continue;
                if (itemMetaData.getCiRelationsHandleIds() != null) {
                    itemMetaData.getCiRelationsHandleIds().remove(propertyName);
                }
                if ((labelListAsString = labelListAsString.trim()).startsWith("[")) {
                    labelListAsString = labelListAsString.substring(1);
                }
                if (labelListAsString.endsWith("]")) {
                    labelListAsString = labelListAsString.substring(0, labelListAsString.length() - 1);
                }
                ArrayList<String> theLabelList = new ArrayList<String>();
                StringTokenizer st = new StringTokenizer(labelListAsString, ",");
                while (st.hasMoreTokens()) {
                    String item = st.nextToken();
                    theLabelList.add(item.trim());
                }
                for (String label : theLabelList) {
                    this.addTargetHandleToRelation(itemMetaData, propertyName, label);
                }
            }
        }
    }

    private void addTargetHandleToRelation(ConfigurationItemMetaData itemMetaData, String propertyName, String label) {
        ConfigurationItemMetaData relationTarget;
        List<Integer> relatedHandlesThisPropertyPointsAt;
        if (label == null) {
            return;
        }
        Map<String, List<Integer>> relationsMap = itemMetaData.getCiRelationsHandleIds();
        if (relationsMap == null) {
            relationsMap = new HashMap<String, List<Integer>>();
        }
        if ((relatedHandlesThisPropertyPointsAt = relationsMap.get(propertyName)) == null) {
            relatedHandlesThisPropertyPointsAt = new ArrayList<Integer>();
        }
        if ((relationTarget = this.automatedDeploymentService.findDesignConfigurationItemByLabel(label)) == null) {
            throw new CliException("can't find a CI with label " + label);
        }
        relatedHandlesThisPropertyPointsAt.add(new Integer(relationTarget.getHandleId()));
        relationsMap.put(propertyName, relatedHandlesThisPropertyPointsAt);
        itemMetaData.setCiRelationsHandleIds(relationsMap);
    }

    private Set<String> filterKnownTypes(Set<String> types, Collection<ConfigurationItemDescriptor> descriptors) {
        HashSet<String> validTypes = new HashSet<String>();
        for (String type : types) {
            boolean isValidType = false;
            for (ConfigurationItemDescriptor descriptor : descriptors) {
                if (!descriptor.getSimpleName().equalsIgnoreCase(type)) continue;
                isValidType = true;
            }
            if (!isValidType) continue;
            validTypes.add(type);
        }
        return validTypes;
    }

    private boolean checkConfigurationItemCreation(String[] tokens) throws CliException, ConversionException {
        boolean checkPassed = true;
        Map<String, String> attributes = PropertyListConverter.makeAttributes(1, tokens);
        Set<String> keySet = attributes.keySet();
        for (String configurationItemLabelKey : keySet) {
            String configurationItemLabel = attributes.get(configurationItemLabelKey);
            ConfigurationItemMetaData ci = this.automatedDeploymentService.findDesignConfigurationItemByLabel(configurationItemLabel);
            if (ci != null) {
                System.out.println("Configuration Item : " + configurationItemLabel + " exists");
                continue;
            }
            System.out.println("Configuration Item : " + configurationItemLabel + " doesn't exist");
            checkPassed = false;
        }
        return checkPassed;
    }

    private void checkUniqueLabel(String savedLine, Map<String, String> attributes) throws CliException {
        ConfigurationItemMetaData ci = this.automatedDeploymentService.findDesignConfigurationItemByLabel(attributes.get("label"));
        if (ci != null) {
            throw new CliException("don't understand: " + savedLine + " as there is already a CI with label " + attributes.get("label"));
        }
    }

    private String addDeploymentPackage(String[] tokens, String savedLine, ConfigurationItemDescriptor descriptor) throws CliException {
        Map<String, String> attributes;
        try {
            attributes = PropertyListConverter.makeAttributes(2, tokens);
        }
        catch (ConversionException e) {
            throw new CliException(e.getMessage());
        }
        ConfigurationItemMetaData itemMetaData = new ConfigurationItemMetaData();
        itemMetaData.setConfigurationItemClassName(descriptor.getType());
        if (attributes.get("version") == null || attributes.get("label") == null) {
            throw new CliException("don't understand: " + savedLine + " as there is no location specified. In this case both 'label' as well as 'version' are mandatory. One or both are missing");
        }
        String labelAndVersion = attributes.get("label") + " - " + attributes.get("version");
        DeploymentPackage item = new DeploymentPackage();
        item.setVersion(attributes.get("version"));
        item.setLabel(labelAndVersion);
        itemMetaData.setLabel(labelAndVersion);
        attributes.put("label", labelAndVersion);
        this.checkUniqueLabel(savedLine, attributes);
        try {
            ConfigurationItemDescriptor itemDescriptor = this.descriptorRepository.getDescriptor(item.getClass().getName());
            PropertyListConverter.populateObject(attributes, item, itemDescriptor.getPropertyDescriptors());
        }
        catch (ConversionException e) {
            throw new CliException(e.getMessage());
        }
        try {
            this.processRelations(itemMetaData, attributes, descriptor);
        }
        catch (CliException ce) {
            throw new CliException("don't understand: " + savedLine + " as I " + ce.getMessage());
        }
        this.automatedDeploymentService.addConfigurationItem(itemMetaData, item);
        return labelAndVersion;
    }

    private String importDeploymentPackage(String[] tokens, String savedLine) throws CliException {
        String loc;
        Map<String, String> attributes;
        this.result = "";
        try {
            attributes = PropertyListConverter.makeAttributes(1, tokens);
        }
        catch (ConversionException e) {
            throw new CliException(e.getMessage());
        }
        String sourceLocation = attributes.get("location");
        String username = attributes.get("username");
        String password = attributes.get("password");
        String permissionSchemeLabel = attributes.get("permissionscheme");
        System.out.println("Import Source Location: " + sourceLocation);
        try {
            if (sourceLocation.startsWith("http://") || sourceLocation.startsWith("https://")) {
                this.automatedDeploymentService.validateAndImportDeploymentPackageFromUrl(sourceLocation, username, password, permissionSchemeLabel);
            } else {
                this.automatedDeploymentService.validateAndImportDeploymentPackageOnServer(sourceLocation, permissionSchemeLabel);
            }
            loc = sourceLocation;
        }
        catch (Throwable t) {
            if (t instanceof FileNotFoundException) {
                throw new CliException("don't understand: " + savedLine + " as location " + sourceLocation + " does not exist");
            }
            throw new CliException("don't understand: " + savedLine + " because: " + t.getMessage());
        }
        return loc;
    }

    private void checkMandatoryProperties(Map<String, String> aMap, ConfigurationItemDescriptor descriptor) throws CliException {
        StringBuilder missingAttributes = new StringBuilder();
        StringBuilder allAttributes = new StringBuilder();
        boolean missedAttribute = false;
        for (ConfigurationItemPropertyDescriptor each : descriptor.getPropertyDescriptors()) {
            if (!each.isRequired() || each.getDefaultValue() != null) continue;
            String mandatoryProperty = each.getName().toLowerCase();
            allAttributes.append(mandatoryProperty).append(" ");
            if (aMap.get(mandatoryProperty) != null) continue;
            missingAttributes.append(mandatoryProperty).append(" ");
            missedAttribute = true;
        }
        ArrayList<String> allMandatoryProps = new ArrayList<String>();
        allMandatoryProps.add("label");
        allAttributes.append("label");
        for (String attribute : allMandatoryProps) {
            if (aMap.get(attribute) != null) continue;
            missingAttributes.append(" ");
            missingAttributes.append(attribute);
            missedAttribute = true;
        }
        if (missedAttribute) {
            throw new CliException("The following attributes are missing: " + missingAttributes.toString() + " from the required attributes: " + allAttributes.toString());
        }
    }

    private void delete(String[] tokens, String savedLine) throws CliException {
        ConfigurationItemMetaData configurationItemMetaData;
        if (tokens.length == 2) {
            String label = tokens[1];
            configurationItemMetaData = this.automatedDeploymentService.findDesignConfigurationItemByLabel(label);
            if (configurationItemMetaData == null) {
                throw new CliException("don't understand: " + savedLine + " as I can't find a CI with label provided");
            }
        } else {
            throw new CliException("don't understand: " + savedLine + " as I expected a single label to be provided");
        }
        this.automatedDeploymentService.deleteConfigurationItem(configurationItemMetaData);
    }

    private String read(BufferedReader stdin) {
        try {
            return stdin.readLine();
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public String getResult() {
        return this.result;
    }
}

