/*
 * Decompiled with CFR 0.152.
 */
package com.xebia.ad.service.impl;

import com.xebia.ad.repository.metadata.ChangePlan;
import com.xebia.ad.repository.metadata.ConfigurationItemHandle;
import com.xebia.ad.repository.metadata.ConfigurationItemRevision;
import com.xebia.ad.repository.resolvers.RepositoryView;
import com.xebia.ad.service.impl.ConfigurationItemDeleteCommand;
import com.xebialabs.deployit.ci.Deployment;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConfigurationItemDeleteCommandPreprocessor {
    public List<ConfigurationItemDeleteCommand> preprocessDeleteCommand(ChangePlan changePlan, ConfigurationItemDeleteCommand deleteCommand) {
        String type = deleteCommand.getType();
        if (type.equals(Deployment.class.getName())) {
            return this.deleteMappingsOfDeployment(changePlan, deleteCommand);
        }
        return Collections.emptyList();
    }

    private List<ConfigurationItemDeleteCommand> deleteMappingsOfDeployment(ChangePlan changePlan, ConfigurationItemDeleteCommand deleteCommand) {
        RepositoryView view = RepositoryView.getDesignView(changePlan);
        ArrayList<ConfigurationItemDeleteCommand> deleteCommands = new ArrayList<ConfigurationItemDeleteCommand>();
        ConfigurationItemRevision deploymentRevision = deleteCommand.getOldRevision();
        Set<ConfigurationItemHandle> mappingHandles = deploymentRevision.getRelatedCiHandles("mappings");
        for (ConfigurationItemHandle mappingHandle : mappingHandles) {
            ConfigurationItemRevision mappingRevision = view.getViewRevision(mappingHandle);
            if (mappingRevision == null) continue;
            deleteCommands.add(new ConfigurationItemDeleteCommand(mappingHandle.getLabel(), mappingHandle.getDescription(), mappingHandle.getType(), mappingRevision));
        }
        return deleteCommands;
    }
}

