/*
 * Decompiled with CFR 0.152.
 */
package com.xebia.ad.repository.factory;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.xebia.ad.repository.metadata.ConfigurationItemHandle;
import com.xebia.ad.repository.metadata.ConfigurationItemRevision;
import com.xebia.ad.repository.resolvers.RepositoryView;
import com.xebialabs.deployit.ConfigurationItem;
import com.xebialabs.deployit.reflect.ConfigurationItemProxy;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import net.sf.cglib.proxy.Callback;
import net.sf.cglib.proxy.CallbackFilter;
import net.sf.cglib.proxy.Enhancer;
import net.sf.cglib.proxy.Factory;
import net.sf.cglib.proxy.LazyLoader;
import net.sf.cglib.proxy.MethodInterceptor;
import net.sf.cglib.proxy.MethodProxy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class CiDetailsProxyFactory {
    private static Map<Class<?>, Factory> proxyFactoryCache = new ConcurrentHashMap();
    private static final String WRITE_REPLACE_METHOD_NAME = "writeReplace";
    private static final String CONFIGURATION_ITEM_PROXY_METHOD_NAME = "getBackingObject";

    CiDetailsProxyFactory() {
    }

    static Serializable newProxyInstance(ConfigurationItemRevision proxiedPropertyOwner, String propertyName, RepositoryView view) {
        ConfigurationItemHandle targetHandle = proxiedPropertyOwner.getRelatedCiHandle(propertyName);
        if (targetHandle == null) {
            return null;
        }
        Class<?> targetClass = targetHandle.getItemClass();
        Preconditions.checkArgument((targetClass.getAnnotation(ConfigurationItem.class) != null ? 1 : 0) != 0);
        ViewDetailsLoader loadImplementation = new ViewDetailsLoader(proxiedPropertyOwner, propertyName, targetHandle, view){

            protected Serializable handleNullView() {
                throw new IllegalStateException("No view set!");
            }
        };
        ViewDetailsLoader writeReplaceImplementation = new ViewDetailsLoader(proxiedPropertyOwner, propertyName, targetHandle, view){

            protected Serializable handleNullView() {
                return null;
            }
        };
        return (Serializable)CiDetailsProxyFactory.createProxy(loadImplementation, writeReplaceImplementation, targetClass);
    }

    private static <T> T createProxy(final Callable<? extends Serializable> loadImplementation, final Callable<? extends Serializable> writeReplaceImplementation, Class<T> targetClass) {
        Factory factory;
        LazyLoader lazyLoader = new LazyLoader(){

            public Serializable loadObject() throws Exception {
                return (Serializable)loadImplementation.call();
            }
        };
        MethodInterceptor backingObjectInterceptor = new MethodInterceptor(){

            public Object intercept(Object obj, Method method, Object[] args, MethodProxy proxy) throws Throwable {
                if (method.getName().equals(CiDetailsProxyFactory.WRITE_REPLACE_METHOD_NAME) || method.getName().equals(CiDetailsProxyFactory.CONFIGURATION_ITEM_PROXY_METHOD_NAME)) {
                    return writeReplaceImplementation.call();
                }
                throw new IllegalStateException("Incorrect callback invoked");
            }
        };
        Callback[] callbacks = new Callback[]{lazyLoader, backingObjectInterceptor};
        boolean lazyLoaderIndex = false;
        boolean backingObjectInterceptorIndex = true;
        CallbackFilter dispatcher = new CallbackFilter(){

            public int accept(Method method) {
                if (method.getName().equals(CiDetailsProxyFactory.WRITE_REPLACE_METHOD_NAME) || method.getName().equals(CiDetailsProxyFactory.CONFIGURATION_ITEM_PROXY_METHOD_NAME)) {
                    return 1;
                }
                return 0;
            }
        };
        if (proxyFactoryCache.containsKey(targetClass)) {
            factory = proxyFactoryCache.get(targetClass);
        } else {
            factory = (Factory)Enhancer.create(targetClass, (Class[])new Class[]{WriteReplaceImplementor.class, ConfigurationItemProxy.class}, (CallbackFilter)dispatcher, (Callback[])callbacks);
            proxyFactoryCache.put(targetClass, factory);
        }
        return (T)factory.newInstance(callbacks);
    }

    static Set<Serializable> newSetProxyInstance(final ConfigurationItemRevision proxiedSetOwner, final String setPropertyName, final RepositoryView view) {
        Callable loadImplementation = new Callable<ImmutableSet<?>>(){

            @Override
            public ImmutableSet<?> call() throws Exception {
                if (view == null) {
                    return ImmutableSet.of();
                }
                Set<ConfigurationItemHandle> targetHandles = proxiedSetOwner.getRelatedCiHandles(setPropertyName);
                HashSet<Serializable> targetDetails = new HashSet<Serializable>(targetHandles.size());
                for (ConfigurationItemHandle handle : targetHandles) {
                    Serializable details = view.getViewDetails(handle);
                    if (details == null) {
                        throw new IllegalStateException("No details for target handle " + handle + " belonging to set " + setPropertyName + " available in current view: hanging relation in revision " + proxiedSetOwner);
                    }
                    targetDetails.add(details);
                }
                return ImmutableSet.copyOf(targetDetails);
            }
        };
        Callable writeReplaceImplementation = new Callable<ImmutableSet<?>>(){

            @Override
            public ImmutableSet<?> call() throws Exception {
                return ImmutableSet.of();
            }
        };
        return (Set)CiDetailsProxyFactory.createProxy(loadImplementation, writeReplaceImplementation, ImmutableSet.class);
    }

    public static interface WriteReplaceImplementor {
        public Object writeReplace() throws ObjectStreamException;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static abstract class ViewDetailsLoader
    implements Callable<Serializable> {
        private final ConfigurationItemHandle targetHandle;
        private final RepositoryView view;
        private final String nullDetailsErrorMessage;

        private ViewDetailsLoader(ConfigurationItemRevision proxiedPropertyOwner, String propertyName, ConfigurationItemHandle targetHandle, RepositoryView view) {
            this.targetHandle = targetHandle;
            this.view = view;
            this.nullDetailsErrorMessage = "No details for target handle " + targetHandle.getId() + " of property " + propertyName + " available in current view: hanging relation in revision " + proxiedPropertyOwner.getId();
        }

        @Override
        public Serializable call() throws Exception {
            if (this.view == null) {
                return this.handleNullView();
            }
            Serializable details = this.view.getViewDetails(this.targetHandle);
            if (details == null) {
                throw new IllegalStateException(this.nullDetailsErrorMessage);
            }
            return details;
        }

        protected abstract Serializable handleNullView();
    }
}

