/*
 * Decompiled with CFR 0.152.
 */
package com.xebia.ad.repository;

import com.google.common.base.Preconditions;
import com.xebia.ad.DeployItConfiguration;
import com.xebialabs.deployit.ConfigurationItem;
import com.xebialabs.deployit.reflect.ConfigurationItemDescriptor;
import com.xebialabs.deployit.reflect.ConfigurationItemDescriptorFactoryHelper;
import com.xebialabs.deployit.reflect.ConfigurationItemProxy;
import com.xebialabs.deployit.reflect.ConfigurationItemReflectionUtils;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConfigurationItemTypeDescriptorRepository
implements ConfigurationItemDescriptorFactoryHelper {
    private Map<String, ConfigurationItemDescriptor> descriptors = new HashMap<String, ConfigurationItemDescriptor>();
    private Logger logger = Logger.getLogger(ConfigurationItemTypeDescriptorRepository.class);

    public ConfigurationItemTypeDescriptorRepository() {
    }

    public ConfigurationItemTypeDescriptorRepository(Collection<ConfigurationItemDescriptor> descriptorsAsCollection) {
        for (ConfigurationItemDescriptor descriptor : descriptorsAsCollection) {
            this.descriptors.put(descriptor.getType(), descriptor);
        }
    }

    public Collection<ConfigurationItemDescriptor> getDescriptors() {
        return this.descriptors.values();
    }

    public Map<String, ConfigurationItemDescriptor> getDescriptorMap() {
        return Collections.unmodifiableMap(this.descriptors);
    }

    public ConfigurationItemDescriptor getDescriptor(String type) {
        return this.descriptors.get(type);
    }

    public ConfigurationItemDescriptor getDescriptor(Class<?> clazz) {
        return this.descriptors.get(clazz.getName());
    }

    public ConfigurationItemDescriptor getDescriptor(Serializable object) {
        Serializable ci = object;
        if (ConfigurationItemProxy.class.isInstance(object)) {
            ci = ((ConfigurationItemProxy)object).getBackingObject();
        }
        return this.descriptors.get(ci.getClass().getName());
    }

    public void loadConfigurationItems(Collection<Class<?>> configurationItemTypes, List<String> loadingErrors) {
        this.descriptors.clear();
        DeployItConfiguration config = DeployItConfiguration.getInstance();
        for (Class type : (Collection)Preconditions.checkNotNull(configurationItemTypes)) {
            if (type.isAnnotationPresent(ConfigurationItem.class)) {
                ConfigurationItemDescriptor descriptor = new ConfigurationItemDescriptor(type, config.getDefaults());
                this.descriptors.put(descriptor.getType(), descriptor);
                continue;
            }
            String errorMessage = type.getName() + " does not have an @" + ConfigurationItem.class.getSimpleName() + " annotation. Ignoring it.";
            this.logger.error((Object)errorMessage);
            loadingErrors.add(errorMessage);
        }
    }

    public boolean isSimilar(Serializable ci1, Serializable ci2) {
        return ConfigurationItemReflectionUtils.isSimilar((Serializable)ci1, (Serializable)ci2);
    }

    public boolean isIdentical(Serializable ci1, Serializable ci2) {
        return ConfigurationItemReflectionUtils.isIdentical((Serializable)ci1, (Serializable)ci2);
    }
}

