/*
 * Decompiled with CFR 0.152.
 */
package com.xebia.ad.reporting;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class PdfConverterServlet
extends HttpServlet {
    private static final long serialVersionUID = 3719606277986229141L;

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.doPost(req, resp);
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        int maxLength = req.getContentLength();
        String method = req.getParameter("method");
        String name = req.getParameter("name");
        ServletInputStream si = req.getInputStream();
        ServletOutputStream stream = resp.getOutputStream();
        resp.setContentType("application/pdf");
        resp.setContentLength(maxLength);
        resp.setHeader("Content-Disposition", method + ";filename=" + name);
        this.copyStreams((InputStream)si, (OutputStream)stream, 100);
        stream.close();
    }

    private void copyStreams(InputStream inStream, OutputStream outStream, int flushCount) throws IOException {
        int currentByte;
        int flushCounter = 0;
        while ((currentByte = inStream.read()) != -1) {
            outStream.write(currentByte);
            if (flushCounter++ <= flushCount) continue;
            outStream.flush();
            flushCounter = 0;
        }
        outStream.flush();
    }
}

