/*
 * Decompiled with CFR 0.152.
 */
package com.xebia.ad.service.impl;

import com.google.common.base.Preconditions;
import com.xebia.ad.dao.ChangeDao;
import com.xebia.ad.dao.ConfigurationItemHandleDao;
import com.xebia.ad.dao.ConfigurationItemRevisionDao;
import com.xebia.ad.dao.NamedConfigurationItemRelationDao;
import com.xebia.ad.repository.ConfigurationItemTypeDescriptorRepository;
import com.xebia.ad.repository.metadata.Change;
import com.xebia.ad.repository.metadata.ChangePlan;
import com.xebia.ad.repository.metadata.ChangeType;
import com.xebia.ad.repository.metadata.ConfigurationItemHandle;
import com.xebia.ad.repository.metadata.ConfigurationItemRevision;
import com.xebia.ad.repository.metadata.NamedConfigurationItemRelation;
import com.xebia.ad.repository.resolvers.RepositoryView;
import com.xebia.ad.service.ChangePlanService;
import com.xebia.ad.service.RepositoryService;
import com.xebia.ad.service.impl.ConfigurationItemAddCommand;
import com.xebia.ad.service.impl.ConfigurationItemAddCommandPreprocessor;
import com.xebia.ad.service.impl.ConfigurationItemDeleteCommand;
import com.xebia.ad.service.impl.ConfigurationItemDeleteCommandPreprocessor;
import com.xebia.ad.service.impl.ConfigurationItemUpdateCommand;
import com.xebia.ad.service.impl.ConfigurationItemUpdateCommandPreprocessor;
import com.xebia.ad.support.Triple;
import com.xebialabs.deployit.ci.Deployment;
import com.xebialabs.deployit.ci.mapping.Mapping;
import com.xebialabs.deployit.ci.security.AccessControlEntry;
import com.xebialabs.deployit.mapper.Pair;
import com.xebialabs.deployit.reflect.ConfigurationItemDescriptor;
import com.xebialabs.deployit.reflect.ConfigurationItemPropertyDescriptor;
import com.xebialabs.deployit.reflect.ConfigurationItemPropertyType;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Transactional
public class UnsecuredRepositoryServiceImpl
implements RepositoryService {
    @Autowired(required=true)
    public ChangePlanService changePlanService;
    @Autowired(required=true)
    public ConfigurationItemHandleDao configurationItemHandleDao;
    @Autowired(required=true)
    public ConfigurationItemRevisionDao configurationItemRevisionDao;
    @Autowired(required=true)
    public NamedConfigurationItemRelationDao namedConfigurationItemRelationDao;
    @Autowired(required=true)
    public ChangeDao changeDao;
    @Autowired(required=true)
    public ConfigurationItemUpdateCommandPreprocessor updatePreProcessor;
    @Autowired(required=true)
    public ConfigurationItemAddCommandPreprocessor addPreProcessor;
    private ConfigurationItemDeleteCommandPreprocessor deletePreProcessor = new ConfigurationItemDeleteCommandPreprocessor();
    @Autowired
    private ConfigurationItemTypeDescriptorRepository descriptorRepository;
    private static Logger logger = Logger.getLogger(UnsecuredRepositoryServiceImpl.class);

    @Override
    public Collection<Pair<ConfigurationItemRevision, AccessControlEntry>> getActualRevisions() {
        List<ConfigurationItemHandle> actualHandles = this.configurationItemHandleDao.findHandlesWithActualRevision();
        ArrayList<Pair<ConfigurationItemRevision, AccessControlEntry>> actualRevisions = new ArrayList<Pair<ConfigurationItemRevision, AccessControlEntry>>();
        for (ConfigurationItemHandle actualHandle : actualHandles) {
            ConfigurationItemRevision actualRevision = actualHandle.getActualRevision();
            AccessControlEntry revisionPermissions = AccessControlEntry.getAllPermissions((String)"Anonymous");
            actualRevisions.add((Pair<ConfigurationItemRevision, AccessControlEntry>)new Pair((Object)actualRevision, (Object)revisionPermissions));
        }
        return actualRevisions;
    }

    @Override
    public Pair<ConfigurationItemRevision, AccessControlEntry> findActualRevisionByHandleId(int handleId) {
        ConfigurationItemHandle handle = (ConfigurationItemHandle)this.configurationItemHandleDao.findById(Integer.valueOf(handleId));
        if (handle == null) {
            return null;
        }
        ConfigurationItemRevision actualRevision = handle.getActualRevision();
        if (actualRevision == null) {
            return null;
        }
        return new Pair((Object)actualRevision, (Object)AccessControlEntry.getAllPermissions((String)"Anonymous"));
    }

    @Override
    public Pair<ConfigurationItemRevision, AccessControlEntry> findActualRevisionByLabel(String label) {
        ConfigurationItemHandle handle = this.configurationItemHandleDao.findByLabel(label);
        if (handle == null) {
            return null;
        }
        ConfigurationItemRevision actualRevision = handle.getActualRevision();
        if (actualRevision == null) {
            return null;
        }
        return new Pair((Object)actualRevision, (Object)AccessControlEntry.getAllPermissions((String)"Anonymous"));
    }

    @Override
    public Pair<ConfigurationItemRevision, AccessControlEntry> findPreviousRevisionByHandleId(int handleId) {
        ConfigurationItemHandle handle = (ConfigurationItemHandle)this.configurationItemHandleDao.findById(Integer.valueOf(handleId));
        if (handle == null) {
            return null;
        }
        ConfigurationItemRevision actualRevision = handle.getActualRevision();
        if (actualRevision == null) {
            return null;
        }
        Change creatingChange = this.changeDao.findChangeThatCreatedRevision(actualRevision);
        if (creatingChange == null) {
            return null;
        }
        ConfigurationItemRevision previousRevision = creatingChange.getOldRevision();
        if (previousRevision == null) {
            return null;
        }
        return new Pair((Object)previousRevision, (Object)AccessControlEntry.getAllPermissions((String)"Anonymous"));
    }

    @Override
    public Triple<ConfigurationItemRevision, Change, AccessControlEntry> findDesignRevisionByLabel(String label) {
        Change c;
        ConfigurationItemHandle handle = this.configurationItemHandleDao.findByLabel(label);
        if (handle == null) {
            return null;
        }
        ChangePlan cp = this.changePlanService.findCurrentChangePlan();
        if (cp != null && (c = this.changeDao.findChangeForChangePlanAndHandle(cp, handle)) != null) {
            ConfigurationItemRevision revision = c.getApplicableRevision();
            return new Triple<ConfigurationItemRevision, Change, AccessControlEntry>(revision, c, AccessControlEntry.getAllPermissions((String)"Anonymous"));
        }
        if (handle.getActualRevision() == null) {
            return null;
        }
        return new Triple<ConfigurationItemRevision, Object, AccessControlEntry>(handle.getActualRevision(), null, AccessControlEntry.getAllPermissions((String)"Anonymous"));
    }

    @Override
    public ConfigurationItemRevision getConfigurationItemRevision(int revisionId) {
        return (ConfigurationItemRevision)this.configurationItemRevisionDao.getById(Integer.valueOf(revisionId));
    }

    @Override
    public Serializable getConfigurationItemDetailsObject(int revisionId) {
        return ((ConfigurationItemRevision)this.configurationItemRevisionDao.getById(Integer.valueOf(revisionId))).getDetailsObject(RepositoryView.getActualView());
    }

    @Override
    public ConfigurationItemHandle addConfigurationItem(String label, String description, String type, ConfigurationItemRevision newRevision) {
        ChangePlan cp;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Adding CI \"" + label + "\""));
        }
        if (!(cp = this.changePlanService.getOrCreateCurrentChangePlan()).canBeResolved() && !cp.isDiscovering()) {
            throw new RuntimeException("Can't add CI: " + label + " as you are executing a changeplan.");
        }
        this.validateLabel(label, null, cp);
        ConfigurationItemAddCommand addCommand = new ConfigurationItemAddCommand(label, description, type, newRevision);
        List<ConfigurationItemAddCommand> additionalCommands = this.addPreProcessor.preprocessAddCommand(cp, addCommand);
        ConfigurationItemHandle addedHandle = this.noValidateAddConfigurationItem(addCommand, cp);
        for (ConfigurationItemAddCommand additionalCommand : additionalCommands) {
            this.noValidateAddConfigurationItem(additionalCommand, cp);
        }
        this.postprocess(cp, addCommand, additionalCommands);
        return addedHandle;
    }

    protected void postprocess(ChangePlan cp, ConfigurationItemAddCommand addCommand, List<ConfigurationItemAddCommand> additionalCommands) {
        RepositoryView view = RepositoryView.getDesignView(cp);
        if (addCommand.getType().equals(Deployment.class.getName())) {
            ConfigurationItemRevision deploymentRevision = addCommand.getNewRevision();
            for (ConfigurationItemAddCommand additionalCommand : additionalCommands) {
                ConfigurationItemRevision mappingRevision = additionalCommand.getNewRevision();
                Deployment deployment = (Deployment)addCommand.getNewRevision().getDetailsObject(view);
                ConfigurationItemHandle mappingHandle = mappingRevision.getHandle();
                deploymentRevision.addRelatedCiHandle("mappings", mappingHandle);
                this.setMappingSpecificDetails(view, mappingRevision, deployment);
            }
        }
    }

    private void setMappingSpecificDetails(RepositoryView view, ConfigurationItemRevision mappingRevision, Deployment deployment) {
        Serializable detailsObject = mappingRevision.getDetailsObject(view);
        if (detailsObject instanceof Mapping) {
            Mapping mapping = (Mapping)mappingRevision.getDetailsObject(view);
            mapping.postInit(deployment);
            mappingRevision.setDetailsObject(mapping);
        }
    }

    private ConfigurationItemHandle noValidateAddConfigurationItem(ConfigurationItemAddCommand addCommand, ChangePlan cp) {
        this.configurationItemRevisionDao.persist(addCommand.getNewRevision());
        ConfigurationItemHandle newHandle = new ConfigurationItemHandle(addCommand.getType());
        newHandle.setLabel(addCommand.getLabel());
        newHandle.setDescription(addCommand.getDescription());
        newHandle.addRevision(addCommand.getNewRevision());
        Change c = Change.newAddition(addCommand.getNewRevision());
        this.configurationItemHandleDao.persist(newHandle);
        this.changeDao.persist(c);
        cp.addChange(c);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Added CI \"" + addCommand.getLabel() + "\""));
        }
        return newHandle;
    }

    @Override
    public void updateConfigurationItem(ConfigurationItemHandle existingHandle, String label, String description, ConfigurationItemRevision newRevision) {
        ChangePlan cp = this.changePlanService.getOrCreateCurrentChangePlan();
        if (!cp.canBeResolved() && !cp.isDiscovering()) {
            throw new RuntimeException("Can't update CI: " + label + " as you are executing a changeplan.");
        }
        this.validateLabel(label, existingHandle, cp);
        ConfigurationItemUpdateCommand updateCommand = new ConfigurationItemUpdateCommand(existingHandle, label, description, newRevision);
        ArrayList<String> warnings = new ArrayList<String>();
        List<ConfigurationItemUpdateCommand> commands = this.updatePreProcessor.preprocessUpdateCommand(cp, updateCommand, warnings);
        cp.removeWarnings();
        for (String warning : warnings) {
            cp.addWarning(warning);
        }
        for (ConfigurationItemUpdateCommand each : commands) {
            this.noValidateUpdateConfigurationItem(each, cp);
        }
        this.postprocess(cp, updateCommand, commands);
    }

    protected void postprocess(ChangePlan cp, ConfigurationItemUpdateCommand updateCommand, List<ConfigurationItemUpdateCommand> additionalCommands) {
        RepositoryView view = RepositoryView.getDesignView(cp);
        if (updateCommand.getNewRevision().getType().equals(Deployment.class.getName())) {
            for (ConfigurationItemUpdateCommand additionalCommand : additionalCommands) {
                ConfigurationItemRevision mappingRevision = additionalCommand.getNewRevision();
                Deployment deployment = (Deployment)updateCommand.getNewRevision().getDetailsObject(view);
                this.setMappingSpecificDetails(view, mappingRevision, deployment);
            }
        }
    }

    private boolean noValidateUpdateConfigurationItem(ConfigurationItemUpdateCommand update, ChangePlan cp) {
        ConfigurationItemHandle existingHandle = update.getExistingHandle();
        String label = update.getLabel();
        String description = update.getDescription();
        ConfigurationItemRevision newRevision = update.getNewRevision();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Updating CI \"" + label + "\""));
        }
        this.configurationItemRevisionDao.persist(newRevision);
        existingHandle.setLabel(label);
        existingHandle.setDescription(description);
        existingHandle.addRevision(newRevision);
        boolean updatedAddition = this.removeExistingChange(existingHandle, cp, false);
        Change c = updatedAddition ? Change.newAddition(newRevision) : Change.newModification(newRevision);
        this.configurationItemHandleDao.persist(existingHandle);
        this.changeDao.persist(c);
        cp.addChange(c);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Updated CI \"" + label + "\""));
        }
        return updatedAddition;
    }

    @Override
    public void deleteConfigurationItem(ConfigurationItemHandle existingHandle) {
        ChangePlan cp;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Deleting CI \"" + existingHandle.getLabel() + "\""));
        }
        if (!(cp = this.changePlanService.getOrCreateCurrentChangePlan()).canBeResolved()) {
            throw new RuntimeException("Can't delete CI: " + existingHandle.getLabel() + " as you are executing a changeplan.");
        }
        RepositoryView view = RepositoryView.getDesignView(cp);
        ConfigurationItemRevision designRevision = view.getViewRevision(existingHandle);
        ConfigurationItemDeleteCommand deleteCommand = new ConfigurationItemDeleteCommand(existingHandle.getLabel(), existingHandle.getDescription(), existingHandle.getType(), designRevision);
        this.noValidateDeleteConfigurationItem(deleteCommand, cp);
        List<ConfigurationItemDeleteCommand> additionalDeleteCommands = this.deletePreProcessor.preprocessDeleteCommand(cp, deleteCommand);
        for (ConfigurationItemDeleteCommand additionalDeleteCommand : additionalDeleteCommands) {
            this.noValidateDeleteConfigurationItem(additionalDeleteCommand, cp);
        }
    }

    private void noValidateDeleteConfigurationItem(ConfigurationItemDeleteCommand deleteCommand, ChangePlan cp) {
        ConfigurationItemHandle existingHandle = deleteCommand.getOldRevision().getHandle();
        this.handleRelationsInDeletions(existingHandle, cp);
        boolean deletedAddition = this.removeExistingChange(existingHandle, cp, true);
        if (deletedAddition) {
            this.namedConfigurationItemRelationDao.findAndRemoveRelationsForHandle(existingHandle);
            this.configurationItemHandleDao.remove(existingHandle);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Undid CI \"" + existingHandle.getLabel() + "\" that was added in this changeplan"));
            }
        } else {
            Change c = Change.newDeletion(existingHandle.getActualRevision());
            this.changeDao.persist(c);
            cp.addChange(c);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Deleted CI \"" + existingHandle.getLabel() + "\""));
            }
        }
    }

    private void handleRelationsInDeletions(ConfigurationItemHandle existingHandle, ChangePlan cp) {
        List<NamedConfigurationItemRelation> relations = this.namedConfigurationItemRelationDao.findRelationsPointingToMe(existingHandle);
        if (relations != null && relations.size() > 0) {
            ArrayList<NamedConfigurationItemRelation> relationsThatCanBeRemoved = new ArrayList<NamedConfigurationItemRelation>();
            for (NamedConfigurationItemRelation relation : relations) {
                Change changeOfOwningSide;
                boolean referringCiIsDeletedToo;
                ConfigurationItemHandle referringCiHandle = relation.getOwningRevision().getHandle();
                String propertyOfReferringCi = relation.getPropertyName();
                ConfigurationItemDescriptor descriptor = this.descriptorRepository.getDescriptor(referringCiHandle.getType());
                ConfigurationItemPropertyDescriptor propertyDescriptor = descriptor.getPropertyDescriptor(propertyOfReferringCi);
                if (!this.revisionIsInUse(relation.getOwningRevision(), cp)) continue;
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Updating relation " + propertyOfReferringCi + " in CI \"" + referringCiHandle.getLabel() + "\" (if allowed) due to deletion of CI \"" + existingHandle.getLabel() + "\""));
                }
                if (referringCiIsDeletedToo = (changeOfOwningSide = cp.findChangeByHandle(referringCiHandle)) != null && changeOfOwningSide.getType() == ChangeType.DELETION) continue;
                if (propertyDescriptor.isRequired()) {
                    if (propertyDescriptor.getType() == ConfigurationItemPropertyType.SET_OF_CIS) {
                        Set<ConfigurationItemHandle> allChildrenHandles = relation.getOwningRevision().getRelatedCiHandles(propertyOfReferringCi);
                        if (allChildrenHandles.size() <= 1) {
                            throw new RuntimeException("Can't delete CI: " + existingHandle.getLabel() + " as it is the last member in a required set property: " + propertyOfReferringCi + " of the CI: " + referringCiHandle.getLabel());
                        }
                    } else {
                        throw new RuntimeException("Can't delete CI: " + existingHandle.getLabel() + " as it is used as a required property: " + propertyOfReferringCi + " of the CI: " + referringCiHandle.getLabel());
                    }
                }
                relationsThatCanBeRemoved.add(relation);
            }
            this.removeRelations(cp, relationsThatCanBeRemoved);
        }
    }

    private void handleRelationsInUndos(ConfigurationItemHandle existingHandle, ChangePlan cp, boolean clearingTheChangePlan) {
        List<NamedConfigurationItemRelation> relations = this.namedConfigurationItemRelationDao.findRelationsPointingToMe(existingHandle);
        if (relations != null && relations.size() > 0) {
            ArrayList<NamedConfigurationItemRelation> relationsThatCanBeRemoved = new ArrayList<NamedConfigurationItemRelation>();
            for (NamedConfigurationItemRelation relation : relations) {
                ConfigurationItemHandle referringCiHandle = relation.getOwningRevision().getHandle();
                String propertyOfReferringCi = relation.getPropertyName();
                ConfigurationItemDescriptor descriptor = this.descriptorRepository.getDescriptor(referringCiHandle.getType());
                ConfigurationItemPropertyDescriptor propertyDescriptor = descriptor.getPropertyDescriptor(propertyOfReferringCi);
                if (!this.revisionIsInUse(relation.getOwningRevision(), cp)) continue;
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Updating relation " + propertyOfReferringCi + " in CI \"" + referringCiHandle.getLabel() + "\" (if allowed) due to undo of CI \"" + existingHandle.getLabel() + "\""));
                }
                if (clearingTheChangePlan) continue;
                if (propertyDescriptor.isRequired()) {
                    if (propertyDescriptor.getType() == ConfigurationItemPropertyType.SET_OF_CIS) {
                        Set<ConfigurationItemHandle> allChildrenHandles = relation.getOwningRevision().getRelatedCiHandles(propertyOfReferringCi);
                        if (allChildrenHandles.size() <= 1) {
                            throw new RuntimeException("Can't undo CI: " + existingHandle.getLabel() + " as it is the last member in a required set property: " + propertyOfReferringCi + " of the CI: " + referringCiHandle.getLabel());
                        }
                    } else {
                        throw new RuntimeException("Can't undo CI: " + existingHandle.getLabel() + " as it is used as a required property: " + propertyOfReferringCi + " of the CI: " + referringCiHandle.getLabel());
                    }
                }
                relationsThatCanBeRemoved.add(relation);
            }
            this.removeRelations(cp, relationsThatCanBeRemoved);
        }
    }

    private void removeRelations(ChangePlan cp, List<NamedConfigurationItemRelation> relationsThatCanBeRemoved) {
        for (NamedConfigurationItemRelation relation : relationsThatCanBeRemoved) {
            ConfigurationItemHandle parentHandle = relation.getOwningRevision().getHandle();
            Triple<ConfigurationItemRevision, Change, AccessControlEntry> r = this.findDesignRevisionByLabel(parentHandle.getLabel());
            if (r == null) continue;
            ConfigurationItemRevision oldRevision = r.getFirst();
            ConfigurationItemRevision updatedRevision = new ConfigurationItemRevision(oldRevision.getDetailsObject(RepositoryView.getActualView()), oldRevision.getPermissionSchemeHandle());
            Set<NamedConfigurationItemRelation> relationsOfReferrer = relation.getOwningRevision().getNamedConfigurationItemRelations();
            HashSet<NamedConfigurationItemRelation> newRelationSet = new HashSet<NamedConfigurationItemRelation>();
            for (NamedConfigurationItemRelation relationOfReferrer : relationsOfReferrer) {
                if (relationOfReferrer == relation) continue;
                NamedConfigurationItemRelation newNamedConfigurationItemRelation = new NamedConfigurationItemRelation(updatedRevision, relationOfReferrer.getPropertyName(), relationOfReferrer.getTargetHandle());
                newRelationSet.add(newNamedConfigurationItemRelation);
            }
            updatedRevision.setNamedConfigurationItemRelations(newRelationSet);
            ConfigurationItemUpdateCommand updateCommand = new ConfigurationItemUpdateCommand(parentHandle, parentHandle.getLabel(), parentHandle.getDescription(), updatedRevision);
            this.noValidateUpdateConfigurationItem(updateCommand, cp);
        }
    }

    private boolean revisionIsInUse(ConfigurationItemRevision revision, ChangePlan cp) {
        ConfigurationItemHandle handle = revision.getHandle();
        Change c = cp.findChangeByHandle(handle);
        if (c != null) {
            if (c.getType() == ChangeType.DELETION) {
                return c.getOldRevision().getId() == revision.getId();
            }
            return c.getNewRevision().getId() == revision.getId();
        }
        return handle.getActualRevision() != null && handle.getActualRevision().getId() == revision.getId();
    }

    @Override
    public void undoConfigurationItem(ConfigurationItemHandle existingHandle, boolean clearingTheChangePlan) {
        ChangePlan changePlan;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Undoing CI \"" + existingHandle.getLabel() + "\""));
        }
        if ((changePlan = this.changePlanService.findCurrentChangePlan()) == null) {
            return;
        }
        if (!changePlan.canBeResolved()) {
            throw new RuntimeException("Can't undo CI: " + existingHandle.getLabel() + " as you are executing a changeplan.");
        }
        this.handleRelationsInUndos(existingHandle, changePlan, clearingTheChangePlan);
        boolean undidAddition = this.removeExistingChange(existingHandle, changePlan, true);
        if (undidAddition) {
            this.namedConfigurationItemRelationDao.findAndRemoveRelationsForHandle(existingHandle);
            this.configurationItemHandleDao.remove(existingHandle);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Undid CI \"" + existingHandle.getLabel() + "\""));
        }
    }

    @Override
    public AccessControlEntry getGlobalPermissionsForCurrentUser() {
        return AccessControlEntry.getAllPermissions((String)"Anonymous");
    }

    @Override
    public AccessControlEntry getPermissionsForCurrentUser(ConfigurationItemRevision revision) {
        return AccessControlEntry.getAllPermissions((String)"Anonymous");
    }

    private boolean removeExistingChange(ConfigurationItemHandle existingHandle, ChangePlan changePlan, boolean removeArtifactFiles) {
        Change change = this.changeDao.findChangeForChangePlanAndHandle(changePlan, existingHandle);
        if (change != null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Removing existing change with id " + change.getId()));
            }
            if (change.getType() == ChangeType.ADDITION || change.getType() == ChangeType.MODIFICATION) {
                ConfigurationItemRevision revisionToDestroy = change.getNewRevision();
                if (removeArtifactFiles && change.getType() == ChangeType.ADDITION) {
                    revisionToDestroy.removeArtifactFiles();
                }
                this.configurationItemRevisionDao.remove(revisionToDestroy);
            }
            changePlan.removeChange(change);
            this.changeDao.remove(change);
            return change.getType() == ChangeType.ADDITION;
        }
        return false;
    }

    @Override
    public List<Pair<ConfigurationItemRevision, Date>> getAllRevisionsWithCreationDateForHandleId(int handleId) {
        ConfigurationItemHandle handle = (ConfigurationItemHandle)this.configurationItemHandleDao.getById(Integer.valueOf(handleId));
        List<Change> allChangesForHandle = this.changeDao.findAllChangesForHandle(handle);
        ArrayList<Pair<ConfigurationItemRevision, Date>> allRevisionsWithCreationDate = new ArrayList<Pair<ConfigurationItemRevision, Date>>();
        for (Change c : allChangesForHandle) {
            ConfigurationItemRevision revision = (ConfigurationItemRevision)Preconditions.checkNotNull((Object)c.getNewRevision(), (Object)"Deletion change was not expected.");
            allRevisionsWithCreationDate.add((Pair<ConfigurationItemRevision, Date>)new Pair((Object)revision, (Object)c.getChangePlan().getStartOfExecution()));
        }
        return allRevisionsWithCreationDate;
    }

    private void validateLabel(String label, ConfigurationItemHandle existingHandle, ChangePlan cp) {
        ConfigurationItemHandle ciHandleWithSameLabel;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Validating whether label \"" + label + "\" already exists"));
        }
        if ((ciHandleWithSameLabel = this.configurationItemHandleDao.findByLabel(label)) != null && ciHandleWithSameLabel != existingHandle) {
            if (ciHandleWithSameLabel.getActualRevision() != null) {
                throw new IllegalStateException("A CI with label " + label + " already exists");
            }
            Set<Change> changes = ciHandleWithSameLabel.getChanges();
            for (Change c : changes) {
                if (c.getChangePlan().getId() == cp.getId()) continue;
                throw new IllegalStateException("A CI with label " + label + " already exists in the changeplan of " + c.getChangePlan().getUsername());
            }
            throw new IllegalStateException("A CI with label " + label + " already exists in your own changeplan");
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Validated whether label \"" + label + "\" already exists"));
        }
    }

    @Override
    public String getHandleLabelForHandleId(int handleId) {
        ConfigurationItemHandle handle = (ConfigurationItemHandle)this.configurationItemHandleDao.findById(Integer.valueOf(handleId));
        return handle.getLabel();
    }
}

