/*
 * Decompiled with CFR 0.152.
 */
package com.xebia.ad.service.impl;

import com.xebia.ad.repository.ConfigurationItemTypeDescriptorRepository;
import com.xebia.ad.repository.metadata.ChangePlan;
import com.xebia.ad.repository.metadata.ConfigurationItemHandle;
import com.xebia.ad.repository.metadata.ConfigurationItemRevision;
import com.xebia.ad.repository.resolvers.RepositoryView;
import com.xebia.ad.service.impl.ConfigurationItemAddCommand;
import com.xebia.ad.support.LabelGenerator;
import com.xebialabs.deployit.ci.Deployment;
import com.xebialabs.deployit.ci.DeploymentPackage;
import com.xebialabs.deployit.ci.Environment;
import com.xebialabs.deployit.ci.mapping.Mapping;
import com.xebialabs.deployit.reflect.ConfigurationItemDescriptor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConfigurationItemAddCommandPreprocessor {
    @Autowired
    private final ConfigurationItemTypeDescriptorRepository repository;

    public ConfigurationItemAddCommandPreprocessor(ConfigurationItemTypeDescriptorRepository repository) {
        this.repository = repository;
    }

    public List<ConfigurationItemAddCommand> preprocessAddCommand(ChangePlan changePlan, ConfigurationItemAddCommand addCommand) {
        String type = addCommand.getType();
        if (type.equals(Deployment.class.getName())) {
            return this.createDefaultMappings(changePlan, addCommand);
        }
        return Collections.emptyList();
    }

    private List<ConfigurationItemAddCommand> createDefaultMappings(ChangePlan changePlan, ConfigurationItemAddCommand addCommand) {
        ArrayList<ConfigurationItemDescriptor> mappingDescriptors = new ArrayList<ConfigurationItemDescriptor>();
        ArrayList<ConfigurationItemAddCommand> commands = new ArrayList<ConfigurationItemAddCommand>();
        RepositoryView view = RepositoryView.getDesignView(changePlan);
        ConfigurationItemRevision deploymentRevision = addCommand.getNewRevision();
        ConfigurationItemHandle packageHandle = deploymentRevision.getRelatedCiHandle("source");
        ConfigurationItemHandle targetHandle = deploymentRevision.getRelatedCiHandle("target");
        if (packageHandle.getType().equals(DeploymentPackage.class.getName()) && targetHandle.getType().equals(Environment.class.getName())) {
            ConfigurationItemRevision packageRevision = view.getViewRevision(packageHandle);
            ConfigurationItemRevision targetRevision = view.getViewRevision(targetHandle);
            HashSet<ConfigurationItemHandle> packageMemberHandles = new HashSet<ConfigurationItemHandle>();
            packageMemberHandles.addAll(packageRevision.getRelatedCiHandles("deployableArtifacts"));
            packageMemberHandles.addAll(packageRevision.getRelatedCiHandles("middlewareResources"));
            HashSet<ConfigurationItemHandle> envMemberHandles = new HashSet<ConfigurationItemHandle>();
            envMemberHandles.addAll(targetRevision.getRelatedCiHandles("members"));
            if (!packageMemberHandles.isEmpty() && !envMemberHandles.isEmpty()) {
                for (ConfigurationItemDescriptor eachTD : this.repository.getDescriptors()) {
                    if (!eachTD.getSuperClasses().contains(Mapping.class.getName()) && !eachTD.getType().equals(Mapping.class.getName())) continue;
                    mappingDescriptors.add(eachTD);
                }
                for (ConfigurationItemHandle packageMemberHandle : packageMemberHandles) {
                    String packageMemberType = packageMemberHandle.getType();
                    for (ConfigurationItemHandle envMemberHandle : envMemberHandles) {
                        ConfigurationItemDescriptor envMemberDescriptor;
                        String envMemberType = envMemberHandle.getType();
                        ConfigurationItemDescriptor packageMemberDescriptor = this.repository.getDescriptor(packageMemberType);
                        if (packageMemberDescriptor == null || (envMemberDescriptor = this.repository.getDescriptor(envMemberType)) == null) continue;
                        ArrayList<String> pkgMemberClassesList = new ArrayList<String>();
                        pkgMemberClassesList.add(packageMemberType);
                        pkgMemberClassesList.addAll(packageMemberDescriptor.getSuperClasses());
                        pkgMemberClassesList.addAll(packageMemberDescriptor.getInterfacesWithoutSerializable());
                        ArrayList<String> envMemberClassesList = new ArrayList<String>();
                        envMemberClassesList.add(envMemberType);
                        envMemberClassesList.addAll(envMemberDescriptor.getSuperClasses());
                        envMemberClassesList.addAll(envMemberDescriptor.getInterfacesWithoutSerializable());
                        ConfigurationItemDescriptor mappingDescriptor = this.findAppropriateMappingDescriptor(pkgMemberClassesList, envMemberClassesList, mappingDescriptors);
                        if (mappingDescriptor == null) continue;
                        commands.add(this.createMappingAddCommand(view, packageHandle, packageMemberHandle, envMemberHandle, mappingDescriptor, addCommand));
                    }
                }
            }
        }
        return commands;
    }

    private ConfigurationItemDescriptor findAppropriateMappingDescriptor(List<String> pkgMemberClassesList, List<String> envMemberClassesList, Collection<ConfigurationItemDescriptor> mappingDescriptors) {
        for (String pkgMemberClassType : pkgMemberClassesList) {
            for (String envMemberClassType : envMemberClassesList) {
                for (ConfigurationItemDescriptor mappingDescriptor : mappingDescriptors) {
                    if (!mappingDescriptor.getMappingSourceType().equals(pkgMemberClassType) || !mappingDescriptor.getMappingTargetType().equals(envMemberClassType)) continue;
                    return mappingDescriptor;
                }
            }
        }
        return null;
    }

    private ConfigurationItemAddCommand createMappingAddCommand(RepositoryView view, ConfigurationItemHandle packageHandle, ConfigurationItemHandle packageMemberHandle, ConfigurationItemHandle envMemberHandle, ConfigurationItemDescriptor mappingDescriptor, ConfigurationItemAddCommand addCommand) {
        Mapping mapping;
        try {
            mapping = (Mapping)Class.forName(mappingDescriptor.getType()).newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to generate mapping", e);
        }
        ConfigurationItemRevision mappingRevision = new ConfigurationItemRevision(mapping);
        mappingRevision.addRelatedCiHandle("source", packageMemberHandle);
        mappingRevision.addRelatedCiHandle("target", envMemberHandle);
        return new ConfigurationItemAddCommand(LabelGenerator.makeApplicationAndVersionLessLabel(packageHandle, packageMemberHandle, view) + " to " + envMemberHandle.getLabel() + " for " + addCommand.getLabel(), "", mappingDescriptor.getType(), mappingRevision);
    }
}

