/*
 * Decompiled with CFR 0.152.
 */
package com.xebia.ad.setup;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum SetupDatabaseType {
    ORACLE,
    MYSQL,
    HSQLDB;


    public static String getDefaultDatabaseDriverClass(SetupDatabaseType databaseType) {
        switch (databaseType) {
            case ORACLE: {
                return "oracle.jdbc.driver.OracleDriver";
            }
            case MYSQL: {
                return "com.mysql.jdbc.Driver";
            }
            case HSQLDB: {
                return "org.hsqldb.jdbcDriver";
            }
        }
        throw new RuntimeException("Database " + (Object)((Object)databaseType) + " type is not supported");
    }

    public static String getDatabaseSpringConfiguration(SetupDatabaseType databaseType) {
        switch (databaseType) {
            case ORACLE: {
                return "ad-core-context-oracle-nocreate.xml";
            }
            case MYSQL: {
                return "ad-core-context-mysql-nocreate.xml";
            }
            case HSQLDB: {
                return "ad-core-context-hsqldb-file-nocreate.xml";
            }
        }
        throw new RuntimeException("Database " + (Object)((Object)databaseType) + " type is not supported");
    }

    public static String getCreationalDatabaseSpringConfiguration(SetupDatabaseType databaseType) {
        switch (databaseType) {
            case ORACLE: {
                return "ad-core-context-oracle-create.xml";
            }
            case MYSQL: {
                return "ad-core-context-mysql-create.xml";
            }
            case HSQLDB: {
                return "ad-core-context-hsqldb-file-create.xml";
            }
        }
        throw new RuntimeException("Database " + (Object)((Object)databaseType) + " type is not supported");
    }

    public static String getDatabaseJPAConfiguration(SetupDatabaseType databaseType) {
        switch (databaseType) {
            case ORACLE: {
                return "oracle";
            }
            case MYSQL: {
                return "mysql";
            }
            case HSQLDB: {
                return "hsqldb";
            }
        }
        throw new RuntimeException("Database " + (Object)((Object)databaseType) + " type is not supported");
    }

    public static String getHibernateDialect(SetupDatabaseType databaseType) {
        switch (databaseType) {
            case ORACLE: {
                return "org.hibernate.dialect.OracleDialect";
            }
            case MYSQL: {
                return "org.hibernate.dialect.MySQL5Dialect";
            }
            case HSQLDB: {
                return "org.hibernate.dialect.HSQLDialect";
            }
        }
        throw new RuntimeException("Database " + (Object)((Object)databaseType) + " type is not supported");
    }

    public static String getExampleConnectionURL(SetupDatabaseType databaseType) {
        switch (databaseType) {
            case ORACLE: {
                return "jdbc:oracle:thin:@<HOSTNAME>:<PORT, default is 1521>:<SID>";
            }
            case MYSQL: {
                return "jdbc:mysql://<HOSTNAME>/<DATABASE>";
            }
            case HSQLDB: {
                return "jdbc:hsqldb:file:<PATH TO HSQLDB DB FILE>/<HSQLDB FILENAME>;shutdown=true";
            }
        }
        throw new RuntimeException("Database " + (Object)((Object)databaseType) + " type is not supported");
    }

    public static String getDefaultConnectionURL(SetupDatabaseType databaseType) {
        switch (databaseType) {
            case ORACLE: {
                return "jdbc:oracle:thin:@localhost:1521:DEPLOYIT";
            }
            case MYSQL: {
                return "jdbc:mysql://localhost/ad";
            }
            case HSQLDB: {
                return "jdbc:hsqldb:file:deployit.hdb;shutdown=true";
            }
        }
        throw new RuntimeException("Database " + (Object)((Object)databaseType) + " type is not supported");
    }

    public static String getDefaultUsername(SetupDatabaseType databaseType) {
        switch (databaseType) {
            case ORACLE: {
                return "";
            }
            case MYSQL: {
                return "";
            }
            case HSQLDB: {
                return "sa";
            }
        }
        throw new RuntimeException("Database " + (Object)((Object)databaseType) + " type is not supported");
    }
}

