/*
 * Decompiled with CFR 0.152.
 */
package com.xebia.ad.service.impl;

import com.xebia.ad.dao.ChangeDao;
import com.xebia.ad.dao.ConfigurationItemHandleDao;
import com.xebia.ad.repository.metadata.Change;
import com.xebia.ad.repository.metadata.ChangePlan;
import com.xebia.ad.repository.metadata.ConfigurationItemHandle;
import com.xebia.ad.repository.metadata.ConfigurationItemRevision;
import com.xebia.ad.repository.resolvers.RepositoryView;
import com.xebia.ad.service.ChangePlanService;
import com.xebia.ad.service.RepositoryService;
import com.xebia.ad.service.UserService;
import com.xebia.ad.support.Triple;
import com.xebialabs.deployit.ci.Deployment;
import com.xebialabs.deployit.ci.DeploymentPackage;
import com.xebialabs.deployit.ci.artifact.Ear;
import com.xebialabs.deployit.ci.artifact.StaticContent;
import com.xebialabs.deployit.ci.security.AccessControlEntry;
import com.xebialabs.deployit.ci.security.PermissionScheme;
import com.xebialabs.deployit.mapper.Pair;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.transaction.annotation.Transactional;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Transactional
public class SecuredRepositoryServiceImpl
implements RepositoryService {
    @Autowired
    public UserService userService;
    @Autowired
    public ChangePlanService changePlanService;
    @Autowired
    @Qualifier(value="unsecuredRepositoryService")
    public RepositoryService unsecuredRepositoryService;
    @Autowired
    public ConfigurationItemHandleDao configurationItemHandleDao;
    @Autowired
    private ChangeDao changeDao;
    private Logger logger = Logger.getLogger(SecuredRepositoryServiceImpl.class);

    public void setUserService(UserService userService) {
        this.userService = userService;
    }

    public void setChangePlanService(ChangePlanService changePlanService) {
        this.changePlanService = changePlanService;
    }

    public void setUnsecuredRepositoryService(RepositoryService unsecuredRepositoryService) {
        this.unsecuredRepositoryService = unsecuredRepositoryService;
    }

    public void setConfigurationItemHandleDao(ConfigurationItemHandleDao configurationItemHandleDao) {
        this.configurationItemHandleDao = configurationItemHandleDao;
    }

    public void setChangeDao(ChangeDao changeDao) {
        this.changeDao = changeDao;
    }

    @Override
    public Collection<Pair<ConfigurationItemRevision, AccessControlEntry>> getActualRevisions() {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)"Asking unsecured repository services for all the actual revisions");
        }
        Collection<Pair<ConfigurationItemRevision, AccessControlEntry>> allActuals = this.unsecuredRepositoryService.getActualRevisions();
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Adding security information to " + allActuals.size() + " actual revisons"));
        }
        ArrayList<Pair<ConfigurationItemRevision, AccessControlEntry>> visibleActuals = new ArrayList<Pair<ConfigurationItemRevision, AccessControlEntry>>();
        for (Pair<ConfigurationItemRevision, AccessControlEntry> p : allActuals) {
            ConfigurationItemRevision revision = (ConfigurationItemRevision)p.getFirst();
            AccessControlEntry permissions = this.getPermissionsForCurrentUser(revision);
            if (!permissions.isCanView()) continue;
            p.setSecond((Object)permissions);
            visibleActuals.add(p);
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)"Done");
        }
        return visibleActuals;
    }

    @Override
    public Pair<ConfigurationItemRevision, AccessControlEntry> findActualRevisionByHandleId(int handleId) {
        Pair<ConfigurationItemRevision, AccessControlEntry> actual = this.unsecuredRepositoryService.findActualRevisionByHandleId(handleId);
        if (actual == null) {
            return null;
        }
        ConfigurationItemRevision revision = (ConfigurationItemRevision)actual.getFirst();
        AccessControlEntry permissions = this.getPermissionsForCurrentUser(revision);
        if (!permissions.isCanView()) {
            return null;
        }
        return new Pair((Object)revision, (Object)permissions);
    }

    @Override
    public Pair<ConfigurationItemRevision, AccessControlEntry> findActualRevisionByLabel(String label) {
        Pair<ConfigurationItemRevision, AccessControlEntry> actual = this.unsecuredRepositoryService.findActualRevisionByLabel(label);
        if (actual == null) {
            return null;
        }
        ConfigurationItemRevision revision = (ConfigurationItemRevision)actual.getFirst();
        AccessControlEntry permissions = this.getPermissionsForCurrentUser(revision);
        if (!permissions.isCanView()) {
            return null;
        }
        return new Pair((Object)revision, (Object)permissions);
    }

    @Override
    public Pair<ConfigurationItemRevision, AccessControlEntry> findPreviousRevisionByHandleId(int handleId) {
        Pair<ConfigurationItemRevision, AccessControlEntry> actual = this.unsecuredRepositoryService.findPreviousRevisionByHandleId(handleId);
        if (actual == null) {
            return null;
        }
        ConfigurationItemRevision revision = (ConfigurationItemRevision)actual.getFirst();
        AccessControlEntry permissions = this.getPermissionsForCurrentUser(revision);
        if (!permissions.isCanView()) {
            return null;
        }
        return new Pair((Object)revision, (Object)permissions);
    }

    @Override
    public Triple<ConfigurationItemRevision, Change, AccessControlEntry> findDesignRevisionByLabel(String label) {
        Triple<ConfigurationItemRevision, Change, AccessControlEntry> result = this.unsecuredRepositoryService.findDesignRevisionByLabel(label);
        if (result == null) {
            return null;
        }
        ConfigurationItemRevision revision = result.getFirst();
        AccessControlEntry permissions = this.getPermissionsForCurrentUser(revision);
        if (!permissions.isCanView()) {
            return null;
        }
        result.setThird(permissions);
        return result;
    }

    @Override
    public Object getConfigurationItemDetailsObject(int detailsId) {
        Object details = this.unsecuredRepositoryService.getConfigurationItemDetailsObject(detailsId);
        AccessControlEntry permissions = this.getPermissionsForCurrentUser(this.getConfigurationItemRevision(detailsId));
        if (!permissions.isCanView()) {
            throw new SecurityException("No permission to view the details of this CI");
        }
        return details;
    }

    @Override
    public ConfigurationItemHandle addConfigurationItem(String label, String description, String type, ConfigurationItemRevision newRevision) {
        if (!this.currentUserMayAdd(newRevision)) {
            throw new SecurityException("Current user has no permission to add new configuraton item with label \"" + label + "\"");
        }
        this.validatePermissionScheme(label, newRevision);
        return this.unsecuredRepositoryService.addConfigurationItem(label, description, type, newRevision);
    }

    private void validatePermissionScheme(String label, ConfigurationItemRevision newRevision) {
        if (this.isPermissionSchemeSet(label, newRevision)) {
            this.checkPermissionSchemeAllowsTypeOfNewRevision(label, newRevision);
        } else if (!this.userService.isCurrentUserAdministrator()) {
            this.trySetDefaultPermissionScheme(label, newRevision);
        }
    }

    private boolean isPermissionSchemeSet(String label, ConfigurationItemRevision newRevision) {
        return newRevision.getPermissionScheme() != null;
    }

    private void checkPermissionSchemeAllowsTypeOfNewRevision(String label, ConfigurationItemRevision newRevision) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Checking that permission scheme set for new configuration item \"" + label + "\" allows its type"));
        }
        PermissionScheme scheme = newRevision.getPermissionScheme();
        String shortType = this.getShortTypeName(newRevision);
        if (!scheme.getAllowedCiTypes().contains(shortType)) {
            throw new IllegalArgumentException("Permission scheme \"" + newRevision + "\" is not applicable for configuration items of type \"" + shortType + "\"");
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Checked that permission scheme set for new configuration item \"" + label + "\" allows its type"));
        }
    }

    private void trySetDefaultPermissionScheme(String label, ConfigurationItemRevision newRevision) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Trying to set default permission scheme for new configuration item \"" + label + "\""));
        }
        List<ConfigurationItemHandle> possibleDefaultPermissionSchemes = this.findPossibleDefaultPermissionSchemes(label, newRevision);
        String ERROR_MESSAGE_PREFIX = "No permission scheme set for new configuration item \"";
        switch (possibleDefaultPermissionSchemes.size()) {
            case 0: {
                throw new IllegalArgumentException("No permission scheme set for new configuration item \"" + label + "\". Cannot set default as no permission scheme allows this new configuration item");
            }
            case 1: {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Setting default permission scheme for new configuration item \"" + label + "\""));
                }
                ConfigurationItemHandle defaultPermissionSchemeHandle = possibleDefaultPermissionSchemes.get(0);
                newRevision.setPermissionSchemeHandle(defaultPermissionSchemeHandle);
                break;
            }
            default: {
                ArrayList<String> schemeLabels = new ArrayList<String>();
                for (ConfigurationItemHandle eachSchemeHandle : possibleDefaultPermissionSchemes) {
                    schemeLabels.add(eachSchemeHandle.getLabel());
                }
                throw new IllegalArgumentException("No permission scheme set for new configuration item \"" + label + "\". Cannot set default as more than one permission scheme allows the type: [" + StringUtils.join(schemeLabels, (String)", ") + "]");
            }
        }
    }

    private List<ConfigurationItemHandle> findPossibleDefaultPermissionSchemes(String label, ConfigurationItemRevision newRevision) {
        ArrayList<ConfigurationItemHandle> possibleDefaultPermissionSchemes = new ArrayList<ConfigurationItemHandle>();
        List<ConfigurationItemHandle> schemeHandles = this.configurationItemHandleDao.findHandlesWithActualRevisionOfType(PermissionScheme.class.getName());
        for (ConfigurationItemHandle eachSchemeHandle : schemeHandles) {
            ConfigurationItemRevision actualRevision = eachSchemeHandle.getActualRevision();
            if (actualRevision == null || !actualRevision.isOfType(PermissionScheme.class.getName())) continue;
            PermissionScheme scheme = (PermissionScheme)actualRevision.getDetailsObject(RepositoryView.getActualView());
            String shortType = this.getShortTypeName(newRevision);
            if (!scheme.getAllowedCiTypes().contains(shortType)) continue;
            possibleDefaultPermissionSchemes.add(eachSchemeHandle);
        }
        return possibleDefaultPermissionSchemes;
    }

    private String getShortTypeName(ConfigurationItemRevision newRevision) {
        String type = newRevision.getType();
        int lastDot = type.lastIndexOf(46);
        String shortType = type.substring(lastDot + 1);
        return shortType;
    }

    @Override
    public void updateConfigurationItem(ConfigurationItemHandle existingHandle, String label, String description, ConfigurationItemRevision newRevision) {
        ChangePlan changePlan = this.changePlanService.getOrCreateCurrentChangePlan();
        existingHandle.addRevision(newRevision);
        if (!this.currentUserMayUpdate(newRevision, label, description, changePlan)) {
            throw new SecurityException("Current user has no permission to modify this CI");
        }
        this.unsecuredRepositoryService.updateConfigurationItem(existingHandle, label, description, newRevision);
    }

    @Override
    public void deleteConfigurationItem(ConfigurationItemHandle existingHandle) {
        ChangePlan changePlan = this.changePlanService.getOrCreateCurrentChangePlan();
        Change c = this.changeDao.findChangeForChangePlanAndHandle(changePlan, existingHandle);
        ConfigurationItemRevision revisionToDelete = c == null ? existingHandle.getActualRevision() : c.getApplicableRevision();
        existingHandle.addRevision(revisionToDelete);
        if (!this.currentUserMayDelete(changePlan, revisionToDelete)) {
            throw new SecurityException("Current user has no permission to modify this CI");
        }
        this.unsecuredRepositoryService.deleteConfigurationItem(existingHandle);
    }

    @Override
    public void undoConfigurationItem(ConfigurationItemHandle existingHandle) {
        this.unsecuredRepositoryService.undoConfigurationItem(existingHandle);
    }

    private boolean currentUserMayAdd(ConfigurationItemRevision revision) {
        if (this.getGlobalPermissionsForCurrentUser().isCanModify()) {
            return true;
        }
        return this.getGlobalPermissionsForCurrentUser().isCanRedeploy() && (revision.isOfType(DeploymentPackage.class.getName()) || revision.isOfType(Ear.class.getName()) || revision.isOfType(StaticContent.class.getName()) || revision.isOfType(StaticContent.class.getName()));
    }

    private boolean currentUserMayUpdate(ConfigurationItemRevision revision, String label, String description, ChangePlan changePlan) {
        AccessControlEntry permissions = this.getPermissionsForCurrentUser(revision);
        if (permissions.isCanModify()) {
            return true;
        }
        if (permissions.isCanRedeploy() && revision.getType().equals(Deployment.class.getName())) {
            ConfigurationItemHandle designSourceHandle = revision.getRelatedCiHandle("source");
            ConfigurationItemHandle designTargetHandle = revision.getRelatedCiHandle("target");
            ConfigurationItemHandle actualSourceHandle = revision.getHandle().getActualRevision().getRelatedCiHandle("source");
            ConfigurationItemHandle actualtargetHandle = revision.getHandle().getActualRevision().getRelatedCiHandle("target");
            ConfigurationItemHandle actuaApplicationHandle = actualSourceHandle.getActualRevision().getRelatedCiHandle("application");
            Change c = this.changeDao.findChangeForChangePlanAndHandle(changePlan, designSourceHandle);
            ConfigurationItemRevision designSourceRevision = c == null ? designSourceHandle.getActualRevision() : c.getApplicableRevision();
            ConfigurationItemHandle designApplicationHandle = designSourceRevision.getRelatedCiHandle("application");
            boolean sourcesAreMemberOfSameApplication = actuaApplicationHandle.equals(designApplicationHandle);
            boolean targetsAreIdentical = designTargetHandle.equals(actualtargetHandle);
            if (sourcesAreMemberOfSameApplication && targetsAreIdentical) {
                return true;
            }
        }
        return false;
    }

    private boolean currentUserMayDelete(ChangePlan changePlan, ConfigurationItemRevision revision) {
        AccessControlEntry permissions = this.getPermissionsForCurrentUser(revision);
        return permissions.isCanModify();
    }

    @Override
    public AccessControlEntry getGlobalPermissionsForCurrentUser() {
        String username = this.userService.getCurrentUsername();
        List<String> userGroups = this.userService.getCurrentUserGroups();
        if (this.userService.isCurrentUserAdministrator()) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("All global permissions were granted to administrative user " + username));
            }
            return AccessControlEntry.getAllPermissions((String)username);
        }
        List<ConfigurationItemHandle> allPermissionSchemes = this.configurationItemHandleDao.findHandlesWithActualRevisionOfType(PermissionScheme.class.getName());
        AccessControlEntry permissions = AccessControlEntry.getNoPermissions((String)username);
        for (ConfigurationItemHandle actual : allPermissionSchemes) {
            PermissionScheme scheme = (PermissionScheme)actual.getActualRevision().getDetailsObject(RepositoryView.getActualView());
            permissions.merge(scheme.getApplicablePermissions(username, userGroups));
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Global permissions " + permissions + " were granted to user " + username));
        }
        return permissions;
    }

    @Override
    public AccessControlEntry getPermissionsForCurrentUser(ConfigurationItemRevision revision) {
        String username = this.userService.getCurrentUsername();
        if (this.userService.isCurrentUserAdministrator()) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("All permissions on " + revision.getHandle() + " were granted to administrative user " + username));
            }
            return AccessControlEntry.getAllPermissions((String)username);
        }
        List<String> userGroups = this.userService.getCurrentUserGroups();
        PermissionScheme scheme = revision.getPermissionScheme();
        AccessControlEntry permissions = scheme != null ? scheme.getApplicablePermissions(username, userGroups) : AccessControlEntry.getNoPermissions((String)username);
        if (revision.getType().equals(PermissionScheme.class.getName())) {
            PermissionScheme domain = (PermissionScheme)revision.getDetailsObject(RepositoryView.getActualView());
            block0: for (String userGroup : this.userService.getCurrentUserGroups()) {
                for (AccessControlEntry aclEntry : domain.getAccessControlEntries()) {
                    if (!aclEntry.getGroupName().equals(userGroup)) continue;
                    permissions.setCanView(true);
                    break block0;
                }
            }
        }
        if (this.logger.isDebugEnabled()) {
            StringBuffer b = new StringBuffer();
            b.append(permissions + " permissions on " + revision.getHandle() + " were granted to user " + username);
            this.logger.debug((Object)b);
        }
        return permissions;
    }

    @Override
    public ConfigurationItemRevision getConfigurationItemRevision(int detailsId) {
        ConfigurationItemRevision configurationItemRevision = this.unsecuredRepositoryService.getConfigurationItemRevision(detailsId);
        return configurationItemRevision;
    }
}

