/*
 * Decompiled with CFR 0.152.
 */
package com.xebia.ad.service.impl;

import com.xebia.ad.repository.ConfigurationItemTypeDescriptorRepository;
import com.xebia.ad.repository.metadata.ChangePlan;
import com.xebia.ad.repository.metadata.ConfigurationItemHandle;
import com.xebia.ad.repository.metadata.ConfigurationItemRevision;
import com.xebia.ad.repository.resolvers.RepositoryView;
import com.xebia.ad.service.ConfigurationItemMetaData;
import com.xebia.ad.service.dto.DTOFactory;
import com.xebia.ad.service.impl.ConfigurationItemUpdateCommand;
import com.xebialabs.deployit.ResolutionException;
import com.xebialabs.deployit.ci.Deployment;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConfigurationItemUpdateCommandPreprocessor {
    @Autowired
    public ConfigurationItemTypeDescriptorRepository repository;
    @Autowired
    public DTOFactory dtoFactory;

    public List<ConfigurationItemUpdateCommand> preprocessUpdateCommand(ChangePlan changePlan, ConfigurationItemUpdateCommand updateCommand) {
        if (updateCommand.getNewRevision().getType().equals(Deployment.class.getName())) {
            return this.updateMappings(changePlan, updateCommand);
        }
        return Collections.singletonList(updateCommand);
    }

    private List<ConfigurationItemUpdateCommand> updateMappings(ChangePlan changePlan, ConfigurationItemUpdateCommand updateCommand) {
        ArrayList<ConfigurationItemUpdateCommand> commands = new ArrayList<ConfigurationItemUpdateCommand>();
        commands.add(updateCommand);
        RepositoryView view = RepositoryView.getDesignView(changePlan);
        ConfigurationItemRevision deploymentRevision = updateCommand.getNewRevision();
        ConfigurationItemHandle packageHandle = deploymentRevision.getRelatedCiHandle("source");
        ConfigurationItemRevision packageRevision = view.getViewRevision(packageHandle);
        HashSet<ConfigurationItemHandle> packageMemberHandles = new HashSet<ConfigurationItemHandle>();
        packageMemberHandles.addAll(packageRevision.getRelatedCiHandles("deployableArtifacts"));
        packageMemberHandles.addAll(packageRevision.getRelatedCiHandles("middlewareResources"));
        Set<ConfigurationItemHandle> mappingHandles = deploymentRevision.getRelatedCiHandles("mappings");
        block0: for (ConfigurationItemHandle mappingHandle : mappingHandles) {
            ConfigurationItemRevision mappingRevision = view.getViewRevision(mappingHandle);
            ConfigurationItemHandle mappingSourceHandle = mappingRevision.getRelatedCiHandle("source");
            if (packageMemberHandles.contains(mappingSourceHandle)) continue;
            Serializable mappingSource = view.getViewDetails(mappingSourceHandle);
            for (ConfigurationItemHandle eachPackageMemberHandle : packageMemberHandles) {
                Serializable eachPackageMember = view.getViewDetails(eachPackageMemberHandle);
                if (!this.repository.isSimilar(eachPackageMember, mappingSource)) continue;
                commands.add(this.createMappingUpdateCommand(view, mappingRevision, eachPackageMemberHandle));
                continue block0;
            }
            throw new ResolutionException("Cannot update mapping \"" + mappingHandle.getLabel() + "\" as there is no similar artifact or resource in the new package");
        }
        return commands;
    }

    private ConfigurationItemUpdateCommand createMappingUpdateCommand(RepositoryView view, ConfigurationItemRevision mappingRevision, ConfigurationItemHandle newMappingSourceHandle) {
        ConfigurationItemHandle mappingHandle = mappingRevision.getHandle();
        String mappingLabel = mappingHandle.getLabel();
        String mappingDescription = mappingHandle.getDescription();
        ConfigurationItemMetaData metadata = this.dtoFactory.createActualConfigurationItemMetaData(mappingRevision, null, null);
        metadata.getCiRelationsHandleIds().put("source", Collections.singletonList(newMappingSourceHandle.getId()));
        ConfigurationItemRevision newMappingRevision = this.dtoFactory.createConfigurationItemRevision(metadata, mappingRevision.getDetailsObject(view));
        return new ConfigurationItemUpdateCommand(mappingHandle, mappingLabel, mappingDescription, newMappingRevision);
    }
}

