/*
 * Decompiled with CFR 0.152.
 */
package com.xebia.ad.cli;

import java.io.File;
import java.io.IOException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class ServerIndexAnalyzer {
    public static void main(String[] args) {
        ServerIndexAnalyzer analyzer = new ServerIndexAnalyzer();
        Document doc = analyzer.parseServerIndex();
        analyzer.analyze(doc, "server1");
    }

    private void analyze(Document doc, String server) {
        NodeList serverEntries = doc.getElementsByTagName("serverEntries");
        for (int i = 0; serverEntries != null && i < serverEntries.getLength(); ++i) {
            Node serverEntry = serverEntries.item(i);
            NamedNodeMap attributes = serverEntry.getAttributes();
            Node serverType = attributes.getNamedItem("serverType");
            Node serverName = attributes.getNamedItem("serverName");
            if (serverType == null || serverName == null) continue;
            String serverTypeValue = serverType.getNodeValue();
            String serverNameValue = serverName.getNodeValue();
            if (!serverTypeValue.equals("APPLICATION_SERVER") || !serverNameValue.equals(server)) continue;
            Element serverEntryElement = (Element)serverEntry;
            NodeList specialEndpoints = serverEntryElement.getElementsByTagName("specialEndpoints");
            for (int j = 0; specialEndpoints != null && j < specialEndpoints.getLength(); ++j) {
                Element specialEndpoint = (Element)specialEndpoints.item(j);
                String endPointName = specialEndpoint.getAttributes().getNamedItem("endPointName").getNodeValue();
                NodeList endPoints = specialEndpoint.getElementsByTagName("endPoint");
                Node endPoint = endPoints.item(0);
                String host = endPoint.getAttributes().getNamedItem("host").getNodeValue();
                String port = endPoint.getAttributes().getNamedItem("port").getNodeValue();
                System.out.println("[name=" + endPointName + " host=" + host + " port=" + port + "]");
            }
        }
    }

    public Document parseServerIndex() {
        DocumentBuilder docBuilder;
        File serverIndex = new File("./src/test/resources/serverindexExample.xml");
        Document doc = null;
        DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
        docBuilderFactory.setIgnoringElementContentWhitespace(true);
        try {
            docBuilder = docBuilderFactory.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            System.out.println("Wrong parser configuration: " + e.getMessage());
            return null;
        }
        try {
            doc = docBuilder.parse(serverIndex);
        }
        catch (SAXException e) {
            System.out.println("Wrong XML file structure: " + e.getMessage());
            return null;
        }
        catch (IOException e) {
            System.out.println("Could not read source file: " + e.getMessage());
        }
        return doc;
    }
}

